/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIMemory {
    long addr;
    long[] data = new long[0];
    String ascii = "";

    public MIMemory(MITuple mITuple) {
        this.parse(mITuple);
    }

    public long getAddress() {
        return this.addr;
    }

    public long[] getData() {
        return this.data;
    }

    public String getAscii() {
        return this.ascii;
    }

    public String toSting() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("addr=\"" + Long.toHexString(this.addr) + "\"");
        stringBuffer.append("data=[");
        int n = 0;
        while (n < this.data.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('\"').append(Long.toHexString(this.data[n])).append('\"');
            ++n;
        }
        stringBuffer.append(']');
        if (this.ascii.length() > 0) {
            stringBuffer.append(",ascii=\"" + this.ascii + "\"");
        }
        return stringBuffer.toString();
    }

    void parse(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue != null && mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getCString();
            }
            if (string.equals("addr")) {
                try {
                    this.addr = Long.decode(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("data")) {
                if (mIValue != null && mIValue instanceof MIList) {
                    this.parseData((MIList)mIValue);
                }
            } else if (string.equals("ascii")) {
                this.ascii = string2;
            }
            ++n;
        }
    }

    void parseData(MIList mIList) {
        MIValue[] mIValueArray = mIList.getMIValues();
        this.data = new long[mIValueArray.length];
        int n = 0;
        while (n < mIValueArray.length) {
            if (mIValueArray[n] instanceof MIConst) {
                String string = ((MIConst)mIValueArray[n]).getCString();
                try {
                    this.data[n] = Long.decode(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.data[n] = 0L;
                }
            }
            ++n;
        }
    }
}

