/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IToken;

public class FunctionMacroDescriptor
implements IMacroDescriptor {
    private String name;
    private List identifierParameters;
    private List tokenizedExpansion;
    private String signature;
    private String expansionSignature;

    public FunctionMacroDescriptor(String string, List list, List list2, String string2, String string3) {
        this.name = string;
        this.identifierParameters = list;
        this.tokenizedExpansion = list2;
        this.signature = string2;
        this.expansionSignature = string3;
    }

    public final List getParameters() {
        return this.identifierParameters;
    }

    public final List getTokenizedExpansion() {
        return this.tokenizedExpansion;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = this.getParameters().size();
        stringBuffer.append("MacroDescriptor with name=" + this.getName() + "\n");
        stringBuffer.append("Number of parameters = " + n + "\n");
        Iterator iterator = this.getParameters().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringBuffer.append("Parameter #" + n2++ + " with name=" + (String)iterator.next() + "\n");
        }
        n = this.getTokenizedExpansion().size();
        iterator = this.getTokenizedExpansion().iterator();
        stringBuffer.append("Number of tokens = " + n + "\n");
        n2 = 0;
        while (iterator.hasNext()) {
            stringBuffer.append("Token #" + n2++ + " is " + ((IToken)iterator.next()).toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public final String getCompleteSignature() {
        return this.signature;
    }

    public boolean compatible(IMacroDescriptor iMacroDescriptor) {
        if (iMacroDescriptor.getName() == null) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion() == null) {
            return false;
        }
        if (iMacroDescriptor.getParameters() == null) {
            return false;
        }
        if (iMacroDescriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (!this.name.equals(iMacroDescriptor.getName())) {
            return false;
        }
        if (iMacroDescriptor.getParameters().size() != this.identifierParameters.size()) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion().size() != this.tokenizedExpansion.size()) {
            return false;
        }
        if (!iMacroDescriptor.getParameters().containsAll(this.identifierParameters)) {
            return false;
        }
        return iMacroDescriptor.getTokenizedExpansion().containsAll(this.tokenizedExpansion);
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.FUNCTION_LIKE;
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }
}

