/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.IAsyncExecutor;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.core.DebugConfiguration;
import org.eclipse.cdt.debug.internal.core.SessionManager;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class CDebugCorePlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 1000;
    private static CDebugCorePlugin plugin;
    private HashMap fDebugConfigurations;
    private IAsyncExecutor fAsyncExecutor = null;
    private SessionManager fSessionManager = null;

    public CDebugCorePlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
    }

    public static CDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugCorePlugin.getDefault() == null) {
            return "org.eclipse.cdt.debug.core";
        }
        return CDebugCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(Throwable throwable) {
        DebugException debugException;
        IStatus iStatus;
        Throwable throwable2 = throwable;
        if (throwable instanceof DebugException && (iStatus = (debugException = (DebugException)throwable).getStatus()).getException() != null) {
            throwable2 = iStatus.getException();
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", throwable2));
    }

    public static void log(IStatus iStatus) {
        CDebugCorePlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(String string) {
        CDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 1000, string, null));
    }

    private void initializeDebugConfiguration() {
        IPluginDescriptor iPluginDescriptor = CDebugCorePlugin.getDefault().getDescriptor();
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint("CDebugger");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            DebugConfiguration debugConfiguration = new DebugConfiguration(iConfigurationElement);
            this.fDebugConfigurations.put(debugConfiguration.getID(), debugConfiguration);
            ++n;
        }
    }

    public ICDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new ICDebugConfiguration[0]);
    }

    public ICDebugConfiguration getDebugConfiguration(String string) throws CoreException {
        ICDebugConfiguration iCDebugConfiguration;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((iCDebugConfiguration = (ICDebugConfiguration)this.fDebugConfigurations.get(string)) == null) {
            Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 100, "No such debugger", null);
            throw new CoreException((IStatus)status);
        }
        return iCDebugConfiguration;
    }

    public void shutdown() throws CoreException {
        this.setSessionManager(null);
        this.resetBreakpointsInstallCount();
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        this.resetBreakpointsInstallCount();
        this.setSessionManager(new SessionManager());
    }

    protected void resetBreakpointsInstallCount() {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof CBreakpoint) {
                try {
                    ((CBreakpoint)iBreakpointArray[n]).resetInstallCount();
                }
                catch (CoreException coreException) {
                    CDebugCorePlugin.log(coreException.getStatus());
                }
            }
            ++n;
        }
    }

    public void setAsyncExecutor(IAsyncExecutor iAsyncExecutor) {
        this.fAsyncExecutor = iAsyncExecutor;
    }

    public void asyncExec(Runnable runnable) {
        if (this.fAsyncExecutor != null) {
            this.fAsyncExecutor.asyncExec(runnable);
        }
    }

    protected SessionManager getSessionManager() {
        return this.fSessionManager;
    }

    protected void setSessionManager(SessionManager sessionManager) {
        if (this.fSessionManager != null) {
            this.fSessionManager.dispose();
        }
        this.fSessionManager = sessionManager;
    }

    public void saveCommonSourceLocations(ICSourceLocation[] iCSourceLocationArray) {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SOURCE_LOCATIONS, SourceUtils.getCommonSourceLocationsMemento(iCSourceLocationArray));
    }

    public ICSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_SOURCE_LOCATIONS));
    }
}

