/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;

public class CopyElementsOperation
extends MultiOperation {
    public CopyElementsOperation(ICElement[] iCElementArray, ICElement[] iCElementArray2, boolean bl) {
        super(iCElementArray, iCElementArray2, bl);
    }

    public CopyElementsOperation(ICElement[] iCElementArray, ICElement iCElement, boolean bl) {
        this(iCElementArray, new ICElement[]{iCElement}, bl);
    }

    protected String getMainTaskName() {
        return "operation.copyElementProgress";
    }

    protected CModelOperation getNestedOperation(ICElement iCElement) {
        iCElement.getElementType();
        return null;
    }

    protected void processElement(ICElement iCElement) throws CModelException {
        CModelOperation cModelOperation = this.getNestedOperation(iCElement);
        if (cModelOperation == null) {
            return;
        }
        boolean bl = cModelOperation instanceof CreateElementInTUOperation;
        if (bl) {
            Object object;
            CreateElementInTUOperation createElementInTUOperation = (CreateElementInTUOperation)cModelOperation;
            ICElement iCElement2 = (ICElement)this.fInsertBeforeElements.get(iCElement);
            if (iCElement2 != null) {
                createElementInTUOperation.setRelativePosition(iCElement2, 3);
            } else if (this.isRename() && (object = this.resolveRenameAnchor(iCElement)) != null) {
                createElementInTUOperation.setRelativePosition((ICElement)object, 2);
            }
            object = this.getNewNameFor(iCElement);
            if (object != null) {
                createElementInTUOperation.setAlteredName((String)object);
            }
        }
        this.executeNestedOperation(cModelOperation, 1);
    }

    private ICElement resolveRenameAnchor(ICElement iCElement) throws CModelException {
        IParent iParent = (IParent)((Object)iCElement.getParent());
        ICElement[] iCElementArray = iParent.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            ICElement iCElement2 = iCElementArray[n];
            if (iCElement2.equals(iCElement)) {
                return iCElement2;
            }
            ++n;
        }
        return null;
    }

    protected ICModelStatus verify() {
        ICModelStatus iCModelStatus = super.verify();
        if (!iCModelStatus.isOK()) {
            return iCModelStatus;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new CModelStatus(980);
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void verify(ICElement iCElement) throws CModelException {
        if (iCElement == null || !iCElement.exists()) {
            this.error(969, iCElement);
        }
        if (iCElement.getElementType() < 60) {
            this.error(967, iCElement);
        }
        if (iCElement.isReadOnly()) {
            this.error(976, iCElement);
        }
        ICElement iCElement2 = this.getDestinationParent(iCElement);
        this.verifyDestination(iCElement, iCElement2);
        this.verifySibling(iCElement, iCElement2);
        if (this.fRenamingsList != null) {
            this.verifyRenaming(iCElement);
        }
    }
}

