/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.IncludePattern;
import org.eclipse.cdt.internal.core.search.matching.MacroDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class CSearchPattern
implements ICSearchConstants,
ICSearchPattern,
IIndexConstants {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    private static Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
    private static final IParserLogService nullLog = new NullLogService();
    protected int _matchMode;
    protected boolean _caseSensitive;
    protected ICSearchConstants.LimitTo _limitTo;

    public CSearchPattern(int n, boolean bl, ICSearchConstants.LimitTo limitTo) {
        this._matchMode = n;
        this._caseSensitive = bl;
        this._limitTo = limitTo;
    }

    public CSearchPattern() {
    }

    public ICSearchConstants.LimitTo getLimitTo() {
        return this._limitTo;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limitTo) {
        return limitTo == this.getLimitTo();
    }

    public static CSearchPattern createPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        CSearchPattern cSearchPattern = null;
        if (searchFor == ICSearchConstants.TYPE || searchFor == ICSearchConstants.CLASS || searchFor == ICSearchConstants.STRUCT || searchFor == ICSearchConstants.ENUM || searchFor == ICSearchConstants.UNION || searchFor == ICSearchConstants.CLASS_STRUCT || searchFor == ICSearchConstants.TYPEDEF) {
            cSearchPattern = CSearchPattern.createClassPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.METHOD || searchFor == ICSearchConstants.FUNCTION) {
            cSearchPattern = CSearchPattern.createMethodPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.FIELD || searchFor == ICSearchConstants.VAR) {
            cSearchPattern = CSearchPattern.createFieldPattern(string, searchFor, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.NAMESPACE) {
            cSearchPattern = CSearchPattern.createNamespacePattern(string, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.MACRO) {
            cSearchPattern = CSearchPattern.createMacroPattern(string, limitTo, n, bl);
        } else if (searchFor == ICSearchConstants.INCLUDE) {
            cSearchPattern = CSearchPattern.createIncludePattern(string, limitTo, n, bl);
        }
        return cSearchPattern;
    }

    private static CSearchPattern createIncludePattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        return new IncludePattern(string.toCharArray(), n, limitTo, bl);
    }

    private static CSearchPattern createMacroPattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo != ICSearchConstants.DECLARATIONS && limitTo != ICSearchConstants.ALL_OCCURRENCES) {
            return null;
        }
        return new MacroDeclarationPattern(string.toCharArray(), n, ICSearchConstants.DECLARATIONS, bl);
    }

    private static CSearchPattern createNamespacePattern(String string, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.DEFINITIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(string, ICSearchConstants.REFERENCES, n, bl));
            return orPattern;
        }
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((Reader)new StringReader(string), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, null);
        char[] cArray = (char[])linkedList.removeLast();
        char[][] cArray2 = new char[][]{};
        return new NamespaceDeclarationPattern(cArray, (char[][])linkedList.toArray((T[])cArray2), n, limitTo, bl);
    }

    private static CSearchPattern createFieldPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            orPattern.addPattern(CSearchPattern.createFieldPattern(string, searchFor, ICSearchConstants.DEFINITIONS, n, bl));
            return orPattern;
        }
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((Reader)new StringReader(string), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, null);
        char[] cArray = (char[])linkedList.removeLast();
        char[][] cArray2 = new char[][]{};
        return new FieldDeclarationPattern(cArray, (char[][])linkedList.toArray((T[])cArray2), n, searchFor, limitTo, bl);
    }

    private static CSearchPattern createMethodPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            orPattern.addPattern(CSearchPattern.createMethodPattern(string, searchFor, ICSearchConstants.DEFINITIONS, n, bl));
            return orPattern;
        }
        int n2 = string.indexOf(40);
        String string2 = n2 == -1 ? "" : string.substring(n2);
        String string3 = n2 == -1 ? string : string.substring(0, n2);
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((Reader)new StringReader(string3), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, null);
        LinkedList linkedList2 = CSearchPattern.scanForParameters(string2);
        char[] cArray = (char[])linkedList.removeLast();
        char[][] cArray2 = new char[][]{};
        cArray2 = (char[][])linkedList.toArray((T[])cArray2);
        char[][] cArray3 = new char[][]{};
        cArray3 = (char[][])linkedList2.toArray((T[])cArray3);
        return new MethodDeclarationPattern(cArray, cArray2, cArray3, n, searchFor, limitTo, bl);
    }

    private static CSearchPattern createClassPattern(String string, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int n, boolean bl) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(string, searchFor, ICSearchConstants.DECLARATIONS, n, bl));
            orPattern.addPattern(CSearchPattern.createClassPattern(string, searchFor, ICSearchConstants.REFERENCES, n, bl));
            return orPattern;
        }
        if (searchFor == ICSearchConstants.CLASS_STRUCT) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(string, ICSearchConstants.CLASS, limitTo, n, bl));
            orPattern.addPattern(CSearchPattern.createClassPattern(string, ICSearchConstants.STRUCT, limitTo, n, bl));
            return orPattern;
        }
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((Reader)new StringReader(string), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog);
        }
        catch (ParserFactoryError parserFactoryError) {}
        IToken iToken = null;
        try {
            iToken = iScanner.nextToken();
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (ScannerException scannerException) {}
        if (iToken != null) {
            boolean bl2 = true;
            if (iToken.getType() == 65) {
                searchFor = ICSearchConstants.CLASS;
            } else if (iToken.getType() == 109) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (iToken.getType() == 119) {
                searchFor = ICSearchConstants.UNION;
            } else if (iToken.getType() == 77) {
                searchFor = ICSearchConstants.ENUM;
            } else if (iToken.getType() == 116) {
                searchFor = ICSearchConstants.TYPEDEF;
            } else {
                bl2 = false;
            }
            if (bl2) {
                iToken = null;
            }
        }
        LinkedList linkedList = CSearchPattern.scanForNames(iScanner, iToken);
        char[] cArray = (char[])linkedList.removeLast();
        char[][] cArray2 = new char[][]{};
        return new ClassDeclarationPattern(cArray, (char[][])linkedList.toArray((T[])cArray2), searchFor, limitTo, n, bl);
    }

    private static LinkedList scanForParameters(String string) {
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        if (string == null || string.equals("")) {
            return linkedList;
        }
        String string2 = "void f " + string + ";";
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((Reader)new StringReader(string2), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)new NullLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        IQuickParseCallback iQuickParseCallback = ParserFactory.createQuickParseCallback();
        IParser iParser = null;
        try {
            iParser = ParserFactory.createParser(iScanner, (ISourceElementRequestor)iQuickParseCallback, (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        if (iParser.parse()) {
            IASTCompilationUnit iASTCompilationUnit = iQuickParseCallback.getCompilationUnit();
            Iterator iterator = null;
            try {
                iterator = iASTCompilationUnit.getDeclarations();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            if (iterator == null || !iterator.hasNext()) {
                return null;
            }
            IASTFunction iASTFunction = (IASTFunction)iterator.next();
            Iterator iterator2 = iASTFunction.getParameters();
            char[] cArray = null;
            while (iterator2.hasNext()) {
                cArray = CSearchPattern.getParamString((IASTParameterDeclaration)iterator2.next());
                linkedList.add(cArray);
            }
            if (cArray == null) {
                cArray = "void ".toCharArray();
                linkedList.add(cArray);
            }
        }
        return linkedList;
    }

    public static char[] getParamString(IASTParameterDeclaration iASTParameterDeclaration) {
        Iterator iterator;
        Object object;
        if (iASTParameterDeclaration == null) {
            return null;
        }
        String string = "";
        IASTTypeSpecifier iASTTypeSpecifier = iASTParameterDeclaration.getTypeSpecifier();
        if (iASTTypeSpecifier instanceof IASTSimpleTypeSpecifier) {
            object = (IASTSimpleTypeSpecifier)iASTTypeSpecifier;
            string = String.valueOf(string) + object.getTypename();
        } else if (iASTTypeSpecifier instanceof IASTElaboratedTypeSpecifier) {
            object = (IASTElaboratedTypeSpecifier)iASTTypeSpecifier;
            if (object.getClassKind() == ASTClassKind.CLASS) {
                string = String.valueOf(string) + "class ";
            } else if (object.getClassKind() == ASTClassKind.ENUM) {
                string = String.valueOf(string) + "enum ";
            } else if (object.getClassKind() == ASTClassKind.STRUCT) {
                string = String.valueOf(string) + "struct ";
            } else if (object.getClassKind() == ASTClassKind.UNION) {
                string = String.valueOf(string) + "union";
            }
            string = String.valueOf(string) + object.getName();
        } else if (iASTTypeSpecifier instanceof IASTClassSpecifier) {
            object = (IASTClassSpecifier)iASTTypeSpecifier;
            string = String.valueOf(string) + object.getName();
        } else if (iASTTypeSpecifier instanceof IASTEnumerationSpecifier) {
            object = (IASTEnumerationSpecifier)iASTTypeSpecifier;
            string = String.valueOf(string) + object.getName();
        }
        string = String.valueOf(string) + " ";
        if (iASTParameterDeclaration.isConst()) {
            string = String.valueOf(string) + "const ";
        }
        if (iASTParameterDeclaration.isVolatile()) {
            string = String.valueOf(string) + "volatile ";
        }
        object = iASTParameterDeclaration.getPointerOperators();
        while (object.hasNext()) {
            iterator = (ASTPointerOperator)object.next();
            if (iterator == ASTPointerOperator.POINTER) {
                string = String.valueOf(string) + " * ";
                continue;
            }
            if (iterator == ASTPointerOperator.REFERENCE) {
                string = String.valueOf(string) + " & ";
                continue;
            }
            if (iterator == ASTPointerOperator.CONST_POINTER) {
                string = String.valueOf(string) + " const * ";
                continue;
            }
            if (iterator != ASTPointerOperator.VOLATILE_POINTER) continue;
            string = String.valueOf(string) + " volatile * ";
        }
        iterator = iASTParameterDeclaration.getArrayModifiers();
        while (iterator.hasNext()) {
            iterator.next();
            string = String.valueOf(string) + " [] ";
        }
        return string.toCharArray();
    }

    private static LinkedList scanForNames(IScanner iScanner, IToken iToken) {
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        String string = new String("");
        try {
            IToken iToken2 = iToken != null ? iToken : iScanner.nextToken();
            IToken iToken3 = null;
            iScanner.setThrowExceptionOnBadCharacterRead(true);
            boolean bl = false;
            boolean bl2 = false;
            block9: while (true) {
                switch (iToken2.getType()) {
                    case 3: {
                        linkedList.addLast(string.toCharArray());
                        string = new String("");
                        bl2 = false;
                        break;
                    }
                    case 95: {
                        string = String.valueOf(string) + iToken2.getImage() + " ";
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (iToken2.getType() == 23 || iToken2.getType() == 7) {
                            bl = true;
                        } else if (!bl && !bl2 && string.length() > 0 && iToken3.getType() != 1 && iToken3.getType() != 42 && iToken3.getType() != 34 && iToken3.getType() != 10 && iToken2.getType() != 11 && iToken2.getType() != 46) {
                            string = String.valueOf(string) + " ";
                        } else {
                            bl = false;
                        }
                        string = String.valueOf(string) + iToken2.getImage();
                        bl2 = false;
                    }
                }
                iToken3 = iToken2;
                iToken2 = null;
                while (true) {
                    if (iToken2 != null) continue block9;
                    try {
                        iToken2 = iScanner.nextToken();
                    }
                    catch (ScannerException scannerException) {
                        if (scannerException.getProblem().getID() != 0x1000001) continue;
                        if (!bl && !bl2) {
                            string = String.valueOf(string) + " ";
                        }
                        string = String.valueOf(string) + "\\";
                        bl = true;
                        bl2 = false;
                        iToken3 = null;
                    }
                }
                break;
            }
        }
        catch (EndOfFileException endOfFileException) {
            linkedList.addLast(string.toCharArray());
        }
        catch (ScannerException scannerException) {}
        return linkedList;
    }

    protected boolean matchesName(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return true;
        }
        if (cArray2 != null) {
            switch (this._matchMode) {
                case 0: {
                    return CharOperation.equals(cArray, cArray2, this._caseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(cArray, cArray2, this._caseSensitive);
                }
                case 2: {
                    if (!this._caseSensitive) {
                        cArray = CharOperation.toLowerCase(cArray);
                    }
                    return CharOperation.match(cArray, cArray2, this._caseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchQualifications(char[][] cArray, char[][] cArray2) {
        int n;
        int n2;
        int n3 = cArray != null ? cArray.length : 0;
        int n4 = n2 = cArray2 != null ? cArray2.length : 0;
        if (n3 == 0) {
            return true;
        }
        int n5 = n = cArray[0].length == 0 ? 1 : 0;
        if (n == 1 && n2 != n3 - 1 || n == 0 && n2 < n3) {
            return false;
        }
        int n6 = 1;
        while (n6 <= n3 - n) {
            if (!this.matchesName(cArray[n3 - n6], cArray2[n2 - n6])) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex iIndex, IIndexSearchRequestor iIndexSearchRequestor, int n, IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope) throws IOException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput blocksIndexInput = new BlocksIndexInput(iIndex.getIndexFile());
        try {
            ((IndexInput)blocksIndexInput).open();
            this.findIndexMatches(blocksIndexInput, iIndexSearchRequestor, n, iProgressMonitor, iCSearchScope);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)blocksIndexInput).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)blocksIndexInput).close();
    }

    public void findIndexMatches(IndexInput indexInput, IIndexSearchRequestor iIndexSearchRequestor, int n, IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope) throws IOException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        char[] cArray = this.indexEntryPrefix();
        if (cArray == null) {
            return;
        }
        IEntryResult[] iEntryResultArray = indexInput.queryEntriesPrefixedBy(cArray);
        if (iEntryResultArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = iEntryResultArray.length;
        while (n2 < n3) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult iEntryResult = iEntryResultArray[n2];
            this.resetIndexInfo();
            this.decodeIndexEntry(iEntryResult);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(iIndexSearchRequestor, n, iEntryResult.getFileReferences(), indexInput, iCSearchScope);
            }
            ++n2;
        }
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, IndexInput var4, ICSearchScope var5) throws IOException;

    protected abstract void resetIndexInfo();

    protected abstract void decodeIndexEntry(IEntryResult var1);

    public abstract char[] indexEntryPrefix();

    protected abstract boolean matchIndexEntry();

    public abstract int matchLevel(ISourceElementCallbackDelegate var1, ICSearchConstants.LimitTo var2);

    protected static class Requestor
    extends NullSourceElementRequestor {
        public Requestor(ParserMode parserMode) {
            super(parserMode);
        }

        public boolean acceptProblem(IProblem iProblem) {
            if (iProblem.getID() == 0x1000001) {
                return false;
            }
            return super.acceptProblem(iProblem);
        }
    }
}

