/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalExitInfo;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElementErrorStatus;
import org.eclipse.cdt.debug.core.model.ICDebugTargetType;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.model.IState;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.cdt.debug.internal.ui.CDTValueDetailProvider;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.editors.CDebugEditor;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDTDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private static CDTDebugModelPresentation fInstance = null;
    private OverlayImageCache fImageCache = new OverlayImageCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public CDTDebugModelPresentation() {
        fInstance = this;
    }

    public static CDTDebugModelPresentation getDefault() {
        return fInstance;
    }

    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.fAttributes.put(string, object);
        }
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        CDTValueDetailProvider.getDefault().computeDetail(iValue, iValueDetailListener);
    }

    public IEditorInput getEditorInput(Object object) {
        IResource iResource;
        if (object instanceof IMarker && (iResource = ((IMarker)object).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)iResource);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof ICAddressBreakpoint) {
            return this.getDisassemblyEditorInput((ICAddressBreakpoint)object);
        }
        if (object instanceof ICLineBreakpoint) {
            IResource iResource2 = ((ICLineBreakpoint)object).getMarker().getResource();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IFile)iResource2.getAdapter((Class)clazz)) != null) {
                return new FileEditorInput((IFile)iResource);
            }
        }
        if (object instanceof FileStorage) {
            return new ExternalEditorInput((IStorage)object);
        }
        if (object instanceof IDisassemblyStorage) {
            return new DisassemblyEditorInput((IStorage)object);
        }
        if (object instanceof FileNotFoundElement) {
            return new EditorInputDelegate((FileNotFoundElement)object);
        }
        return null;
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        if (iEditorInput instanceof EditorInputDelegate) {
            if (((EditorInputDelegate)iEditorInput).getDelegate() == null) {
                return CDebugEditor.EDITOR_ID;
            }
            return this.getEditorId(((EditorInputDelegate)iEditorInput).getDelegate(), object);
        }
        String string = null;
        if (iEditorInput != null) {
            IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iEditorInput.getName());
            String string2 = string = iEditorDescriptor != null ? iEditorDescriptor.getId() : "org.eclipse.cdt.ui.editor.CEditor";
        }
        if ("org.eclipse.cdt.ui.editor.CEditor".equals(string)) {
            return CDebugEditor.EDITOR_ID;
        }
        return string;
    }

    public Image getImage(Object object) {
        Image image = this.getBaseImage(object);
        if (image != null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            if (object instanceof ICDebugElementErrorStatus && !((ICDebugElementErrorStatus)object).isOK()) {
                switch (((ICDebugElementErrorStatus)object).getSeverity()) {
                    case 1: {
                        imageDescriptorArray[2] = CDebugImages.DESC_OVRS_WARNING;
                        break;
                    }
                    case 2: {
                        imageDescriptorArray[2] = CDebugImages.DESC_OVRS_ERROR;
                    }
                }
            }
            if (object instanceof ICVariable && ((ICVariable)object).isArgument()) {
                imageDescriptorArray[1] = CDebugImages.DESC_OVRS_ARGUMENT;
            }
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(image, imageDescriptorArray));
        }
        return null;
    }

    private Image getBaseImage(Object object) {
        if (object instanceof IDebugTarget) {
            ICDebugTargetType iCDebugTargetType;
            int n;
            IDebugTarget iDebugTarget = (IDebugTarget)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTargetType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int n2 = n = (iCDebugTargetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? iCDebugTargetType.getTargetType() : 0;
            if (n == 3) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            IDebugTarget iDebugTarget2 = (IDebugTarget)object;
            if (iDebugTarget2.isTerminated() || iDebugTarget2.isDisconnected()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET"));
        }
        if (object instanceof IThread) {
            ICDebugTargetType iCDebugTargetType;
            int n;
            IDebugTarget iDebugTarget = ((IThread)object).getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTargetType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int n3 = n = (iCDebugTargetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? iCDebugTargetType.getTargetType() : 0;
            if (n == 3) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            IThread iThread = (IThread)object;
            if (iThread.isSuspended()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"));
            }
            if (iThread.isTerminated()) {
                return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED"));
            }
            return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"));
        }
        try {
            IBreakpoint iBreakpoint;
            if (object instanceof IMarker && (iBreakpoint = this.getBreakpoint((IMarker)object)) != null && iBreakpoint instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)iBreakpoint);
            }
            if (object instanceof ICBreakpoint) {
                return this.getBreakpointImage((ICBreakpoint)object);
            }
            if (object instanceof IRegisterGroup) {
                return this.getRegisterGroupImage((IRegisterGroup)object);
            }
            if (object instanceof IExpression) {
                return this.getExpressionImage((IExpression)object);
            }
            if (object instanceof IRegister) {
                return this.getRegisterImage((IRegister)object);
            }
            if (object instanceof IVariable) {
                return this.getVariableImage((IVariable)object);
            }
            if (object instanceof ICSharedLibrary) {
                return this.getSharedLibraryImage((ICSharedLibrary)object);
            }
        }
        catch (CoreException coreException) {}
        return super.getImage(object);
    }

    public String getText(Object object) {
        StringBuffer stringBuffer = new StringBuffer(this.getBaseText(object));
        if (object instanceof ICDebugElementErrorStatus && !((ICDebugElementErrorStatus)object).isOK()) {
            stringBuffer.append(CDTDebugModelPresentation.getFormattedString(" <{0}>", ((ICDebugElementErrorStatus)object).getMessage()));
        }
        return stringBuffer.toString();
    }

    private String getBaseText(Object object) {
        boolean bl = this.isShowQualifiedNames();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (object instanceof ICSharedLibrary) {
                stringBuffer.append(this.getSharedLibraryText((ICSharedLibrary)object, bl));
                return stringBuffer.toString();
            }
            if (object instanceof IRegisterGroup) {
                stringBuffer.append(((IRegisterGroup)object).getName());
                return stringBuffer.toString();
            }
            if (object instanceof IVariable) {
                stringBuffer.append(this.getVariableText((IVariable)object));
                return stringBuffer.toString();
            }
            if (object instanceof IStackFrame) {
                stringBuffer.append(this.getStackFrameText((IStackFrame)object, bl));
                return stringBuffer.toString();
            }
            if (object instanceof IMarker) {
                IBreakpoint iBreakpoint = this.getBreakpoint((IMarker)object);
                if (iBreakpoint != null) {
                    return this.getBreakpointText(iBreakpoint, bl);
                }
                return null;
            }
            if (object instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)object, bl);
            }
            if (object instanceof IDebugTarget) {
                stringBuffer.append(this.getTargetText((IDebugTarget)object, bl));
            } else if (object instanceof IThread) {
                stringBuffer.append(this.getThreadText((IThread)object, bl));
            }
            if (object instanceof ITerminate && ((ITerminate)object).isTerminated()) {
                stringBuffer.insert(0, "<terminated>");
                return stringBuffer.toString();
            }
            if (object instanceof IDisconnect && ((IDisconnect)object).isDisconnected()) {
                stringBuffer.insert(0, "<disconnected>");
                return stringBuffer.toString();
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        catch (DebugException debugException) {
            return "<not_responding>";
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
        return null;
    }

    protected boolean isShowQualifiedNames() {
        Boolean bl = (Boolean)this.fAttributes.get(DISPLAY_FULL_PATHS);
        bl = bl == null ? Boolean.FALSE : bl;
        return bl;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean bl = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        bl = bl == null ? Boolean.FALSE : bl;
        return bl;
    }

    protected String getTargetText(IDebugTarget iDebugTarget, boolean bl) throws DebugException {
        if (iDebugTarget instanceof IState) {
            IState iState = (IState)iDebugTarget;
            switch (iState.getCurrentStateId()) {
                case 8: {
                    Object object = iState.getCurrentStateInfo();
                    String string = String.valueOf(iDebugTarget.getName()) + " (Exited";
                    if (object != null && object instanceof ICDISignalExitInfo) {
                        ICDISignalExitInfo iCDISignalExitInfo = (ICDISignalExitInfo)object;
                        string = String.valueOf(string) + MessageFormat.format(": Signal ''{0}'' received. Description: {1}.", iCDISignalExitInfo.getName(), iCDISignalExitInfo.getDescription());
                    } else if (object != null && object instanceof ICDIExitInfo) {
                        string = String.valueOf(string) + ". Exit code = " + ((ICDIExitInfo)object).getCode();
                    }
                    return String.valueOf(string) + ")";
                }
                case 7: {
                    return String.valueOf(iDebugTarget.getName()) + " (Suspended)";
                }
            }
        }
        return iDebugTarget.getName();
    }

    protected String getThreadText(IThread iThread, boolean bl) throws DebugException {
        ICDebugTargetType iCDebugTargetType;
        int n;
        String string = CDTDebugModelPresentation.getFormattedString("Thread [{0}]", iThread.getName());
        IDebugTarget iDebugTarget = iThread.getDebugTarget();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTargetType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int n2 = n = (iCDebugTargetType = (ICDebugTargetType)iDebugTarget.getAdapter((Class)clazz)) != null ? iCDebugTargetType.getTargetType() : 0;
        if (n == 3) {
            return string;
        }
        if (iThread.isTerminated()) {
            return CDTDebugModelPresentation.getFormattedString("{0} (Terminated)", string);
        }
        if (iThread.isStepping()) {
            return CDTDebugModelPresentation.getFormattedString("{0} (Stepping)", string);
        }
        if (!iThread.isSuspended()) {
            return CDTDebugModelPresentation.getFormattedString("{0} (Running)", string);
        }
        if (iThread.isSuspended()) {
            IState iState;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.IState");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iState = (IState)iThread.getAdapter((Class)clazz2)) != null) {
                Object object = iState.getCurrentStateInfo();
                if (object != null && object instanceof ICDISignalReceived) {
                    ICDISignal iCDISignal = ((ICDISignalReceived)object).getSignal();
                    String string2 = String.valueOf(string) + MessageFormat.format(" (Suspended: Signal ''{0}'' received. Description: {1})", iCDISignal.getName(), iCDISignal.getDescription());
                    return string2;
                }
                if (object != null && object instanceof ICDIWatchpointTrigger) {
                    String string3 = String.valueOf(string) + MessageFormat.format(" (Suspended: Watchpoint triggered. Old value: ''{0}''. New value: ''{1}'')", ((ICDIWatchpointTrigger)object).getOldValue(), ((ICDIWatchpointTrigger)object).getNewValue());
                    return string3;
                }
                if (object != null && object instanceof ICDIWatchpointScope) {
                    return String.valueOf(string) + " (Suspended: Watchpoint is out of scope)";
                }
                if (object != null && object instanceof ICDIBreakpointHit) {
                    return String.valueOf(string) + " (Suspended: Breakpoint hit)";
                }
                if (object != null && object instanceof ICDISharedLibraryEvent) {
                    return String.valueOf(string) + " (Suspended: Shared library event)";
                }
            }
        }
        return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Suspended)", iThread.getName());
    }

    protected String getStackFrameText(IStackFrame iStackFrame, boolean bl) throws DebugException {
        IStackFrameInfo iStackFrameInfo;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iStackFrameInfo = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(iStackFrameInfo.getLevel());
            stringBuffer.append(' ');
            String string = iStackFrameInfo.getFunction();
            if (string != null && (string = string.trim()).length() > 0) {
                Path path;
                stringBuffer.append(string);
                stringBuffer.append("() ");
                if (iStackFrameInfo.getFile() != null && !(path = new Path(iStackFrameInfo.getFile())).isEmpty()) {
                    stringBuffer.append("at ");
                    stringBuffer.append(bl ? path.toOSString() : path.lastSegment());
                    stringBuffer.append(":");
                    if (iStackFrameInfo.getFrameLineNumber() != 0) {
                        stringBuffer.append(iStackFrameInfo.getFrameLineNumber());
                    }
                }
            }
            if (this.isEmpty(string)) {
                stringBuffer.append("<symbol is not available>");
            }
            return stringBuffer.toString();
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.IDummyStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return iStackFrame.getAdapter((Class)clazz2) != null ? this.getDummyStackFrameLabel(iStackFrame) : iStackFrame.getName();
    }

    private String getDummyStackFrameLabel(IStackFrame iStackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    protected String getVariableText(IVariable iVariable) throws DebugException {
        StringBuffer stringBuffer = new StringBuffer();
        if (iVariable instanceof ICVariable) {
            Object object;
            String string;
            ICType iCType = null;
            try {
                iCType = ((ICVariable)iVariable).getType();
            }
            catch (DebugException debugException) {}
            if (iCType != null && this.isShowVariableTypeNames() && (string = this.getVariableTypeName(iCType)) != null && string.length() > 0) {
                stringBuffer.append(string);
                if (iCType.isArray()) {
                    object = iCType.getArrayDimensions();
                    int n = 0;
                    while (n < ((IValue)object).length) {
                        stringBuffer.append('[');
                        stringBuffer.append((int)object[n]);
                        stringBuffer.append(']');
                        ++n;
                    }
                }
                stringBuffer.append(' ');
            }
            if (!((ICVariable)iVariable).isEnabled()) {
                stringBuffer.append("<disabled> ");
            }
            if ((string = iVariable.getName()) != null) {
                stringBuffer.append(string.trim());
            }
            if ((object = iVariable.getValue()) instanceof ICValue && object.getValueString() != null) {
                String string2 = object.getValueString().trim();
                if (iCType != null && iCType.isCharacter()) {
                    if (string2.length() == 0) {
                        string2 = ".";
                    }
                    stringBuffer.append("= ");
                    stringBuffer.append(string2);
                } else if (iCType != null && iCType.isFloatingPointType()) {
                    Number number = CDebugUtils.getFloatingPointValue((ICValue)((ICValue)object));
                    if (CDebugUtils.isNaN((Number)number)) {
                        string2 = "NAN";
                    }
                    if (CDebugUtils.isPositiveInfinity((Number)number)) {
                        string2 = "Infinity";
                    }
                    if (CDebugUtils.isNegativeInfinity((Number)number)) {
                        string2 = "-Infinity";
                    }
                    stringBuffer.append("= ");
                    stringBuffer.append(string2);
                } else if ((iCType == null || !iCType.isArray() && !iCType.isStructure()) && string2.length() > 0) {
                    stringBuffer.append("= ");
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String getSharedLibraryText(ICSharedLibrary iCSharedLibrary, boolean bl) throws DebugException {
        String string = new String();
        Path path = new Path(iCSharedLibrary.getFileName());
        if (!path.isEmpty()) {
            string = String.valueOf(string) + (bl ? path.toOSString() : path.lastSegment());
        }
        return string;
    }

    public static String getFormattedString(String string, String string2) {
        return CDTDebugModelPresentation.getFormattedString(string, new String[]{string2});
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    protected Image getBreakpointImage(ICBreakpoint iCBreakpoint) throws CoreException {
        if (iCBreakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointImage((ICLineBreakpoint)iCBreakpoint);
        }
        if (iCBreakpoint instanceof ICWatchpoint) {
            return this.getWatchpointImage((ICWatchpoint)iCBreakpoint);
        }
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint iCLineBreakpoint) throws CoreException {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = iCLineBreakpoint.isEnabled() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT") : DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED");
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(imageDescriptor), this.computeBreakpointOverlays((ICBreakpoint)iCLineBreakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint iCWatchpoint) throws CoreException {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = iCWatchpoint.isEnabled() ? (iCWatchpoint.isReadType() && !iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!iCWatchpoint.isReadType() && iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (iCWatchpoint.isReadType() && !iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!iCWatchpoint.isReadType() && iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(imageDescriptor), this.computeBreakpointOverlays((ICBreakpoint)iCWatchpoint)));
    }

    protected IBreakpoint getBreakpoint(IMarker iMarker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(iMarker);
    }

    protected String getBreakpointText(IBreakpoint iBreakpoint, boolean bl) throws CoreException {
        if (iBreakpoint instanceof ICAddressBreakpoint) {
            return this.getAddressBreakpointText((ICAddressBreakpoint)iBreakpoint, bl);
        }
        if (iBreakpoint instanceof ICFunctionBreakpoint) {
            return this.getFunctionBreakpointText((ICFunctionBreakpoint)iBreakpoint, bl);
        }
        if (iBreakpoint instanceof ICLineBreakpoint) {
            return this.getLineBreakpointText((ICLineBreakpoint)iBreakpoint, bl);
        }
        if (iBreakpoint instanceof ICWatchpoint) {
            return this.getWatchpointText((ICWatchpoint)iBreakpoint, bl);
        }
        return "";
    }

    protected String getLineBreakpointText(ICLineBreakpoint iCLineBreakpoint, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendResourceName((ICBreakpoint)iCLineBreakpoint, stringBuffer, bl);
        this.appendLineNumber(iCLineBreakpoint, stringBuffer);
        this.appendIgnoreCount((ICBreakpoint)iCLineBreakpoint, stringBuffer);
        this.appendCondition((ICBreakpoint)iCLineBreakpoint, stringBuffer);
        return stringBuffer.toString();
    }

    protected String getWatchpointText(ICWatchpoint iCWatchpoint, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendResourceName((ICBreakpoint)iCWatchpoint, stringBuffer, bl);
        this.appendWatchExpression(iCWatchpoint, stringBuffer);
        this.appendIgnoreCount((ICBreakpoint)iCWatchpoint, stringBuffer);
        this.appendCondition((ICBreakpoint)iCWatchpoint, stringBuffer);
        return stringBuffer.toString();
    }

    protected String getAddressBreakpointText(ICAddressBreakpoint iCAddressBreakpoint, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendResourceName((ICBreakpoint)iCAddressBreakpoint, stringBuffer, bl);
        this.appendAddress(iCAddressBreakpoint, stringBuffer);
        this.appendIgnoreCount((ICBreakpoint)iCAddressBreakpoint, stringBuffer);
        this.appendCondition((ICBreakpoint)iCAddressBreakpoint, stringBuffer);
        return stringBuffer.toString();
    }

    protected String getFunctionBreakpointText(ICFunctionBreakpoint iCFunctionBreakpoint, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendResourceName((ICBreakpoint)iCFunctionBreakpoint, stringBuffer, bl);
        this.appendFunction(iCFunctionBreakpoint, stringBuffer);
        this.appendIgnoreCount((ICBreakpoint)iCFunctionBreakpoint, stringBuffer);
        this.appendCondition((ICBreakpoint)iCFunctionBreakpoint, stringBuffer);
        return stringBuffer.toString();
    }

    protected StringBuffer appendResourceName(ICBreakpoint iCBreakpoint, StringBuffer stringBuffer, boolean bl) throws CoreException {
        IPath iPath = iCBreakpoint.getMarker().getResource().getLocation();
        if (!iPath.isEmpty()) {
            stringBuffer.append(bl ? iPath.toOSString() : iPath.lastSegment());
        }
        return stringBuffer;
    }

    protected StringBuffer appendLineNumber(ICLineBreakpoint iCLineBreakpoint, StringBuffer stringBuffer) throws CoreException {
        int n = iCLineBreakpoint.getLineNumber();
        if (n > 0) {
            stringBuffer.append(" [");
            stringBuffer.append("line:");
            stringBuffer.append(' ');
            stringBuffer.append(n);
            stringBuffer.append(']');
        }
        return stringBuffer;
    }

    protected StringBuffer appendAddress(ICAddressBreakpoint iCAddressBreakpoint, StringBuffer stringBuffer) throws CoreException {
        try {
            long l = Long.parseLong(iCAddressBreakpoint.getAddress());
            stringBuffer.append(" [address: ");
            stringBuffer.append(CDebugUtils.toHexAddressString((long)l));
            stringBuffer.append(']');
        }
        catch (NumberFormatException numberFormatException) {}
        return stringBuffer;
    }

    protected StringBuffer appendFunction(ICFunctionBreakpoint iCFunctionBreakpoint, StringBuffer stringBuffer) throws CoreException {
        String string = iCFunctionBreakpoint.getFunction();
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" [");
            stringBuffer.append("function:");
            stringBuffer.append(' ');
            stringBuffer.append(string.trim());
            stringBuffer.append(']');
        }
        return stringBuffer;
    }

    protected StringBuffer appendIgnoreCount(ICBreakpoint iCBreakpoint, StringBuffer stringBuffer) throws CoreException {
        int n = iCBreakpoint.getIgnoreCount();
        if (n > 0) {
            stringBuffer.append(" [");
            stringBuffer.append("ignore count:");
            stringBuffer.append(' ');
            stringBuffer.append(n);
            stringBuffer.append(']');
        }
        return stringBuffer;
    }

    protected void appendCondition(ICBreakpoint iCBreakpoint, StringBuffer stringBuffer) throws CoreException {
        String string = iCBreakpoint.getCondition();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" if ");
            stringBuffer.append(string);
        }
    }

    private void appendWatchExpression(ICWatchpoint iCWatchpoint, StringBuffer stringBuffer) throws CoreException {
        String string = iCWatchpoint.getExpression();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" at '");
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
    }

    private ImageDescriptor[] computeBreakpointOverlays(ICBreakpoint iCBreakpoint) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
        try {
            if (iCBreakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[0] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (iCBreakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[2] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (iCBreakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[1] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (iCBreakpoint instanceof ICFunctionBreakpoint) {
                imageDescriptorArray[1] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
        return imageDescriptorArray;
    }

    protected Image getVariableImage(IVariable iVariable) throws DebugException {
        if (iVariable instanceof ICVariable) {
            ICType iCType = null;
            try {
                iCType = ((ICVariable)iVariable).getType();
            }
            catch (DebugException debugException) {}
            if (iCType != null && (iCType.isPointer() || iCType.isReference())) {
                return this.fDebugImageRegistry.get(((ICVariable)iVariable).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_POINTER : CDebugImages.DESC_OBJS_VARIABLE_POINTER_DISABLED);
            }
            if (((ICVariable)iVariable).hasChildren()) {
                return this.fDebugImageRegistry.get(((ICVariable)iVariable).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE : CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE_DISABLED);
            }
            return this.fDebugImageRegistry.get(((ICVariable)iVariable).isEnabled() ? CDebugImages.DESC_OBJS_VARIABLE_SIMPLE : CDebugImages.DESC_OBJS_VARIABLE_SIMPLE_DISABLED);
        }
        return null;
    }

    protected Image getRegisterGroupImage(IRegisterGroup iRegisterGroup) throws DebugException {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getRegisterImage(IRegister iRegister) throws DebugException {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER);
    }

    protected Image getExpressionImage(IExpression iExpression) throws DebugException {
        return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Image getSharedLibraryImage(ICSharedLibrary iCSharedLibrary) throws DebugException {
        if (iCSharedLibrary.areSymbolsLoaded()) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            imageDescriptorArray[1] = CDebugImages.DESC_OVRS_SYMBOLS;
            return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_LOADED_SHARED_LIBRARY), imageDescriptorArray));
        }
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
    }

    protected DisassemblyEditorInput getDisassemblyEditorInput(ICAddressBreakpoint iCAddressBreakpoint) {
        IDebugTarget[] iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = 0;
        while (n < iDebugTargetArray.length) {
            IResource iResource = iCAddressBreakpoint.getMarker().getResource();
            if (iResource != null && iResource instanceof IFile) {
                IDebugTarget iDebugTarget = iDebugTargetArray[n];
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iDebugTarget.getAdapter((Class)clazz) != null) {
                    String string = ((IFile)iResource).getLocation().toOSString();
                    IDebugTarget iDebugTarget2 = iDebugTargetArray[n];
                    Class<?> clazz2 = class$5;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (string.equals(((IExecFileInfo)iDebugTarget2.getAdapter((Class)clazz2)).getExecFile().getLocation().toOSString())) {
                        IDebugTarget iDebugTarget3 = iDebugTargetArray[n];
                        Class<?> clazz3 = class$6;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (iDebugTarget3.getAdapter((Class)clazz3) != null) {
                            try {
                                IStorage iStorage;
                                long l = Long.parseLong(iCAddressBreakpoint.getAddress());
                                IDebugTarget iDebugTarget4 = iDebugTargetArray[n];
                                Class<?> clazz4 = class$6;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((iStorage = (IStorage)((DisassemblyManager)iDebugTarget4.getAdapter((Class)clazz4)).getSourceElement(l)) != null) {
                                    return new DisassemblyEditorInput(iStorage);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
            }
            ++n;
        }
        return null;
    }

    private String getVariableTypeName(ICType iCType) {
        int n;
        String string = iCType.getName();
        if (iCType.isArray() && string != null && (n = string.indexOf(91)) != -1) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public void dispose() {
        this.fImageCache.disposeAll();
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

