/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DebugTextHover
implements ITextHover {
    private static final int MAX_HOVER_INFO_SIZE = 100;
    static /* synthetic */ Class class$0;

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            return null;
        }
        ILaunchManager iLaunchManager = debugPlugin.getLaunchManager();
        if (iLaunchManager == null) {
            return null;
        }
        IDebugTarget[] iDebugTargetArray = iLaunchManager.getDebugTargets();
        if (iDebugTargetArray != null && iDebugTargetArray.length > 0) {
            try {
                IDocument iDocument = iTextViewer.getDocument();
                if (iDocument == null) {
                    return null;
                }
                String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                if (string == null) {
                    return null;
                }
                if ((string = string.trim()).length() == 0) {
                    return null;
                }
                ArrayList<IDebugTarget> arrayList = new ArrayList<IDebugTarget>(iDebugTargetArray.length);
                int n = 0;
                while (n < iDebugTargetArray.length) {
                    ICExpressionEvaluator iCExpressionEvaluator;
                    IDebugTarget iDebugTarget = iDebugTargetArray[n];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iCExpressionEvaluator = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz)) != null) {
                        arrayList.add(iDebugTargetArray[n]);
                    }
                    ++n;
                }
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = arrayList.size() > 1;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ICExpressionEvaluator iCExpressionEvaluator;
                    IDebugTarget iDebugTarget = (IDebugTarget)iterator.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!(iCExpressionEvaluator = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz)).canEvaluate()) continue;
                    String string2 = this.evaluateExpression(iCExpressionEvaluator, string);
                    try {
                        if (string2 == null) continue;
                        DebugTextHover.appendVariable(stringBuffer, string, string2.trim(), bl ? iDebugTarget.getName() : null);
                    }
                    catch (DebugException debugException) {
                        CDebugUIPlugin.log(debugException);
                    }
                }
                if (stringBuffer.length() > 0) {
                    return stringBuffer.toString();
                }
            }
            catch (BadLocationException badLocationException) {
                CDebugUIPlugin.log(badLocationException);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null) {
            return CDebugUIUtils.findWord(iTextViewer.getDocument(), n);
        }
        return null;
    }

    private String evaluateExpression(ICExpressionEvaluator iCExpressionEvaluator, String string) {
        String string2 = null;
        try {
            string2 = iCExpressionEvaluator.evaluateExpressionToString(string);
        }
        catch (DebugException debugException) {}
        return string2;
    }

    private static void appendVariable(StringBuffer stringBuffer, String string, String string2, String string3) throws DebugException {
        if (string2.length() > 100) {
            string2 = String.valueOf(string2.substring(0, 100)) + " ...";
        }
        stringBuffer.append("<p>");
        if (string3 != null) {
            stringBuffer.append(String.valueOf('[') + string3 + "]&nbsp;");
        }
        stringBuffer.append(DebugTextHover.makeHTMLSafe(string));
        stringBuffer.append(" = ");
        String string4 = "<b>" + DebugTextHover.makeHTMLSafe(string2) + "</b>";
        stringBuffer.append(string4);
        stringBuffer.append("</p>");
    }

    private static String makeHTMLSafe(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n != string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

