/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListChangedRegisters;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterNames;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListChangedRegistersInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class RegisterManager
extends SessionObject
implements ICDIRegisterManager {
    private List regList;
    private boolean autoupdate = true;
    MIVarChange[] noChanges = new MIVarChange[0];

    public RegisterManager(Session session) {
        super(session);
        this.regList = Collections.synchronizedList(new ArrayList());
    }

    public ICDIRegisterObject[] getRegisterObjects() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataListRegisterNames mIDataListRegisterNames = commandFactory.createMIDataListRegisterNames();
        try {
            mISession.postCommand(mIDataListRegisterNames);
            MIDataListRegisterNamesInfo mIDataListRegisterNamesInfo = mIDataListRegisterNames.getMIDataListRegisterNamesInfo();
            if (mIDataListRegisterNamesInfo == null) {
                throw new CDIException("No answer");
            }
            String[] stringArray = mIDataListRegisterNamesInfo.getRegisterNames();
            ArrayList<RegisterObject> arrayList = new ArrayList<RegisterObject>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    arrayList.add(new RegisterObject(session.getCurrentTarget(), stringArray[n], n));
                }
                ++n;
            }
            return arrayList.toArray(new ICDIRegisterObject[0]);
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public ICDIRegister createRegister(ICDIRegisterObject iCDIRegisterObject) throws CDIException {
        RegisterObject registerObject = null;
        if (iCDIRegisterObject instanceof RegisterObject) {
            registerObject = (RegisterObject)iCDIRegisterObject;
        }
        if (registerObject != null) {
            Register register = this.getRegister(iCDIRegisterObject);
            if (register == null) {
                try {
                    String string = "$" + registerObject.getName();
                    Session session = (Session)this.getSession();
                    MISession mISession = session.getMISession();
                    CommandFactory commandFactory = mISession.getCommandFactory();
                    MIVarCreate mIVarCreate = commandFactory.createMIVarCreate(string);
                    mISession.postCommand(mIVarCreate);
                    MIVarCreateInfo mIVarCreateInfo = mIVarCreate.getMIVarCreateInfo();
                    if (mIVarCreateInfo == null) {
                        throw new CDIException("No answer");
                    }
                    register = new Register(registerObject, mIVarCreateInfo.getMIVar());
                    this.regList.add(register);
                }
                catch (MIException mIException) {
                    throw new MI2CDIException(mIException);
                }
            }
            return register;
        }
        throw new CDIException("Wrong register type");
    }

    public Register createRegister(RegisterObject registerObject, MIVar mIVar) throws CDIException {
        Register register = new Register(registerObject, mIVar);
        this.regList.add(register);
        return register;
    }

    public void destroyRegister(ICDIRegister iCDIRegister) {
        this.regList.remove(iCDIRegister);
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public Register getRegister(String string) {
        Register[] registerArray = this.getRegisters();
        int n = 0;
        while (n < registerArray.length) {
            if (registerArray[n].getMIVar().getVarName().equals(string)) {
                return registerArray[n];
            }
            try {
                Register register = (Register)registerArray[n].getChild(string);
                if (register != null) {
                    return register;
                }
            }
            catch (ClassCastException classCastException) {}
            ++n;
        }
        return null;
    }

    public Register getRegister(int n) {
        Register[] registerArray = this.getRegisters();
        int n2 = 0;
        while (n2 < registerArray.length) {
            if (registerArray[n2].getPosition() == n) {
                return registerArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIDataListChangedRegisters mIDataListChangedRegisters = commandFactory.createMIDataListChangedRegisters();
        try {
            mISession.postCommand(mIDataListChangedRegisters);
            MIDataListChangedRegistersInfo mIDataListChangedRegistersInfo = mIDataListChangedRegisters.getMIDataListChangedRegistersInfo();
            if (mIDataListChangedRegistersInfo == null) {
                throw new CDIException("No answer");
            }
            int[] nArray = mIDataListChangedRegistersInfo.getRegisterNumbers();
            ArrayList<MIChangedEvent> arrayList = new ArrayList<MIChangedEvent>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                Register register = this.getRegister(nArray[n]);
                if (register != null) {
                    String string = register.getMIVar().getVarName();
                    MIVarChange[] mIVarChangeArray = this.noChanges;
                    MIVarUpdate mIVarUpdate = commandFactory.createMIVarUpdate(string);
                    try {
                        mISession.postCommand(mIVarUpdate);
                        MIVarUpdateInfo mIVarUpdateInfo = mIVarUpdate.getMIVarUpdateInfo();
                        if (mIVarUpdateInfo == null) {
                            throw new CDIException("No answer");
                        }
                        mIVarChangeArray = mIVarUpdateInfo.getMIVarChanges();
                    }
                    catch (MIException mIException) {}
                    if (mIVarChangeArray.length != 0) {
                        int n2 = 0;
                        while (n2 < mIVarChangeArray.length) {
                            String string2 = mIVarChangeArray[n2].getVarName();
                            if (mIVarChangeArray[n2].isInScope()) {
                                arrayList.add(new MIVarChangedEvent(string2));
                            }
                            ++n2;
                        }
                    } else {
                        arrayList.add(new MIRegisterChangedEvent(mIVarUpdate.getToken(), register.getName(), nArray[n]));
                    }
                }
                ++n;
            }
            MIEvent[] mIEventArray = arrayList.toArray(new MIEvent[0]);
            mISession.fireEvents(mIEventArray);
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    private Register[] getRegisters() {
        return this.regList.toArray(new Register[0]);
    }

    private Register getRegister(ICDIRegisterObject iCDIRegisterObject) throws CDIException {
        Register[] registerArray = this.getRegisters();
        int n = 0;
        while (n < registerArray.length) {
            if (iCDIRegisterObject.getName().equals(registerArray[n].getName())) {
                return registerArray[n];
            }
            ++n;
        }
        return null;
    }
}

