/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListFramesInfo;

public class Thread
extends CObject
implements ICDIThread {
    static ICDIStackFrame[] noStack = new ICDIStackFrame[0];
    int id;
    ICDIStackFrame currentFrame;
    List currentFrames;
    int stackdepth = 0;
    static final int STACKFRAME_DEFAULT_DEPTH = 200;

    public Thread(ICDITarget iCDITarget, int n) {
        super(iCDITarget);
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public void updateState() {
        try {
            this.getCurrentStackFrame();
        }
        catch (CDIException cDIException) {}
    }

    public ICDIStackFrame getCurrentStackFrame() throws CDIException {
        ICDIStackFrame[] iCDIStackFrameArray;
        if (this.currentFrame == null && (iCDIStackFrameArray = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = iCDIStackFrameArray[0];
        }
        return this.currentFrame;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames() throws CDIException {
        block11: {
            CommandFactory commandFactory;
            int n = this.getStackFrameCount();
            if (this.currentFrames != null && this.currentFrames.size() >= n) break block11;
            this.currentFrames = new ArrayList();
            Session session = (Session)this.getTarget().getSession();
            Target target = (Target)session.getCurrentTarget();
            ICDIThread iCDIThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            try {
                try {
                    MISession mISession = session.getMISession();
                    commandFactory = mISession.getCommandFactory();
                    MIStackListFrames mIStackListFrames = commandFactory.createMIStackListFrames();
                    mISession.postCommand(mIStackListFrames);
                    MIStackListFramesInfo mIStackListFramesInfo = mIStackListFrames.getMIStackListFramesInfo();
                    if (mIStackListFramesInfo == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] mIFrameArray = mIStackListFramesInfo.getMIFrames();
                    int n2 = 0;
                    while (n2 < mIFrameArray.length) {
                        this.currentFrames.add(new StackFrame(this, mIFrameArray[n2], n - mIFrameArray[n2].getLevel()));
                        ++n2;
                    }
                }
                catch (MIException mIException) {
                }
                catch (CDIException cDIException) {}
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                target.setCurrentThread(iCDIThread, false);
                throw throwable;
            }
            {
                Object var11_14 = null;
            }
            target.setCurrentThread(iCDIThread, false);
            if (this.currentFrame == null) {
                int n3 = 0;
                while (n3 < this.currentFrames.size()) {
                    commandFactory = (ICDIStackFrame)this.currentFrames.get(n3);
                    if (commandFactory.getLevel() == n) {
                        this.currentFrame = commandFactory;
                    }
                    ++n3;
                }
            }
        }
        return this.currentFrames.toArray(noStack);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStackFrameCount() throws CDIException {
        if (this.stackdepth != 0) return this.stackdepth;
        Session session = (Session)this.getTarget().getSession();
        Target target = (Target)session.getCurrentTarget();
        ICDIThread iCDIThread = target.getCurrentThread();
        target.setCurrentThread(this, false);
        try {
            try {
                MISession mISession = session.getMISession();
                CommandFactory commandFactory = mISession.getCommandFactory();
                MIStackInfoDepth mIStackInfoDepth = commandFactory.createMIStackInfoDepth();
                mISession.postCommand(mIStackInfoDepth);
                MIStackInfoDepthInfo mIStackInfoDepthInfo = null;
                try {
                    mIStackInfoDepthInfo = mIStackInfoDepth.getMIStackInfoDepthInfo();
                    if (mIStackInfoDepthInfo == null) {
                        throw new CDIException("No answer");
                    }
                    this.stackdepth = mIStackInfoDepthInfo.getDepth();
                }
                catch (MIException mIException) {
                    mISession.postCommand(mIStackInfoDepth);
                    mIStackInfoDepthInfo = mIStackInfoDepth.getMIStackInfoDepthInfo();
                    if (mIStackInfoDepthInfo == null) {
                        throw new CDIException("No answer");
                    }
                    this.stackdepth = mIStackInfoDepthInfo.getDepth();
                    if (this.stackdepth > 0) {
                        --this.stackdepth;
                    }
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            target.setCurrentThread(iCDIThread, false);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        target.setCurrentThread(iCDIThread, false);
        return this.stackdepth;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames(int n, int n2) throws CDIException {
        Object object;
        block11: {
            int n3;
            if (this.currentFrames != null && this.currentFrames.size() >= n2) break block11;
            this.currentFrames = new ArrayList();
            object = (Session)this.getTarget().getSession();
            Target target = (Target)((Session)object).getCurrentTarget();
            ICDIThread iCDIThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            try {
                try {
                    n3 = this.getStackFrameCount();
                    int n4 = n2 < n3 ? Math.min(n3, 200) : n3;
                    MISession mISession = ((Session)object).getMISession();
                    CommandFactory commandFactory = mISession.getCommandFactory();
                    MIStackListFrames mIStackListFrames = commandFactory.createMIStackListFrames(0, n4);
                    mISession.postCommand(mIStackListFrames);
                    MIStackListFramesInfo mIStackListFramesInfo = mIStackListFrames.getMIStackListFramesInfo();
                    if (mIStackListFramesInfo == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] mIFrameArray = mIStackListFramesInfo.getMIFrames();
                    int n5 = 0;
                    while (n5 < mIFrameArray.length) {
                        this.currentFrames.add(new StackFrame(this, mIFrameArray[n5], n3 - mIFrameArray[n5].getLevel()));
                        ++n5;
                    }
                }
                catch (MIException mIException) {
                }
                catch (CDIException cDIException) {}
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                target.setCurrentThread(iCDIThread, false);
                throw throwable;
            }
            {
                Object var14_17 = null;
            }
            target.setCurrentThread(iCDIThread, false);
            if (this.currentFrame == null) {
                n3 = 0;
                while (n3 < this.currentFrames.size()) {
                    StackFrame stackFrame = (StackFrame)this.currentFrames.get(n3);
                    if (stackFrame.getMIFrame().getLevel() == 0) {
                        this.currentFrame = stackFrame;
                    }
                    ++n3;
                }
            }
        }
        object = n2 - n + 1 <= this.currentFrames.size() ? this.currentFrames.subList(n, n2 + 1) : this.currentFrames;
        return object.toArray(noStack);
    }

    public void setCurrentStackFrame(ICDIStackFrame iCDIStackFrame) throws CDIException {
        this.setCurrentStackFrame(iCDIStackFrame, true);
    }

    public void setCurrentStackFrame(ICDIStackFrame iCDIStackFrame, boolean bl) throws CDIException {
        ICDIStackFrame iCDIStackFrame2;
        int n = 0;
        if (iCDIStackFrame != null) {
            n = iCDIStackFrame.getLevel();
        }
        if ((iCDIStackFrame2 = this.getCurrentStackFrame()) != null && iCDIStackFrame2.getLevel() == n) {
            return;
        }
        try {
            Session session = (Session)this.getTarget().getSession();
            MISession mISession = session.getMISession();
            CommandFactory commandFactory = mISession.getCommandFactory();
            int n2 = this.getStackFrameCount() - n;
            MIStackSelectFrame mIStackSelectFrame = commandFactory.createMIStackSelectFrame(n2);
            ((Target)this.getTarget()).setCurrentThread(this, bl);
            mISession.postCommand(mIStackSelectFrame);
            MIInfo mIInfo = mIStackSelectFrame.getMIInfo();
            if (mIInfo == null) {
                throw new CDIException("No answer");
            }
            this.currentFrame = iCDIStackFrame;
            if (bl) {
                VariableManager variableManager;
                RegisterManager registerManager = (RegisterManager)session.getRegisterManager();
                if (registerManager.isAutoUpdate()) {
                    registerManager.update();
                }
                if ((variableManager = (VariableManager)session.getVariableManager()).isAutoUpdate()) {
                    variableManager.update();
                }
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void resume() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().resume();
    }

    public void stepInto() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepInto();
    }

    public void stepIntoInstruction() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepIntoInstruction();
    }

    public void stepOver() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepOver();
    }

    public void stepOverInstruction() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepOverInstruction();
    }

    public void stepReturn() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepReturn();
    }

    public void stepReturn(boolean bl) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepReturn(bl);
    }

    public void runUntil(ICDILocation iCDILocation) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().runUntil(iCDILocation);
    }

    public void suspend() throws CDIException {
        this.getTarget().suspend();
        this.getTarget().setCurrentThread((ICDIThread)this);
    }

    public void jump(ICDILocation iCDILocation) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().jump(iCDILocation);
    }

    public void signal() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().signal();
    }

    public void signal(ICDISignal iCDISignal) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().signal(iCDISignal);
    }

    public boolean equals(ICDIThread iCDIThread) {
        if (iCDIThread instanceof Thread) {
            Thread thread = (Thread)iCDIThread;
            return this.id == thread.getId();
        }
        return super.equals(iCDIThread);
    }
}

