/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakpointHitEvent
extends MIStoppedEvent {
    int bkptno;
    MIFrame frame;

    public MIBreakpointHitEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput);
        this.parse();
    }

    public MIBreakpointHitEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord);
        this.parse();
    }

    public int getNumber() {
        return this.bkptno;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("number=").append(this.bkptno).append('\n');
        stringBuffer.append("thread-id=").append(this.getThreadId()).append('\n');
        stringBuffer.append(this.frame.toString());
        return stringBuffer.toString();
    }

    void parse() {
        MIResult[] mIResultArray = null;
        MIExecAsyncOutput mIExecAsyncOutput = this.getMIExecAsyncOutput();
        MIResultRecord mIResultRecord = this.getMIResultRecord();
        if (mIExecAsyncOutput != null) {
            mIResultArray = mIExecAsyncOutput.getMIResults();
        } else if (mIResultRecord != null) {
            mIResultArray = mIResultRecord.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                String string2 = "";
                if (mIValue != null && mIValue instanceof MIConst) {
                    string2 = ((MIConst)mIValue).getString();
                }
                if (string.equals("bkptno")) {
                    try {
                        this.bkptno = Integer.parseInt(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("thread-id")) {
                    try {
                        int n2 = Integer.parseInt(string2.trim());
                        this.setThreadId(n2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("frame") && mIValue instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)mIValue);
                }
                ++n;
            }
        }
    }
}

