/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIArg {
    String name;
    String value;

    public MIArg(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static MIArg[] getMIArgs(MIList mIList) {
        ArrayList<MIArg> arrayList = new ArrayList<MIArg>();
        MIValue[] mIValueArray = mIList.getMIValues();
        int n = 0;
        while (n < mIValueArray.length) {
            MIArg mIArg;
            if (mIValueArray[n] instanceof MITuple && (mIArg = MIArg.getMIArg((MITuple)mIValueArray[n])) != null) {
                arrayList.add(mIArg);
            }
            ++n;
        }
        MIResult[] mIResultArray = mIList.getMIResults();
        int n2 = 0;
        while (n2 < mIResultArray.length) {
            MIValue mIValue = mIResultArray[n2].getMIValue();
            if (mIValue instanceof MIConst) {
                String string = ((MIConst)mIValue).getCString();
                arrayList.add(new MIArg(string, ""));
            }
            ++n2;
        }
        return arrayList.toArray(new MIArg[arrayList.size()]);
    }

    public static MIArg getMIArg(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        MIArg mIArg = null;
        if (mIResultArray.length == 2) {
            String string = "";
            MIValue mIValue = mIResultArray[0].getMIValue();
            string = mIValue != null && mIValue instanceof MIConst ? ((MIConst)mIValue).getCString() : "";
            String string2 = "";
            mIValue = mIResultArray[1].getMIValue();
            string2 = mIValue != null && mIValue instanceof MIConst ? ((MIConst)mIValue).getCString() : "";
            mIArg = new MIArg(string, string2);
        }
        return mIArg;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value;
    }
}

