/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoProgramInfo
extends MIInfo {
    int pid;

    public MIInfoProgramInfo(MIOutput mIOutput) {
        super(mIOutput);
        this.parse();
    }

    public int getPID() {
        return this.pid;
    }

    void parse() {
        if (this.isDone()) {
            MIOutput mIOutput = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = mIOutput.getMIOOBRecords();
            int n = 0;
            while (n < mIOOBRecordArray.length) {
                if (mIOOBRecordArray[n] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord mIStreamRecord = (MIStreamRecord)mIOOBRecordArray[n];
                    String string = mIStreamRecord.getString();
                    this.parseLine(string);
                }
                ++n;
            }
        }
    }

    void parseLine(String string) {
        if (string != null && string.length() > 0) {
            string = string.replace('.', ' ');
            if ((string = string.trim()).startsWith("Using")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!Character.isDigit(string2.charAt(0))) continue;
                    try {
                        this.pid = Integer.decode(string2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
    }
}

