/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.cdt.internal.corext.textmanipulation.NopTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;

public final class MoveTextEdit
extends TextEdit {
    private TextRange fTarget;
    private TextRange fSource;
    private int fPerformCounter;

    public MoveTextEdit(int n, int n2, int n3) {
        Assert.isTrue((n3 <= n || n + n2 <= n3 ? 1 : 0) != 0);
        this.fSource = new TextRange(n, n2);
        this.fTarget = new TextRange(n3);
    }

    private MoveTextEdit(TextRange textRange, TextRange textRange2) {
        this.fSource = textRange;
        this.fTarget = textRange2;
    }

    public TextRange getSourceRange() {
        return this.fSource;
    }

    public TextRange getTargetRange() {
        return this.fTarget;
    }

    public TextRange getTextRange() {
        return this.fSource;
    }

    public void connect(TextBufferEditor textBufferEditor) throws CoreException {
        textBufferEditor.add(new TargetMark(this.fTarget, this));
    }

    public TextEdit perform(TextBuffer textBuffer) throws CoreException {
        this.internalPerform(textBuffer);
        return new MoveTextEdit(this.fTarget, this.fSource);
    }

    public TextEdit copy() {
        TextRange textRange = this.getSourceRange();
        TextRange textRange2 = this.getTargetRange();
        return new MoveTextEdit(textRange.fOffset, textRange.fLength, textRange2.fOffset);
    }

    protected void internalPerform(TextBuffer textBuffer) throws CoreException {
        Assert.isTrue((this.fPerformCounter < 2 ? 1 : 0) != 0);
        if (++this.fPerformCounter == 2) {
            TextRange textRange = this.getSourceRange();
            TextRange textRange2 = this.getTargetRange();
            String string = textBuffer.getContent(textRange.fOffset, textRange.fLength);
            textBuffer.replace(textRange, "");
            textBuffer.replace(textRange2, string);
        }
    }

    boolean isUpMove() {
        return this.fSource.fOffset < this.fTarget.fOffset;
    }

    boolean isDownMove() {
        return this.fSource.fOffset > this.fTarget.fOffset;
    }

    TextRange getChildRange() {
        int n = this.fSource.fOffset;
        int n2 = this.fSource.fLength;
        int n3 = this.fTarget.fOffset;
        if (n3 <= n) {
            return new TextRange(n3, n + n2 - n3);
        }
        return new TextRange(n, n3 - n);
    }

    static class TargetMark
    extends NopTextEdit {
        private MoveTextEdit fMoveTextEdit;

        public TargetMark(TextRange textRange, MoveTextEdit moveTextEdit) {
            super(textRange);
            this.fMoveTextEdit = moveTextEdit;
        }

        MoveTextEdit getMoveTextEdit() {
            return this.fMoveTextEdit;
        }

        public TextEdit perform(TextBuffer textBuffer) throws CoreException {
            this.fMoveTextEdit.internalPerform(textBuffer);
            return super.perform(textBuffer);
        }

        public TextEdit copy() {
            Assert.isTrue((boolean)false, (String)"This should never happen");
            return super.copy();
        }
    }
}

