/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FileTransferDragAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider provider;
    static /* synthetic */ Class class$0;

    public FileTransferDragAdapter(ISelectionProvider iSelectionProvider) {
        this.provider = iSelectionProvider;
        Assert.isNotNull((Object)iSelectionProvider);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.doit = !this.getResources().isEmpty();
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        String[] stringArray = FileTransferDragAdapter.getResourceLocations(this.getResources());
        dragSourceEvent.data = stringArray.length != 0 ? stringArray : null;
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (dragSourceEvent.doit && dragSourceEvent.detail != 2 && (dragSourceEvent.detail == 0 || dragSourceEvent.detail == 8)) {
            FileTransferDragAdapter.runOperation((IRunnableWithProgress)new RefreshOperation(this.getResources()), true, false);
        }
    }

    private List getResources() {
        ArrayList<IResource> arrayList = Collections.EMPTY_LIST;
        ISelection iSelection = this.provider.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            arrayList = new ArrayList<IResource>(iStructuredSelection.size());
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return arrayList;
    }

    private static String[] getResourceLocations(List list) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            IResource iResource = (IResource)stringArray.next();
            IPath iPath = iResource.getLocation();
            if (iPath == null) continue;
            arrayList.add(iPath.toOSString());
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static void runOperation(IRunnableWithProgress iRunnableWithProgress, boolean bl, boolean bl2) {
        try {
            IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            Shell shell = iWorkbenchWindow.getShell();
            new ProgressMonitorDialog(shell).run(bl, bl2, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = CUIMessages.getString("Problem while moving or copying files.");
            String string2 = CUIMessages.getString("Drag & Drop");
            ExceptionHandler.handle(invocationTargetException, string2, string);
        }
    }

    private static class RefreshOperation
    extends WorkspaceModifyOperation {
        private final Set roots;

        public RefreshOperation(List list) {
            this.roots = new HashSet(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IResource iResource = (IResource)iterator.next();
                IContainer iContainer = iResource.getParent();
                this.roots.add(iContainer != null ? iContainer : iResource);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
            try {
                iProgressMonitor.beginTask(CUIMessages.getString("DragAdapter.refreshing"), this.roots.size());
                MultiStatus multiStatus = new MultiStatus(CUIPlugin.getPluginId(), 0, CUIMessages.getString("DragAdapter.problem"), null);
                Iterator iterator = this.roots.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (multiStatus.isOK()) break;
                        throw new CoreException((IStatus)multiStatus);
                    }
                    IResource iResource = (IResource)iterator.next();
                    try {
                        iResource.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    catch (CoreException coreException) {
                        multiStatus.add(coreException.getStatus());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            iProgressMonitor.done();
        }
    }
}

