/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class FileSearchAction
extends Action {
    private static final String PREFIX = "FileSearchAction.";
    private ISelectionProvider fSelectionProvider;

    public FileSearchAction(ISelectionProvider iSelectionProvider) {
        super(CUIPlugin.getResourceString("FileSearchAction.label"));
        this.setDescription(CUIPlugin.getResourceString("FileSearchAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("FileSearchAction.tooltip"));
        if (iSelectionProvider instanceof CContentOutlinePage) {
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
        }
        this.fSelectionProvider = iSelectionProvider;
    }

    public void run() {
        ICElement iCElement;
        String string;
        ISelection iSelection = this.fSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            string = ((ITextSelection)iSelection).getText();
            if (string.length() == 0) {
                return;
            }
        } else {
            iCElement = FileSearchAction.getElement(iSelection);
            if (iCElement == null) {
                return;
            }
            string = iCElement.getElementName();
        }
        iCElement = new TextSearchResultCollector();
        try {
            SearchUI.activateSearchResultView();
            TextSearchScope textSearchScope = TextSearchScope.newWorkspaceScope();
            String[] stringArray = CoreModel.getDefault().getTranslationUnitExtensions();
            int n = 0;
            while (n < stringArray.length) {
                textSearchScope.addExtension("*." + stringArray[n]);
                ++n;
            }
            TextSearchOperation textSearchOperation = new TextSearchOperation(CUIPlugin.getWorkspace(), string, "", (ISearchScope)textSearchScope, (TextSearchResultCollector)iCElement);
            ProgressMonitorDialog progressMonitorDialog = null;
            Shell shell = new Shell();
            if (progressMonitorDialog == null) {
                progressMonitorDialog = new ProgressMonitorDialog(shell);
            }
            try {
                progressMonitorDialog.run(true, true, (IRunnableWithProgress)textSearchOperation);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (String)"Error", (String)"Error");
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {}
    }

    private static ICElement getElement(ISelection iSelection) {
        Object e;
        List list;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (list = ((IStructuredSelection)iSelection).toList()).size() == 1 && (e = list.get(0)) instanceof ICElement) {
            return (ICElement)e;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection iSelection) {
        if (iSelection instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getLength() > 0;
        }
        return FileSearchAction.getElement(iSelection) != null;
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return iEditorRegistry.getDefaultEditor().getId();
        }
        return null;
    }
}

