/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.opentype;

import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.opentype.TypeSearchResultCollector;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TypeSearchOperation
implements IRunnableWithProgress {
    private final TypeSearchResultCollector collector = new TypeSearchResultCollector();
    private ICSearchScope scope;
    private IWorkspace workspace;
    private OrPattern pattern;
    private SearchEngine engine;

    public TypeSearchOperation(IWorkspace iWorkspace, ICSearchScope iCSearchScope, SearchEngine searchEngine) {
        this.workspace = iWorkspace;
        this.scope = iCSearchScope;
        this.engine = searchEngine;
        this.pattern = new OrPattern();
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS_STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.UNION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        this.pattern.addPattern(SearchEngine.createSearchPattern((String)"*", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
    }

    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
        this.collector.setProgressMonitor(iProgressMonitor);
        try {
            this.engine.search(this.workspace, (ICSearchPattern)this.pattern, this.scope, (ICSearchResultCollector)this.collector, true);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    public Object[] getResults() {
        return this.collector.getSearchResults().toArray();
    }
}

