/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.io.IOException;
import org.eclipse.cdt.internal.ui.text.CCodeReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class CPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;
    protected CCodeReader fReader = new CCodeReader();

    public CPairMatcher(char[] cArray) {
        this.fPairs = cArray;
    }

    public IRegion match(IDocument iDocument, int n) {
        this.fOffset = n;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = iDocument;
        if (this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void clear() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
        this.fReader = null;
    }

    protected boolean matchPairsAt() {
        int n = this.fPairs.length;
        int n2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char c = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int n3 = 0;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fStartPos = this.fOffset - 1;
                    n = n3;
                }
                n3 += 2;
            }
            n3 = 1;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fEndPos = this.fOffset - 1;
                    n2 = n3;
                }
                n3 += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[n2 - 1], this.fPairs[n2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            } else if (this.fStartPos > -1) {
                this.fAnchor = 1;
                this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[n], this.fPairs[n + 1], this.fDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    protected int searchForClosingPeer(int n, int n2, int n3, IDocument iDocument) throws IOException {
        this.fReader.configureForwardReader(iDocument, n + 1, iDocument.getLength(), true, true);
        int n4 = 1;
        int n5 = this.fReader.read();
        while (n5 != -1) {
            if (n5 == n2 && n5 != n3) {
                ++n4;
            } else if (n5 == n3) {
                --n4;
            }
            if (n4 == 0) {
                return this.fReader.getOffset();
            }
            n5 = this.fReader.read();
        }
        return -1;
    }

    protected int searchForOpeningPeer(int n, int n2, int n3, IDocument iDocument) throws IOException {
        this.fReader.configureBackwardReader(iDocument, n, true, true);
        int n4 = 1;
        int n5 = this.fReader.read();
        while (n5 != -1) {
            if (n5 == n3 && n5 != n2) {
                ++n4;
            } else if (n5 == n2) {
                --n4;
            }
            if (n4 == 0) {
                return this.fReader.getOffset();
            }
            n5 = this.fReader.read();
        }
        return -1;
    }
}

