/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class CParameterListValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int fPosition;
    private ITextViewer fViewer;
    private IContextInformation fInformation;
    private int fCurrentParameter;

    public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
        this.fPosition = n;
        this.fViewer = iTextViewer;
        this.fInformation = iContextInformation;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != '*' || ++n >= n2 || iDocument.getChar(n) != '/') continue;
            return n + 1;
        }
        return n2;
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        while (n < n2) {
            char c2 = iDocument.getChar(n);
            ++n;
            if (c2 == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            return n;
        }
        return n2;
    }

    private int getCharCount(IDocument iDocument, int n, int n2, char c, char c2, boolean bl) throws BadLocationException {
        Assert.isTrue(((c != '\u0000' || c2 != '\u0000') && c != c2 ? 1 : 0) != 0);
        int n3 = 0;
        int n4 = 0;
        block5: while (n < n2) {
            char c3 = iDocument.getChar(n++);
            switch (c3) {
                case '/': {
                    if (n >= n2) continue block5;
                    char c4 = iDocument.getChar(n);
                    if (c4 == '*') {
                        n = this.getCommentEnd(iDocument, n + 1, n2);
                        break;
                    }
                    if (c4 != '/') continue block5;
                    n = n2;
                    break;
                }
                case '*': {
                    char c4;
                    if (n >= n2 || (c4 = iDocument.getChar(n)) != '/') continue block5;
                    n4 = 0;
                    ++n;
                    break;
                }
                case '\"': 
                case '\'': {
                    n = this.getStringEnd(iDocument, n, n2, c3);
                    break;
                }
                default: {
                    if (bl) {
                        if ('(' == c3) {
                            ++n3;
                        } else if (')' == c3) {
                            --n3;
                        }
                        if (n3 != 0) continue block5;
                    }
                    if (c != '\u0000' && c3 == c) {
                        ++n4;
                    }
                    if (c2 == '\u0000' || c3 != c2) continue block5;
                    --n4;
                }
            }
        }
        return n4;
    }

    public boolean isContextInformationValid(int n) {
        try {
            if (n < this.fPosition) {
                return false;
            }
            IDocument iDocument = this.fViewer.getDocument();
            IRegion iRegion = iDocument.getLineInformationOfOffset(this.fPosition);
            if (n > iRegion.getOffset() + iRegion.getLength()) {
                return false;
            }
            return this.getCharCount(iDocument, this.fPosition, n, '(', ')', false) >= 0;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public boolean updatePresentation(int n, TextPresentation textPresentation) {
        int n2;
        int n3 = -1;
        try {
            n3 = this.getCharCount(this.fViewer.getDocument(), this.fPosition, n, ',', '\u0000', true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && n3 == this.fCurrentParameter) {
            return false;
        }
        textPresentation.clear();
        this.fCurrentParameter = n3;
        String string = this.fInformation.getInformationDisplayString();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fCurrentParameter) {
            n2 = string.indexOf(44, n4);
            if (n2 == -1) break;
            n4 = n2 + 1;
            ++n5;
        }
        if (n5 < this.fCurrentParameter) {
            textPresentation.addStyleRange(new StyleRange(0, string.length(), null, null, 0));
            return true;
        }
        if (n4 == -1) {
            n4 = 0;
        }
        if ((n2 = string.indexOf(44, n4)) == -1) {
            n2 = string.length();
        }
        if (n4 > 0) {
            textPresentation.addStyleRange(new StyleRange(0, n4, null, null, 0));
        }
        if (n2 > n4) {
            textPresentation.addStyleRange(new StyleRange(n4, n2 - n4, null, null, 1));
        }
        if (n2 < string.length()) {
            textPresentation.addStyleRange(new StyleRange(n2, string.length() - n2, null, null, 0));
        }
        return true;
    }
}

