/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CCompletionProposal
implements ICCompletionProposal,
ICompletionProposalExtension {
    private String fDisplayString;
    private String fReplacementString;
    private String fAdditionalInfoString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private char[] fTriggerCharacters;
    protected ITextViewer fTextViewer;
    private int fRelevance;

    public CCompletionProposal(String string, int n, int n2, Image image, String string2, int n3, ITextViewer iTextViewer) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fReplacementString = string;
        this.fReplacementOffset = n;
        this.fReplacementLength = n2;
        this.fImage = image;
        this.fDisplayString = string2 != null ? string2 : string;
        this.fRelevance = n3;
        this.fTextViewer = iTextViewer;
        this.fCursorPosition = string.indexOf("()") == -1 ? string.length() : (string2.indexOf("()") == -1 ? string.length() - 1 : string.length());
        this.fAdditionalInfoString = null;
        this.fContextInformation = null;
        this.fContextInformationPosition = -1;
        this.fTriggerCharacters = null;
    }

    public void setContextInformation(IContextInformation iContextInformation) {
        this.fContextInformation = iContextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharacters = cArray;
    }

    public void setCursorPosition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = n;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    protected void applyIncludes(IDocument iDocument) {
    }

    public void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public void apply(IDocument iDocument, char c, int n) {
        String string = this.fReplacementString;
        this.fReplacementLength = n - this.fReplacementOffset;
        try {
            boolean bl;
            int n2 = this.fReplacementString.indexOf("()");
            boolean bl2 = bl = iDocument.getChar(this.fReplacementOffset + this.fReplacementLength) == '(';
            if (n2 != -1 && bl) {
                string = this.fReplacementString.substring(0, n2);
            }
        }
        catch (Exception exception) {}
        try {
            int n3;
            String string2;
            if (c == '\u0000') {
                string2 = this.fReplacementString;
                this.replace(iDocument, this.fReplacementOffset, this.fReplacementLength, string);
            } else {
                StringBuffer stringBuffer = new StringBuffer(string);
                if (this.fCursorPosition > 0 && this.fCursorPosition <= stringBuffer.length() && stringBuffer.charAt(this.fCursorPosition - 1) != c) {
                    stringBuffer.insert(this.fCursorPosition, c);
                    ++this.fCursorPosition;
                }
                string2 = stringBuffer.toString();
                this.replace(iDocument, this.fReplacementOffset, this.fReplacementLength, string2);
            }
            if (this.fTextViewer != null && string2 != null && (n3 = string2.indexOf("()")) != -1 && n3 + 1 == this.fCursorPosition) {
                int n4 = this.fReplacementOffset + this.fCursorPosition;
                LinkedPositionManager linkedPositionManager = new LinkedPositionManager(iDocument);
                linkedPositionManager.addPosition(n4, 0);
                LinkedPositionUI linkedPositionUI = new LinkedPositionUI(this.fTextViewer, linkedPositionManager);
                linkedPositionUI.setExitPolicy(new ExitPolicy(')'));
                linkedPositionUI.setFinalCaretOffset(n4 + 1);
                linkedPositionUI.enter();
            }
            int n5 = iDocument.getLength();
            this.applyIncludes(iDocument);
            this.fReplacementOffset += iDocument.getLength() - n5;
        }
        catch (BadLocationException badLocationException) {}
    }

    private void replace(IDocument iDocument, int n, int n2, String string) throws BadLocationException {
        if (!iDocument.get(n, n2).equals(string)) {
            iDocument.replace(n, n2, string);
        }
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public void setAdditionalProposalInfo(String string) {
        this.fAdditionalInfoString = string;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalInfoString;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        int n2;
        if (n < this.fReplacementOffset) {
            return false;
        }
        int n3 = n2 = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (n > this.fReplacementOffset + n2) {
            return false;
        }
        try {
            int n4 = n - this.fReplacementOffset;
            String string = iDocument.get(this.fReplacementOffset, n4);
            return this.fReplacementString.substring(0, n4).equalsIgnoreCase(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = n;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = n;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String string) {
        this.fReplacementString = string;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    public int hashCode() {
        return this.fDisplayString.hashCode() + this.fReplacementString.hashCode() + (this.fAdditionalInfoString == null ? 0 : this.fAdditionalInfoString.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CCompletionProposal)) {
            return false;
        }
        if (!this.fDisplayString.equals(((CCompletionProposal)object).fDisplayString)) {
            return false;
        }
        if (!this.fReplacementString.equals(((CCompletionProposal)object).fReplacementString)) {
            return false;
        }
        return this.fAdditionalInfoString == null || ((CCompletionProposal)object).fAdditionalInfoString == null || this.fAdditionalInfoString.equals(((CCompletionProposal)object).fAdditionalInfoString);
    }

    private static class ExitPolicy
    implements LinkedPositionUI.ExitPolicy {
        final char fExitCharacter;

        public ExitPolicy(char c) {
            this.fExitCharacter = c;
        }

        public LinkedPositionUI.ExitFlags doExit(LinkedPositionManager linkedPositionManager, VerifyEvent verifyEvent, int n, int n2) {
            if (verifyEvent.character == this.fExitCharacter) {
                if (linkedPositionManager.anyPositionIncludes(n, n2)) {
                    return new LinkedPositionUI.ExitFlags(10, false);
                }
                return new LinkedPositionUI.ExitFlags(2, true);
            }
            switch (verifyEvent.character) {
                case '\b': {
                    if (linkedPositionManager.getFirstPosition().length == 0) {
                        return new LinkedPositionUI.ExitFlags(0, true);
                    }
                    return null;
                }
                case '\n': 
                case '\r': 
                case ';': {
                    return new LinkedPositionUI.ExitFlags(2, true);
                }
            }
            return null;
        }
    }
}

