/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(SWTUtil.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor imageDescriptor) {
        Image image;
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((image = (Image)this.fRegistry.get(imageDescriptor)) != null) {
            return image;
        }
        Assert.isTrue((this.fDisplay == SWTUtil.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        image = imageDescriptor.createImage();
        if (image != null) {
            this.fRegistry.put(imageDescriptor, image);
        }
        return image;
    }

    public void dispose() {
        Iterator iterator = this.fRegistry.values().iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.disposeExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

