/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.File;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewCProjectWizardPage
extends WizardPage {
    protected boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private Text projectNameField;
    protected Text locationPathField;
    protected Label locationLabel;
    protected Button browseButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event event) {
            NewCProjectWizardPage.this.setLocationForSelection();
            NewCProjectWizardPage.this.setPageComplete(NewCProjectWizardPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event event) {
            NewCProjectWizardPage.this.setPageComplete(NewCProjectWizardPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite2);
        this.createProjectLocationGroup(composite2);
        this.projectNameField.setFocus();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    private final void createProjectLocationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        final Button button = new Button(composite2, 131104);
        button.setText(CUIPlugin.getResourceString("CProjectWizardPage.useDefaultLabel"));
        button.setSelection(this.useDefaults);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        this.createUserSpecifiedProjectLocationGroup(composite2, !this.useDefaults);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewCProjectWizardPage.this.useDefaults = button.getSelection();
                NewCProjectWizardPage.this.browseButton.setEnabled(!NewCProjectWizardPage.this.useDefaults);
                NewCProjectWizardPage.this.locationPathField.setEnabled(!NewCProjectWizardPage.this.useDefaults);
                NewCProjectWizardPage.this.locationLabel.setEnabled(!NewCProjectWizardPage.this.useDefaults);
                NewCProjectWizardPage.this.setLocationForSelection();
                if (!NewCProjectWizardPage.this.useDefaults) {
                    NewCProjectWizardPage.this.locationPathField.setText("");
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(CUIPlugin.getResourceString("CProjectWizardPage.nameLabel"));
        this.projectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
        this.projectNameField.setVisible(true);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite composite, boolean bl) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(CUIPlugin.getResourceString("CProjectWizardPage.locationLabel"));
        this.locationLabel.setEnabled(bl);
        this.locationPathField = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.locationPathField.setLayoutData((Object)gridData);
        this.locationPathField.setEnabled(bl);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(CUIPlugin.getResourceString("CProjectWizardPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewCProjectWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(bl);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.locationPathField.getText());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.projectNameField.getText();
    }

    protected void handleLocationBrowseButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.locationPathField.getShell());
        directoryDialog.setMessage(CUIPlugin.getResourceString("CProjectWizardPage.directoryLabel"));
        String string = this.locationPathField.getText();
        if (!string.equals("") && ((File)(object = new File(string))).exists()) {
            directoryDialog.setFilterPath(string);
        }
        if ((object = directoryDialog.open()) != null) {
            this.locationPathField.setText((String)object);
        }
    }

    public NewCProjectWizardPage(String string) {
        super(string);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
    }

    protected void setLocationForSelection() {
        if (this.useDefaults) {
            IPath iPath = Platform.getLocation().append(this.projectNameField.getText());
            this.locationPathField.setText(iPath.toOSString());
        }
    }

    protected boolean validatePage() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = this.projectNameField.getText();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(CUIPlugin.getResourceString("CProjectWizardPage.projectNameEmpty"));
            return false;
        }
        IStatus iStatus = ((NewCProjectWizard)this.getWizard()).isValidName(string);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        IStatus iStatus2 = iWorkspace.validateName(string, 4);
        if (!iStatus2.isOK()) {
            this.setErrorMessage(iStatus2.getMessage());
            return false;
        }
        String string2 = this.locationPathField.getText();
        if (!string2.equals("")) {
            IStatus iStatus3 = ((NewCProjectWizard)this.getWizard()).isValidLocation(string);
            if (!iStatus3.isOK()) {
                this.setErrorMessage(iStatus3.getMessage());
                return false;
            }
            Path path = new Path("");
            if (!path.isValidPath(string2)) {
                this.setErrorMessage(CUIPlugin.getResourceString("CProjectWizardPage.locationError"));
                return false;
            }
            if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(string2))) {
                this.setErrorMessage(CUIPlugin.getResourceString("CProjectWizardPage.defaultLocationError"));
                return false;
            }
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(CUIPlugin.getResourceString("CProjectWizardPage.projectExistsMessage"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

