/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class MakeScannerInfo
implements IScannerInfo {
    private IProject project;
    private ArrayList symbolList;
    private ArrayList pathList;

    MakeScannerInfo(IProject iProject) {
        this.project = iProject;
    }

    IProject getProject() {
        return this.project;
    }

    public void update() throws CoreException {
        MakeScannerProvider.updateScannerInfo(this);
    }

    public synchronized void setPreprocessorSymbols(String[] stringArray) {
        this.getSymbolList().clear();
        this.getSymbolList().addAll(Arrays.asList(stringArray));
    }

    public synchronized void setIncludePaths(String[] stringArray) {
        this.getPathList().clear();
        this.getPathList().addAll(Arrays.asList(stringArray));
    }

    public synchronized String[] getIncludePaths() {
        return this.getPathList().toArray(new String[this.getPathList().size()]);
    }

    public synchronized Map getDefinedSymbols() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getPreprocessorSymbols();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.length() != 0) {
                String string2 = new String();
                String string3 = new String();
                int n2 = string.indexOf("=");
                if (n2 != -1) {
                    string2 = string.substring(0, n2).trim();
                    string3 = string.substring(n2 + 1).trim();
                } else {
                    string2 = string.trim();
                }
                hashMap.put(string2, string3);
            }
            ++n;
        }
        return hashMap;
    }

    protected List getPathList() {
        if (this.pathList == null) {
            this.pathList = new ArrayList();
        }
        return this.pathList;
    }

    public synchronized String[] getPreprocessorSymbols() {
        return this.getSymbolList().toArray(new String[this.getSymbolList().size()]);
    }

    protected List getSymbolList() {
        if (this.symbolList == null) {
            this.symbolList = new ArrayList();
        }
        return this.symbolList;
    }
}

