/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class BuildInfoFactory {
    private static final String PREFIX = MakeCorePlugin.getUniqueIdentifier();
    static final String BUILD_COMMAND = String.valueOf(PREFIX) + ".buildCommand";
    static final String BUILD_LOCATION = String.valueOf(PREFIX) + ".buildLocation";
    static final String STOP_ON_ERROR = String.valueOf(PREFIX) + ".stopOnError";
    static final String USE_DEFAULT_BUILD_CMD = String.valueOf(PREFIX) + ".useDefaultBuildCmd";
    static final String BUILD_TARGET_AUTO = String.valueOf(PREFIX) + ".autoBuildTarget";
    static final String BUILD_TARGET_INCREMENTAL = String.valueOf(PREFIX) + ".incrementalBuildTarget";
    static final String BUILD_TARGET_FULL = String.valueOf(PREFIX) + ".fullBuildTarget";
    static final String BUILD_FULL_ENABLED = String.valueOf(PREFIX) + ".enableFullBuild";
    static final String BUILD_INCREMENTAL_ENABLED = String.valueOf(PREFIX) + ".enabledIncrementalBuild";
    static final String BUILD_AUTO_ENABLED = String.valueOf(PREFIX) + ".enableAutoBuild";
    static final String BUILD_ARGUMENTS = String.valueOf(PREFIX) + ".buildArguments";
    static final String ENVIRONMENT = String.valueOf(PREFIX) + ".environment";

    public static IMakeBuilderInfo create(Preferences preferences, String string, boolean bl) {
        return new Preference(preferences, string, bl);
    }

    public static IMakeBuilderInfo create(IProject iProject, String string) throws CoreException {
        return new BuildProperty(iProject, string);
    }

    public static IMakeBuilderInfo create(Map map, String string) {
        return new BuildArguments(map, string);
    }

    private static abstract class Store
    implements IMakeBuilderInfo {
        Store() {
        }

        public void setUseDefaultBuildCmd(boolean bl) throws CoreException {
            this.putString(USE_DEFAULT_BUILD_CMD, new Boolean(bl).toString());
        }

        public boolean isDefaultBuildCmd() {
            if (this.getString(USE_DEFAULT_BUILD_CMD) == null) {
                return true;
            }
            return this.getBoolean(USE_DEFAULT_BUILD_CMD);
        }

        public void setBuildCommand(IPath iPath) throws CoreException {
            this.putString(BUILD_COMMAND, iPath.toString());
        }

        public IPath getBuildCommand() {
            if (this.isDefaultBuildCmd()) {
                String string = this.getBuildParameter("defaultCommand");
                if (string == null) {
                    return new Path("make");
                }
                return new Path(string);
            }
            return new Path(this.getString(BUILD_COMMAND));
        }

        protected String getBuildParameter(String string) {
            IExtension iExtension = Platform.getPluginRegistry().getExtension("org.eclipse.core.resources", "builders", this.getBuilderID());
            if (iExtension == null) {
                return null;
            }
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray.length == 0) {
                return null;
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[0].getChildren("run");
            IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray2[0].getChildren("parameter");
            int n = 0;
            while (n < iConfigurationElementArray3.length) {
                if (iConfigurationElementArray3[n].getAttribute("name").equals(string)) {
                    return iConfigurationElementArray3[n].getAttribute("value");
                }
                ++n;
            }
            return null;
        }

        protected abstract String getBuilderID();

        public void setBuildLocation(IPath iPath) throws CoreException {
            this.putString(BUILD_LOCATION, iPath.toString());
        }

        public IPath getBuildLocation() {
            String string = this.getString(BUILD_LOCATION);
            return new Path(string == null ? "" : string);
        }

        public void setStopOnError(boolean bl) throws CoreException {
            this.putString(STOP_ON_ERROR, new Boolean(bl).toString());
        }

        public boolean isStopOnError() {
            return this.getBoolean(STOP_ON_ERROR);
        }

        public void setAutoBuildTarget(String string) throws CoreException {
            this.putString(BUILD_TARGET_AUTO, string);
        }

        public String getAutoBuildTarget() {
            return this.getString(BUILD_TARGET_AUTO);
        }

        public void setIncrementalBuildTarget(String string) throws CoreException {
            this.putString(BUILD_TARGET_INCREMENTAL, string);
        }

        public String getIncrementalBuildTarget() {
            return this.getString(BUILD_TARGET_INCREMENTAL);
        }

        public void setFullBuildTarget(String string) throws CoreException {
            this.putString(BUILD_TARGET_FULL, string);
        }

        public String getFullBuildTarget() {
            return this.getString(BUILD_TARGET_FULL);
        }

        public boolean getBoolean(String string) {
            return Boolean.valueOf(this.getString(string));
        }

        protected abstract void putString(String var1, String var2) throws CoreException;

        protected abstract String getString(String var1);

        public void setAutoBuildEnable(boolean bl) throws CoreException {
            this.putString(BUILD_AUTO_ENABLED, new Boolean(bl).toString());
        }

        public boolean isAutoBuildEnable() {
            return this.getBoolean(BUILD_AUTO_ENABLED);
        }

        public void setIncrementalBuildEnable(boolean bl) throws CoreException {
            this.putString(BUILD_INCREMENTAL_ENABLED, new Boolean(bl).toString());
        }

        public boolean isIncrementalBuildEnabled() {
            return this.getBoolean(BUILD_INCREMENTAL_ENABLED);
        }

        public void setFullBuildEnable(boolean bl) throws CoreException {
            this.putString(BUILD_FULL_ENABLED, new Boolean(bl).toString());
        }

        public boolean isFullBuildEnabled() {
            return this.getBoolean(BUILD_FULL_ENABLED);
        }

        public String getBuildArguments() {
            return this.getString(BUILD_ARGUMENTS);
        }

        public void setBuildArguments(String string) throws CoreException {
            this.putString(BUILD_ARGUMENTS, string);
        }

        public String[] getErrorParsers() {
            String string = this.getString("org.eclipse.cdt.core.errorOutputParser");
            if (string != null && string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreElements()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return new String[0];
        }

        public void setErrorParsers(String[] stringArray) throws CoreException {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]).append(';');
                ++n;
            }
            this.putString("org.eclipse.cdt.core.errorOutputParser", stringBuffer.toString());
        }

        public Map getEnvironment() {
            return this.decodeMap(this.getString(ENVIRONMENT));
        }

        public void setEnvironment(Map map) throws CoreException {
            this.putString(ENVIRONMENT, this.encodeMap(map));
        }

        protected Map decodeMap(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                while (string != null && string.length() > 0) {
                    int n = 0;
                    while (string.charAt(n) != '|' || n != 0 && string.charAt(n - 1) == '\\') {
                        ++n;
                    }
                    StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                    int n2 = 0;
                    while (stringBuffer.charAt(n2) != '=' || n2 != 0 && stringBuffer.charAt(n2 - 1) == '\\') {
                        ++n2;
                    }
                    hashMap.put(stringBuffer.substring(0, n2), stringBuffer.substring(n2 + 1));
                    string = string.substring(n + 1);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            return hashMap;
        }

        protected String encodeMap(Map map) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(this.escapeChars((String)entry.getKey(), "=|"));
                stringBuffer.append("=");
                stringBuffer.append(this.escapeChars((String)entry.getValue(), "=|)"));
                stringBuffer.append("|");
            }
            return stringBuffer.toString();
        }

        protected String escapeChars(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (string2.indexOf(stringBuffer.charAt(n)) != -1) {
                    stringBuffer.insert(n - 1, '\\');
                }
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String builderID;
        private boolean useDefaults;

        Preference(Preferences preferences, String string, boolean bl) {
            this.prefs = preferences;
            this.builderID = string;
            this.useDefaults = bl;
        }

        protected void putString(String string, String string2) {
            if (this.useDefaults) {
                this.prefs.setDefault(string, string2);
            } else {
                this.prefs.setValue(string, string2);
            }
        }

        protected String getString(String string) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(string);
            }
            return this.prefs.getString(string);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private String builderID;
        private Map args;

        BuildProperty(IProject iProject, String string) throws CoreException {
            this.project = iProject;
            this.builderID = string;
            ICommand iCommand = MakeProjectNature.getBuildSpec(iProject, string);
            if (iCommand == null) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, String.valueOf(MakeCorePlugin.getResourceString("BuildInfoFactory.Missing_Builder")) + string, null));
            }
            this.args = iCommand.getArguments();
        }

        protected void putString(String string, String string2) throws CoreException {
            String string3 = (String)this.args.get(string);
            if (string3 != null && string3.equals(string2)) {
                return;
            }
            ICommand iCommand = MakeProjectNature.getBuildSpec(this.project, this.builderID);
            this.args.put(string, string2);
            iCommand.setArguments(this.args);
            this.project.setDescription(this.project.getDescription(), null);
        }

        protected String getString(String string) {
            String string2 = (String)this.args.get(string);
            return string2 == null ? "" : string2;
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildArguments
    extends Store {
        private Map args;
        private String builderID;

        BuildArguments(Map map, String string) {
            this.args = map;
            this.builderID = string;
        }

        protected void putString(String string, String string2) {
            this.args.put(string, string2);
        }

        protected String getString(String string) {
            return (String)this.args.get(string);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }
}

