/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MakeTarget
implements IMakeTarget {
    private String target;
    private String buildArguments;
    private IPath buildCommand;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    private String name;
    private String targetBuilderID;
    private IContainer container;
    private MakeTargetManager manager;

    MakeTarget(MakeTargetManager makeTargetManager, IProject iProject, String string, String string2) throws CoreException {
        this.manager = makeTargetManager;
        this.targetBuilderID = string;
        this.name = string2;
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(iProject, makeTargetManager.getBuilderID(string));
        this.buildCommand = iMakeBuilderInfo.getBuildCommand();
        this.buildArguments = iMakeBuilderInfo.getBuildArguments();
        this.isDefaultBuildCmd = iMakeBuilderInfo.isDefaultBuildCmd();
        this.isStopOnError = iMakeBuilderInfo.isStopOnError();
    }

    public void setContainer(IContainer iContainer) {
        this.container = iContainer;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    public void setStopOnError(boolean bl) {
        this.isStopOnError = bl;
    }

    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    public void setUseDefaultBuildCmd(boolean bl) {
        this.isDefaultBuildCmd = bl;
    }

    public IPath getBuildCommand() {
        return this.buildCommand != null ? this.buildCommand : new Path("");
    }

    public void setBuildCommand(IPath iPath) {
        this.buildCommand = iPath;
    }

    public String getBuildArguments() {
        return this.buildArguments != null ? this.buildArguments : "";
    }

    public void setBuildArguments(String string) {
        this.buildArguments = string;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MakeTarget) {
            MakeTarget makeTarget = (MakeTarget)object;
            return this.container.equals((Object)makeTarget.getContainer()) && this.name.equals(makeTarget.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode() * 17 + this.name.hashCode();
    }

    public void build(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.container.getProject();
        String string = this.manager.getBuilderID(this.targetBuilderID);
        HashMap hashMap = new HashMap();
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(hashMap, string);
        if (this.buildArguments != null) {
            iMakeBuilderInfo.setBuildArguments(this.buildArguments);
        }
        if (this.buildCommand != null) {
            iMakeBuilderInfo.setBuildCommand(this.buildCommand);
        }
        iMakeBuilderInfo.setUseDefaultBuildCmd(this.isDefaultBuildCmd);
        iMakeBuilderInfo.setStopOnError(this.isStopOnError);
        iMakeBuilderInfo.setFullBuildEnable(true);
        iMakeBuilderInfo.setFullBuildTarget(this.target);
        if (this.container != null) {
            iMakeBuilderInfo.setBuildLocation(this.container.getFullPath());
        }
        IMakeBuilderInfo iMakeBuilderInfo2 = MakeCorePlugin.createBuildInfo(iProject, string);
        iMakeBuilderInfo.setErrorParsers(iMakeBuilderInfo2.getErrorParsers());
        iProject.build(6, string, hashMap, iProgressMonitor);
    }

    public void setBuildTarget(String string) {
        this.target = string;
    }

    public String getBuildTarget() {
        return this.target;
    }
}

