/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.cdt.make.internal.core.ListenerList;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.ProjectTargets;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MakeTargetManager
implements IMakeTargetManager,
IResourceChangeListener {
    private static String TARGET_BUILD_EXT = "MakeTargetBuilder";
    private static String TARGETS_EXT = "targets";
    private ListenerList listeners = new ListenerList();
    private HashMap projectMap = new HashMap();
    private HashMap builderMap;
    protected Vector fProjects = new Vector();

    public IMakeTarget createTarget(IProject iProject, String string, String string2) throws CoreException {
        return new MakeTarget(this, iProject, string2, string);
    }

    public void addTarget(IContainer iContainer, IMakeTarget iMakeTarget) throws CoreException {
        if (iContainer instanceof IWorkspaceRoot) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.add_to_workspace_root"), null));
        }
        if (iMakeTarget.getContainer() != null) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.add_temporary_target"), null));
        }
        IProject iProject = iContainer.getProject();
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(iProject);
        if (projectTargets == null) {
            projectTargets = this.readTargets(iProject);
        }
        ((MakeTarget)iMakeTarget).setContainer(iContainer);
        projectTargets.add((MakeTarget)iMakeTarget);
        this.writeTargets(projectTargets);
        this.notifyListeners(new MakeTargetEvent((Object)this, 1, iMakeTarget));
    }

    public void removeTarget(IMakeTarget iMakeTarget) throws CoreException {
        IProject iProject = iMakeTarget.getContainer().getProject();
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(iProject);
        if (projectTargets == null) {
            projectTargets = this.readTargets(iProject);
        }
        if (projectTargets.remove(iMakeTarget)) {
            this.writeTargets(projectTargets);
            this.notifyListeners(new MakeTargetEvent((Object)this, 3, iMakeTarget));
        }
    }

    public void renameTarget(IMakeTarget iMakeTarget, String string) throws CoreException {
        IProject iProject = iMakeTarget.getContainer().getProject();
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(iProject);
        if (projectTargets == null) {
            projectTargets = this.readTargets(iProject);
        }
        if (!projectTargets.contains((MakeTarget)iMakeTarget)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.target_exists"), null));
        }
        ((MakeTarget)iMakeTarget).setName(string);
        this.writeTargets(projectTargets);
        this.notifyListeners(new MakeTargetEvent((Object)this, 2, iMakeTarget));
    }

    public IMakeTarget[] getTargets(IContainer iContainer) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(iContainer.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(iContainer.getProject());
        }
        return projectTargets.get(iContainer);
    }

    public IMakeTarget findTarget(IContainer iContainer, String string) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(iContainer.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(iContainer.getProject());
        }
        return projectTargets.findTarget(iContainer, string);
    }

    public IProject[] getTargetBuilderProjects() throws CoreException {
        return this.fProjects.toArray(new IProject[this.fProjects.size()]);
    }

    public String[] getTargetBuilders(IProject iProject) {
        if (this.fProjects.contains(iProject) || this.hasTargetBuilder(iProject)) {
            try {
                Vector vector = new Vector();
                IProjectDescription iProjectDescription = iProject.getDescription();
                ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                int n = 0;
                while (n < iCommandArray.length) {
                    Iterator iterator = this.builderMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!entry.getValue().equals(iCommandArray[n].getBuilderName())) continue;
                        vector.add(entry.getKey());
                    }
                    ++n;
                }
                return vector.toArray(new String[vector.size()]);
            }
            catch (CoreException coreException) {}
        }
        return new String[0];
    }

    public boolean hasTargetBuilder(IProject iProject) {
        try {
            if (iProject.isAccessible()) {
                IProjectDescription iProjectDescription = iProject.getDescription();
                ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                int n = 0;
                while (n < iCommandArray.length) {
                    if (this.builderMap.containsValue(iCommandArray[n].getBuilderName())) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void startup() {
        this.initializeBuilders();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (this.hasTargetBuilder(iProjectArray[n])) {
                this.fProjects.add(iProjectArray[n]);
            }
            ++n;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)new MakeTargetVisitor());
            }
            catch (CoreException coreException) {
                MakeCorePlugin.log(coreException);
            }
        }
    }

    protected void writeTargets(ProjectTargets projectTargets) throws CoreException {
        IPath iPath = MakeCorePlugin.getDefault().getStateLocation().append(projectTargets.getProject().getName()).addFileExtension(TARGETS_EXT);
        File file = iPath.toFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            projectTargets.saveTargets(fileOutputStream);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.error_writing_file"), (Throwable)iOException));
        }
    }

    protected ProjectTargets readTargets(IProject iProject) throws CoreException {
        IPath iPath = MakeCorePlugin.getDefault().getStateLocation().append(iProject.getName()).addFileExtension(TARGETS_EXT);
        File file = iPath.toFile();
        ProjectTargets projectTargets = null;
        if (file.exists()) {
            try {
                projectTargets = new ProjectTargets(this, iProject, new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (projectTargets == null) {
            projectTargets = new ProjectTargets(iProject);
        }
        this.projectMap.put(iProject, projectTargets);
        return projectTargets;
    }

    protected void deleteTargets(IProject iProject) {
        IPath iPath = MakeCorePlugin.getDefault().getStateLocation().append(iProject.getName()).addFileExtension(TARGETS_EXT);
        File file = iPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        this.projectMap.remove(iProject);
    }

    protected void initializeBuilders() {
        this.builderMap = new HashMap();
        IExtensionPoint iExtensionPoint = MakeCorePlugin.getDefault().getDescriptor().getExtensionPoint(TARGET_BUILD_EXT);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals("builder")) {
                    String string = iConfigurationElementArray[n2].getAttribute("builderID");
                    String string2 = iConfigurationElementArray[n2].getAttribute("id");
                    this.builderMap.put(string2, string);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void notifyListeners(MakeTargetEvent makeTargetEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IMakeTargetListener)objectArray[n]).targetChanged(makeTargetEvent);
            ++n;
        }
    }

    public void addListener(IMakeTargetListener iMakeTargetListener) {
        this.listeners.add(iMakeTargetListener);
    }

    public void removeListener(IMakeTargetListener iMakeTargetListener) {
        this.listeners.remove(this.listeners);
    }

    public String getBuilderID(String string) {
        return (String)this.builderMap.get(string);
    }

    class MakeTargetVisitor
    implements IResourceDeltaVisitor {
        MakeTargetVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            if (iResourceDelta == null) {
                return false;
            }
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 4) {
                IProject iProject = (IProject)iResource;
                int n = iResourceDelta.getFlags();
                int n2 = iResourceDelta.getKind();
                if (n2 == 1) {
                    if (MakeTargetManager.this.hasTargetBuilder(iProject) && !MakeTargetManager.this.fProjects.contains(iProject)) {
                        MakeTargetManager.this.fProjects.add(iProject);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, iProject));
                    }
                } else if (n2 == 2) {
                    if (MakeTargetManager.this.fProjects.contains(iProject)) {
                        MakeTargetManager.this.deleteTargets(iProject);
                        MakeTargetManager.this.fProjects.remove(iProject);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, iProject));
                    }
                } else if (n2 == 4) {
                    if ((n & 0x80000) != 0) {
                        if (MakeTargetManager.this.fProjects.contains(iProject) && !MakeTargetManager.this.hasTargetBuilder(iProject)) {
                            MakeTargetManager.this.fProjects.remove(iProject);
                            MakeTargetManager.this.projectMap.remove(iProject);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, iProject));
                        } else if (!MakeTargetManager.this.fProjects.contains(iProject) && MakeTargetManager.this.hasTargetBuilder(iProject)) {
                            MakeTargetManager.this.fProjects.add(iProject);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, iProject));
                        }
                    }
                    if ((n & 0x4000) != 0) {
                        if (!iProject.isOpen() && MakeTargetManager.this.fProjects.contains(iProject)) {
                            MakeTargetManager.this.fProjects.remove(iProject);
                            MakeTargetManager.this.projectMap.remove(iProject);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, iProject));
                        } else if (iProject.isOpen() && MakeTargetManager.this.hasTargetBuilder(iProject) && !MakeTargetManager.this.fProjects.contains(iProject)) {
                            MakeTargetManager.this.fProjects.add(iProject);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, iProject));
                        }
                    }
                }
                return false;
            }
            return iResource instanceof IWorkspaceRoot;
        }
    }
}

