/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import org.eclipse.cdt.make.core.makefile.gnu.IVariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;

public class VariableDefinition
extends MacroDefinition
implements IVariableDefinition {
    static final int TYPE_RECURSIVE_EXPAND = 0;
    static final int TYPE_SIMPLE_EXPAND = 58;
    static final int TYPE_CONDITIONAL = 63;
    static final int TYPE_APPEND = 43;
    int type;
    String varTarget;

    public VariableDefinition(Directive directive, String string, StringBuffer stringBuffer) {
        this(directive, string, stringBuffer, 0);
    }

    public VariableDefinition(Directive directive, String string, StringBuffer stringBuffer, int n) {
        this(directive, "", string, stringBuffer, n);
    }

    public VariableDefinition(Directive directive, String string, String string2, StringBuffer stringBuffer, int n) {
        super(directive, string2, stringBuffer);
        this.varTarget = string;
        this.type = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTargetSpecific()) {
            stringBuffer.append(this.getTarget()).append(": ");
        }
        if (this.isOverride()) {
            stringBuffer.append("override");
        }
        if (this.isMultiLine()) {
            stringBuffer.append("define");
            stringBuffer.append(' ');
            stringBuffer.append(this.getName()).append('\n');
            stringBuffer.append(this.getValue()).append('\n');
            stringBuffer.append("endef");
            stringBuffer.append('\n');
        } else {
            if (this.isExport()) {
                stringBuffer.append("export");
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.getName());
            if (this.isRecursivelyExpanded()) {
                stringBuffer.append(" = ");
            } else if (this.isSimplyExpanded()) {
                stringBuffer.append(" := ");
            } else if (this.isConditional()) {
                stringBuffer.append(" ?= ");
            } else if (this.isAppend()) {
                stringBuffer.append(" += ");
            }
            stringBuffer.append(this.getValue()).append('\n');
        }
        return stringBuffer.toString();
    }

    public boolean isRecursivelyExpanded() {
        return this.type == 0;
    }

    public boolean isSimplyExpanded() {
        return this.type == 58;
    }

    public boolean isConditional() {
        return this.type == 63;
    }

    public boolean isAppend() {
        return this.type == 43;
    }

    public boolean isTargetSpecific() {
        String string = this.getTarget();
        return string != null && string.length() > 0;
    }

    public boolean isExport() {
        return false;
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isOverride() {
        return false;
    }

    public boolean isAutomatic() {
        return false;
    }

    public String getTarget() {
        return this.varTarget;
    }
}

