/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.posix;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.TargetRule;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PosixMakefile
extends AbstractMakefile {
    IDirective[] builtins = null;

    public PosixMakefile() {
        super(null);
    }

    public void parse(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        this.parse(fileReader);
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader reader) throws IOException {
        this.parse(new MakefileReader(reader));
    }

    protected void parse(MakefileReader makefileReader) throws IOException {
        String string;
        Rule[] ruleArray = null;
        int n = 0;
        int n2 = 0;
        while ((string = makefileReader.readLine()) != null) {
            int n3;
            int n4;
            n = n2 + 1;
            n2 = makefileReader.getLineNumber();
            if (PosixMakefileUtil.isCommand(string)) {
                Command command = new Command(this, string);
                command.setLines(n, n2);
                if (ruleArray != null) {
                    int n5 = 0;
                    while (n5 < ruleArray.length) {
                        ruleArray[n5].addDirective(command);
                        ruleArray[n5].setEndLine(n2);
                        ++n5;
                    }
                    continue;
                }
            }
            if ((n4 = Util.indexOfComment(string)) != -1) {
                Comment comment = new Comment(this, string.substring(n4 + 1));
                comment.setLines(n, n2);
                if (ruleArray != null) {
                    n3 = 0;
                    while (n3 < ruleArray.length) {
                        ruleArray[n3].addDirective(comment);
                        ruleArray[n3].setEndLine(n2);
                        ++n3;
                    }
                } else {
                    this.addDirective(comment);
                }
                string = string.substring(0, n4);
                if (Util.isEmptyLine(string)) continue;
            }
            if (Util.isEmptyLine(string)) {
                EmptyLine emptyLine = new EmptyLine(this);
                emptyLine.setLines(n, n2);
                if (ruleArray != null) {
                    n3 = 0;
                    while (n3 < ruleArray.length) {
                        ruleArray[n3].addDirective(emptyLine);
                        ruleArray[n3].setEndLine(n2);
                        ++n3;
                    }
                    continue;
                }
                this.addDirective(emptyLine);
                continue;
            }
            ruleArray = null;
            SpecialRule specialRule = this.processSpecialRule(string);
            if (specialRule != null) {
                ruleArray = new Rule[]{specialRule};
                specialRule.setLines(n, n2);
                this.addDirective(specialRule);
                continue;
            }
            if (PosixMakefileUtil.isInferenceRule(string)) {
                InferenceRule inferenceRule = this.parseInferenceRule(string);
                inferenceRule.setLines(n, n2);
                this.addDirective(inferenceRule);
                ruleArray = new Rule[]{inferenceRule};
                continue;
            }
            if (PosixMakefileUtil.isMacroDefinition(string)) {
                MacroDefinition macroDefinition = this.parseMacroDefinition(string);
                macroDefinition.setLines(n, n2);
                this.addDirective(macroDefinition);
                continue;
            }
            if (PosixMakefileUtil.isTargetRule(string)) {
                TargetRule[] targetRuleArray = this.parseTargetRule(string);
                int n6 = 0;
                while (n6 < targetRuleArray.length) {
                    targetRuleArray[n6].setLines(n, n2);
                    this.addDirective(targetRuleArray[n6]);
                    ++n6;
                }
                ruleArray = targetRuleArray;
                continue;
            }
            BadDirective badDirective = new BadDirective(this, string);
            badDirective.setLines(n, n2);
            this.addDirective(badDirective);
        }
        this.setLines(1, n2);
    }

    public IDirective[] getBuiltins() {
        if (this.builtins == null) {
            String string = "builtin" + File.separator + "posix.mk";
            try {
                InputStream inputStream = MakeCorePlugin.getDefault().openStream((IPath)new Path(string));
                PosixMakefile posixMakefile = new PosixMakefile();
                posixMakefile.parse(new InputStreamReader(inputStream));
                this.builtins = posixMakefile.getDirectives();
                int n = 0;
                while (n < this.builtins.length) {
                    if (this.builtins[n] instanceof MacroDefinition) {
                        ((MacroDefinition)this.builtins[n]).setFromDefault(true);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            if (this.builtins == null) {
                this.builtins = new IDirective[0];
            }
        }
        return this.builtins;
    }

    protected SpecialRule processSpecialRule(String string) {
        string = string.trim();
        String string2 = null;
        String[] stringArray = null;
        SpecialRule specialRule = null;
        int n = Util.indexOf(string, ':');
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1);
            stringArray = PosixMakefileUtil.findPrerequisites(string3);
        } else {
            string2 = string;
            stringArray = new String[]{};
        }
        if (string2.equals(".IGNORE")) {
            specialRule = new IgnoreRule((Directive)this, stringArray);
        } else if (string2.equals(".POSIX")) {
            specialRule = new PosixRule(this);
        } else if (string2.equals(".PRECIOUS")) {
            specialRule = new PreciousRule((Directive)this, stringArray);
        } else if (string2.equals(".SILENT")) {
            specialRule = new SilentRule((Directive)this, stringArray);
        } else if (string2.equals(".SUFFIXES")) {
            specialRule = new SuffixesRule((Directive)this, stringArray);
        } else if (string2.equals(".DEFAULT")) {
            specialRule = new DefaultRule((Directive)this, new Command[0]);
        } else if (string2.equals(".SCCS_GET")) {
            specialRule = new SccsGetRule((Directive)this, new Command[0]);
        }
        return specialRule;
    }

    protected InferenceRule parseInferenceRule(String string) {
        int n = Util.indexOf(string, ':');
        String string2 = n != -1 ? string.substring(0, n) : string;
        return new InferenceRule(this, new Target(string2));
    }

    protected MacroDefinition parseMacroDefinition(String string) {
        String string2;
        String string3;
        int n = Util.indexOf(string, '=');
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1).trim();
        } else {
            string3 = string;
            string2 = "";
        }
        return new MacroDefinition(this, string3, new StringBuffer(string2));
    }

    protected TargetRule[] parseTargetRule(String string) {
        String[] stringArray;
        String[] stringArray2;
        TargetRule[] targetRuleArray;
        String string2 = null;
        int n = Util.indexOf(string, ':');
        if (n != -1) {
            targetRuleArray = string.substring(0, n);
            stringArray2 = PosixMakefileUtil.findTargets((String)targetRuleArray);
            String string3 = string.substring(n + 1);
            int n2 = Util.indexOf(string3, ';');
            if (n2 != -1) {
                String string4 = string3.substring(n2 + 1).trim();
                if (string4.length() > 0) {
                    string2 = string4;
                }
                string3 = string3.substring(0, n2);
            }
            stringArray = PosixMakefileUtil.findPrerequisites(string3);
        } else {
            stringArray2 = PosixMakefileUtil.findTargets(string);
            stringArray = new String[]{};
        }
        targetRuleArray = new TargetRule[stringArray2.length];
        int n3 = 0;
        while (n3 < stringArray2.length) {
            targetRuleArray[n3] = new TargetRule((Directive)this, new Target(stringArray2[n3]), stringArray);
            if (string2 != null) {
                Command command = new Command(this, string2);
                targetRuleArray[n3].addDirective(command);
            }
            ++n3;
        }
        return targetRuleArray;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "Makefile";
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            PosixMakefile posixMakefile = new PosixMakefile();
            posixMakefile.parse(string);
            IDirective[] iDirectiveArray = posixMakefile.getDirectives();
            int n = 0;
            while (n < iDirectiveArray.length) {
                System.out.print(iDirectiveArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

