/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.make.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private IMakefileDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(IMakefileDocumentProvider iMakefileDocumentProvider) {
        Assert.isNotNull((Object)iMakefileDocumentProvider);
        this.fDocumentProvider = iMakefileDocumentProvider;
    }

    public void connect(IEditorInput iEditorInput) throws CoreException {
        this.fDocumentProvider.connect(iEditorInput);
    }

    public void disconnect(IEditorInput iEditorInput) {
        this.fDocumentProvider.disconnect(iEditorInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public IMakefile getWorkingCopy(IEditorInput iEditorInput) {
        IMakefile iMakefile = this.fMap == null ? null : (IMakefile)this.fMap.get(iEditorInput);
        return iMakefile != null ? iMakefile : this.fDocumentProvider.getWorkingCopy(iEditorInput);
    }

    public void setWorkingCopy(IEditorInput iEditorInput, IMakefile iMakefile) {
        if (this.fDocumentProvider.getDocument(iEditorInput) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(iEditorInput, iMakefile);
        }
    }

    public void removeWorkingCopy(IEditorInput iEditorInput) {
        this.fMap.remove(iEditorInput);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

