/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

public class WordPartDetector {
    String wordPart = "";
    int offset;

    public WordPartDetector(ITextViewer iTextViewer, int n) {
        this.offset = n - 1;
        int n2 = n;
        try {
            IDocument iDocument = iTextViewer.getDocument();
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n3 = iRegion.getOffset();
            int n4 = iRegion.getLength() + n3;
            while (this.offset >= n3 && this.isMakefileLetter(iDocument.getChar(this.offset))) {
                --this.offset;
            }
            while (n2 < n4 && this.isMakefileLetter(iDocument.getChar(n2))) {
                ++n2;
            }
            ++this.offset;
            this.wordPart = iTextViewer.getDocument().get(this.offset, n2 - this.offset);
        }
        catch (BadLocationException badLocationException) {}
    }

    public static boolean inMacro(ITextViewer iTextViewer, int n) {
        boolean bl = false;
        IDocument iDocument = iTextViewer.getDocument();
        try {
            int n2 = n - 1;
            while (n2 >= 0) {
                char c = iDocument.getChar(n2);
                if (c == '$') {
                    bl = true;
                } else if (!Character.isWhitespace(c)) {
                    --n2;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return bl;
    }

    public String toString() {
        return this.wordPart;
    }

    public int getOffset() {
        return this.offset;
    }

    boolean isMakefileLetter(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.';
    }
}

