/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MakeTargetDialog
extends Dialog {
    protected MessageLine fStatusLine;
    private static final String TARGET_PREFIX = "TargetBlock";
    private static final String TARGET_NAME_LABEL = "TargetBlock.target.label";
    private static final String BUILD_ARGUMENT_PREFIX = "BuildTarget";
    private static final String BUILD_ARGUMENT_GROUP = "BuildTarget.target.group_label";
    private static final String BUILD_ARGUMENT_LABEL = "BuildTarget.target.label";
    private static final String SETTING_PREFIX = "SettingsBlock";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_DEFAULT = "SettingsBlock.makeCmd.use_default";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    Text targetNameText;
    Button stopOnErrorButton;
    Text commandText;
    Button defButton;
    Text targetText;
    IMakeTargetManager fTargetManager;
    IContainer fContainer;
    private IPath buildCommand;
    private boolean isDefaultCommand;
    private boolean isStopOnError;
    private String buildArguments;
    private String targetString;
    private String targetName;
    private String targetBuildID;
    protected IMakeTarget fTarget;

    public MakeTargetDialog(Shell shell, IMakeTarget iMakeTarget) throws CoreException {
        this(shell, iMakeTarget.getContainer());
        this.fTarget = iMakeTarget;
        this.isStopOnError = iMakeTarget.isStopOnError();
        this.isDefaultCommand = iMakeTarget.isDefaultBuildCmd();
        this.buildCommand = iMakeTarget.getBuildCommand();
        this.buildArguments = iMakeTarget.getBuildArguments();
        this.targetName = iMakeTarget.getName();
        this.targetString = iMakeTarget.getBuildTarget();
        this.targetBuildID = iMakeTarget.getTargetBuilderID();
    }

    public MakeTargetDialog(Shell shell, IContainer iContainer) throws CoreException {
        super(shell);
        this.fContainer = iContainer;
        this.fTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        String[] stringArray = this.fTargetManager.getTargetBuilders(iContainer.getProject());
        if (stringArray.length == 0) {
            throw new CoreException((IStatus)new Status(4, MakeUIPlugin.getUniqueIdentifier(), -1, MakeUIPlugin.getResourceString("MakeTargetDialog.exception.noTargetBuilderOnProject"), null));
        }
        this.targetBuildID = stringArray[0];
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)iContainer.getProject(), (String)this.fTargetManager.getBuilderID(this.targetBuildID));
        this.isStopOnError = iMakeBuilderInfo.isStopOnError();
        this.isDefaultCommand = iMakeBuilderInfo.isDefaultBuildCmd();
        this.buildCommand = iMakeBuilderInfo.getBuildCommand();
        this.buildArguments = iMakeBuilderInfo.getBuildArguments();
        this.targetString = iMakeBuilderInfo.getIncrementalBuildTarget();
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.getTitle());
        super.configureShell(shell);
    }

    private String getTitle() {
        String string = this.fTarget == null ? MakeUIPlugin.getResourceString("MakeTargetDialog.title.createMakeTarget") : MakeUIPlugin.getResourceString("MakeTargetDialog.title.modifyMakeTarget");
        return string;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fStatusLine.setLayoutData(gridData);
        this.fStatusLine.setMessage(this.getTitle());
        this.createNameControl(composite2);
        this.createTargetControl(composite2);
        this.createBuildCmdControls(composite2);
        this.createSettingControls(composite2);
        return composite2;
    }

    protected void createNameControl(Composite composite) {
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)2);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)composite2.getLayout()).horizontalSpacing = 0;
        composite2.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString(TARGET_NAME_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetNameText = ControlFactory.createTextField((Composite)composite2, (int)2052);
        ((GridData)this.targetNameText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetNameText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String string = MakeTargetDialog.this.targetNameText.getText().trim();
                if (string.equals("")) {
                    MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyName"));
                    MakeTargetDialog.this.getButton(0).setEnabled(false);
                } else {
                    try {
                        if (MakeTargetDialog.this.fTarget != null && MakeTargetDialog.this.fTarget.getName().equals(string) || MakeTargetDialog.this.fTargetManager.findTarget(MakeTargetDialog.this.fContainer, string) == null) {
                            MakeTargetDialog.this.fStatusLine.setErrorMessage(null);
                            MakeTargetDialog.this.getButton(0).setEnabled(true);
                        } else {
                            MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.targetWithNameExists"));
                            MakeTargetDialog.this.getButton(0).setEnabled(false);
                        }
                    }
                    catch (CoreException coreException) {
                        MakeTargetDialog.this.fStatusLine.setErrorMessage(coreException.getLocalizedMessage());
                        MakeTargetDialog.this.getButton(0).setEnabled(false);
                    }
                }
            }
        });
    }

    protected void createSettingControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), (int)1);
        this.stopOnErrorButton = new Button((Composite)group, 32);
        this.stopOnErrorButton.setText(MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR));
        if (this.isStopOnError) {
            this.stopOnErrorButton.setSelection(true);
        }
        if (this.isDefaultCommand) {
            this.stopOnErrorButton.setEnabled(true);
        } else {
            this.stopOnErrorButton.setEnabled(false);
        }
    }

    protected void createBuildCmdControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        this.defButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MakeTargetDialog.this.defButton.getSelection()) {
                    MakeTargetDialog.this.commandText.setEnabled(false);
                    MakeTargetDialog.this.stopOnErrorButton.setEnabled(true);
                } else {
                    MakeTargetDialog.this.commandText.setEnabled(true);
                    MakeTargetDialog.this.stopOnErrorButton.setEnabled(false);
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.defButton.setLayoutData((Object)gridData);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.commandText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.commandText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.commandText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.commandText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (MakeTargetDialog.this.commandText.getText().equals("")) {
                    MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyBuildCommand"));
                }
            }
        });
        if (this.buildCommand != null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer(this.buildCommand.toOSString());
            if (!this.isDefaultCommand && (string = this.buildArguments) != null && !string.equals("")) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.commandText.setText(stringBuffer.toString());
        }
        if (this.isDefaultCommand) {
            this.commandText.setEnabled(false);
        } else {
            this.commandText.setEnabled(true);
        }
        this.defButton.setSelection(this.isDefaultCommand);
    }

    private void createTargetControl(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_GROUP), (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.targetText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetText.setText(this.targetString);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (this.fTarget != null) {
            this.createButton(composite, 0, MakeUIPlugin.getResourceString("MakeTargetDialog.button.update"), true);
        } else {
            this.createButton(composite, 0, MakeUIPlugin.getResourceString("MakeTargetDialog.button.create"), true);
        }
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.targetNameText.setFocus();
        if (this.targetName != null) {
            this.targetNameText.setText(this.targetName);
        } else {
            this.targetNameText.setText(this.generateUniqueName(this.targetString));
        }
        this.targetNameText.selectAll();
    }

    private String generateUniqueName(String string) {
        String string2 = string;
        int n = 0;
        try {
            while (this.fTargetManager.findTarget(this.fContainer, string2) != null) {
                string2 = String.valueOf(string) + " (" + Integer.toString(++n) + ")";
            }
        }
        catch (CoreException coreException) {}
        return string2;
    }

    private boolean isStopOnError() {
        return this.stopOnErrorButton.getSelection();
    }

    private boolean useDefaultBuildCmd() {
        return this.defButton.getSelection();
    }

    private String getBuildLine() {
        String string;
        if (this.commandText != null && (string = this.commandText.getText()) != null) {
            return string.trim();
        }
        return null;
    }

    protected void okPressed() {
        IMakeTarget iMakeTarget = this.fTarget;
        try {
            if (this.fTarget == null) {
                iMakeTarget = this.fTargetManager.createTarget(this.fContainer.getProject(), this.targetNameText.getText().trim(), this.targetBuildID);
            }
            iMakeTarget.setStopOnError(this.isStopOnError());
            iMakeTarget.setUseDefaultBuildCmd(this.useDefaultBuildCmd());
            if (!this.useDefaultBuildCmd()) {
                String string = this.getBuildLine();
                int n = 0;
                int n2 = -1;
                if (!string.startsWith("\"")) {
                    n2 = string.indexOf(32);
                } else {
                    n = 1;
                    n2 = string.indexOf(34, 1);
                }
                Path path = n2 == -1 ? new Path(string) : new Path(string.substring(n, n2));
                iMakeTarget.setBuildCommand((IPath)path);
                String string2 = "";
                if (n2 != -1) {
                    string2 = string.substring(n2 + 1);
                }
                iMakeTarget.setBuildArguments(string2);
            }
            iMakeTarget.setBuildTarget(this.targetText.getText().trim());
            if (this.fTarget == null) {
                this.fTargetManager.addTarget(this.fContainer, iMakeTarget);
            } else if (!iMakeTarget.getName().equals(this.targetNameText.getText().trim())) {
                this.fTargetManager.renameTarget(iMakeTarget, this.targetNameText.getText().trim());
            }
        }
        catch (CoreException coreException) {
            MakeUIPlugin.errorDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.makeTargetError"), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.errorAddingTarget"), coreException);
        }
        super.okPressed();
    }
}

