/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class EditTargetAction
extends SelectionListenerAction {
    Shell shell;
    IResource resource;

    public EditTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("EditTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("EditTargetAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_EDIT);
    }

    public void run() {
        if (this.canRename()) {
            try {
                MakeTargetDialog makeTargetDialog = new MakeTargetDialog(this.shell, (IMakeTarget)this.getStructuredSelection().getFirstElement());
                makeTargetDialog.open();
            }
            catch (CoreException coreException) {
                MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("EditTargetAction.exception.internalError"), MakeUIPlugin.getResourceString("EditTargetAction.exception.errorEditingTarget"), coreException);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return super.updateSelection(iStructuredSelection) && this.canRename();
    }

    private boolean canRename() {
        List list = this.getStructuredSelection().toList();
        if (list.size() > 1 || list.size() < 1) {
            return false;
        }
        return list.get(0) instanceof IMakeTarget;
    }
}

