/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class BuildOptionListFieldEditor
extends FieldEditor {
    private static final String TITLE = "BuildPropertyCommon.label.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final String EDIT = "BuildPropertyCommon.label.editVar";
    private Composite top;
    private List list;
    private Group controlGroup;
    private String fieldName;
    private SelectionListener selectionListener;
    private Button addButton;
    private Button downButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;

    public BuildOptionListFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
        this.fieldName = string2;
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        String string = this.getNewInputObject();
        if (string != null && string.length() > 0) {
            int n = this.list.getSelectionIndex();
            if (n >= 0) {
                this.list.add(string, n + 1);
                this.list.setSelection(n + 1);
            } else {
                this.list.add(string, 0);
                this.list.setSelection(0);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int n) {
        ((GridData)this.top.getLayoutData()).horizontalSpan = n;
    }

    private void createButtons(Composite composite) {
        this.addButton = this.createPushButton(composite, ManagedBuilderUIPlugin.getResourceString(NEW));
        this.editButton = this.createPushButton(composite, ManagedBuilderUIPlugin.getResourceString(EDIT));
        this.removeButton = this.createPushButton(composite, ManagedBuilderUIPlugin.getResourceString(REMOVE));
        this.upButton = this.createPushButton(composite, ManagedBuilderUIPlugin.getResourceString(UP));
        this.downButton = this.createPushButton(composite, ManagedBuilderUIPlugin.getResourceString(DOWN));
    }

    protected String createList(String[] stringArray) {
        return BuildToolsSettingsStore.createList(stringArray);
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.heightHint = this.convertVerticalDLUsToPixels((Control)button, 14);
        int n = this.convertHorizontalDLUsToPixels((Control)button, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        this.top = composite;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        this.top.setLayoutData((Object)gridData);
        this.controlGroup = ControlFactory.createGroup((Composite)this.top, (String)this.getLabelText(), (int)2);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = n;
        this.controlGroup.setLayoutData((Object)gridData2);
        this.list = new List((Composite)this.controlGroup, 2820);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOptionListFieldEditor.this.selectionChanged();
            }
        });
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BuildOptionListFieldEditor.this.list = null;
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                BuildOptionListFieldEditor.this.editSelection();
            }
        });
        Composite composite2 = new Composite((Composite)this.controlGroup, 0);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 1;
        gridData3.verticalAlignment = 1;
        composite2.setLayoutData((Object)gridData3);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BuildOptionListFieldEditor.this.addButton = null;
                BuildOptionListFieldEditor.this.editButton = null;
                BuildOptionListFieldEditor.this.removeButton = null;
                BuildOptionListFieldEditor.this.upButton = null;
                BuildOptionListFieldEditor.this.downButton = null;
            }
        });
        this.createButtons(composite2);
        GridData gridData4 = new GridData(768);
        gridData4.heightHint = composite2.computeSize((int)-1, (int)-1).y;
        gridData4.widthHint = 200;
        this.list.setLayoutData((Object)gridData4);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Widget widget = selectionEvent.widget;
                if (widget == BuildOptionListFieldEditor.this.addButton) {
                    BuildOptionListFieldEditor.this.addPressed();
                } else if (widget == BuildOptionListFieldEditor.this.editButton) {
                    BuildOptionListFieldEditor.this.editPressed();
                } else if (widget == BuildOptionListFieldEditor.this.removeButton) {
                    BuildOptionListFieldEditor.this.removePressed();
                } else if (widget == BuildOptionListFieldEditor.this.upButton) {
                    BuildOptionListFieldEditor.this.upPressed();
                } else if (widget == BuildOptionListFieldEditor.this.downButton) {
                    BuildOptionListFieldEditor.this.downPressed();
                } else if (widget == BuildOptionListFieldEditor.this.list) {
                    BuildOptionListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void downPressed() {
        this.swap(false);
    }

    private void editPressed() {
        this.editSelection();
    }

    protected void editSelection() {
        String string;
        int n = this.list.getSelectionIndex();
        if (n != -1 && (string = this.list.getItem(n)) != null) {
            InputDialog inputDialog = new InputDialog(this.getShell(), ManagedBuilderUIPlugin.getResourceString(TITLE), this.fieldName, string, null);
            String string2 = null;
            if (inputDialog.open() == 0 && (string2 = inputDialog.getValue()) != null && !string2.equals(string)) {
                this.list.setItem(n, string2);
                this.selectionChanged();
            }
        }
    }

    protected void doLoad() {
        if (this.list != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            int n = 0;
            while (n < stringArray.length) {
                this.list.add(stringArray[n]);
                ++n;
            }
            this.list.setSelection(0);
            this.selectionChanged();
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            int n = 0;
            while (n < stringArray.length) {
                this.list.add(stringArray[n]);
                ++n;
            }
            this.list.setSelection(0);
            this.selectionChanged();
        }
    }

    protected void doStore() {
        String string = this.createList(this.list.getItems());
        if (string != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), string);
        }
    }

    protected String getNewInputObject() {
        InputDialog inputDialog = new InputDialog(this.getShell(), ManagedBuilderUIPlugin.getResourceString(TITLE), this.fieldName, new String(), null);
        String string = new String();
        if (inputDialog.open() == 0) {
            string = inputDialog.getValue();
        }
        return string;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected String[] parseString(String string) {
        return BuildToolsSettingsStore.parseString(string);
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int n = this.list.getSelectionIndex();
        if (n >= 0) {
            this.list.remove(n);
            this.list.setSelection(n - 1);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int n = this.list.getSelectionIndex();
        int n2 = this.list.getItemCount();
        this.editButton.setEnabled(n2 > 0);
        this.removeButton.setEnabled(n2 > 0);
        this.upButton.setEnabled(n2 > 1 && n > 0);
        this.downButton.setEnabled(n2 > 1 && n >= 0 && n < n2 - 1);
    }

    private void swap(boolean bl) {
        int n;
        this.setPresentsDefaultValue(false);
        int n2 = this.list.getSelectionIndex();
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        if (n2 >= 0) {
            String[] stringArray = this.list.getSelection();
            Assert.isTrue((stringArray.length == 1 ? 1 : 0) != 0);
            this.list.remove(n2);
            this.list.add(stringArray[0], n);
            this.list.setSelection(n);
        }
        this.selectionChanged();
    }

    protected void upPressed() {
        this.swap(true);
    }
}

