/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.ManageConfigDialog;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer {
    private static final String PREFIX = "BuildPropertyPage";
    private static final String LABEL = "BuildPropertyPage.label";
    private static final String NAME_LABEL = "BuildPropertyPage.label.NameText";
    private static final String BUILD_TOOLS_LABEL = "BuildPropertyPage.label.BuildToolTree";
    private static final String PLATFORM_LABEL = "BuildPropertyPage.label.Platform";
    private static final String CONFIG_LABEL = "BuildPropertyPage.label.Configuration";
    private static final String ACTIVE_LABEL = "BuildPropertyPage.label.Active";
    private static final String SETTINGS_LABEL = "BuildPropertyPage.label.Settings";
    private static final String TREE_LABEL = "BuildPropertyPage.label.ToolTree";
    private static final String OPTIONS_LABEL = "BuildPropertyPage.label.ToolOptions";
    private static final String ADD_CONF = "BuildPropertyPage.label.AddConfButton";
    private static final String TIP = "BuildPropertyPage.tip";
    private static final String PLAT_TIP = "BuildPropertyPage.tip.platform";
    private static final String CONF_TIP = "BuildPropertyPage.tip.config";
    private static final String ADD_TIP = "BuildPropertyPage.tip.addconf";
    private static final String MANAGE_TITLE = "BuildPropertyPage.manage.title";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private Combo targetSelector;
    private Combo configSelector;
    private Button manageConfigs;
    private TreeViewer optionList;
    private SashForm sashForm;
    private Group sashGroup;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;
    private ITarget[] targets;
    private ITarget selectedTarget;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private BuildSettingsPage currentSettingsPage;
    private Map configToPageListMap;
    private BuildToolsSettingsStore settingsStore;
    private IOptionCategory selectedCategory;
    private Point lastShellSize;
    private ITool selectedTool;
    private Point minimumPageSize = new Point(200, 200);

    public BuildPropertyPage() {
        this.configToPageListMap = new HashMap();
    }

    protected Control createContents(Composite composite) {
        this.targets = ManagedBuildManager.getTargets((IResource)this.getProject());
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)1);
        Group group = ControlFactory.createGroup((Composite)composite2, (String)ManagedBuilderUIPlugin.getResourceString(ACTIVE_LABEL), (int)1);
        GridData gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        group.setLayout((Layout)formLayout);
        Label label = ControlFactory.createLabel((Composite)group, (String)ManagedBuilderUIPlugin.getResourceString(PLATFORM_LABEL));
        this.targetSelector = ControlFactory.createSelectCombo((Composite)group, (String[])this.getPlatformNames(), null);
        this.targetSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BuildPropertyPage.this.handleTargetSelection();
            }
        });
        this.targetSelector.setToolTipText(ManagedBuilderUIPlugin.getResourceString(PLAT_TIP));
        Label label2 = ControlFactory.createLabel((Composite)group, (String)ManagedBuilderUIPlugin.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)group, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIPlugin.getResourceString(CONF_TIP));
        this.manageConfigs = ControlFactory.createPushButton((Composite)group, (String)ManagedBuilderUIPlugin.getResourceString(ADD_CONF));
        this.manageConfigs.setToolTipText(ManagedBuilderUIPlugin.getResourceString(ADD_TIP));
        this.manageConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPropertyPage.this.handleManageConfig();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.targetSelector, 0, 0x1000000);
        label.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        label2.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.configSelector, 0, 16384);
        formData.right = new FormAttachment(100, 0);
        this.targetSelector.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        formData.right = new FormAttachment(100, 0);
        this.manageConfigs.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label2, 5);
        formData.top = new FormAttachment(55, 0);
        formData.right = new FormAttachment((Control)this.manageConfigs, -5, 16384);
        this.configSelector.setLayoutData((Object)formData);
        this.sashGroup = ControlFactory.createGroup((Composite)composite2, (String)ManagedBuilderUIPlugin.getResourceString(SETTINGS_LABEL), (int)1);
        this.sashGroup.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm((Composite)this.sashGroup, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        this.sashForm.setLayout((Layout)gridLayout);
        this.createSelectionArea((Composite)this.sashForm);
        this.createEditArea((Composite)this.sashForm);
        this.initializeSashForm();
        this.handleTargetSelection();
        return composite2;
    }

    protected void createEditArea(Composite composite) {
        this.containerSC = new ScrolledComposite(composite, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        this.settingsPageContainer.layout();
    }

    protected void createSelectionArea(Composite composite) {
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)1);
        this.optionList = new TreeViewer(composite2, 2820);
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                BuildPropertyPage.this.handleOptionSelection();
            }
        });
        this.optionList.getControl().setLayoutData((Object)new GridData(1808));
        this.optionList.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
    }

    private void displayOptionsForCategory(IOptionCategory iOptionCategory) {
        Control[] controlArray;
        if (iOptionCategory == this.selectedCategory) {
            return;
        }
        this.selectedTool = null;
        this.selectedCategory = iOptionCategory;
        BuildSettingsPage buildSettingsPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List list = this.getPagesForConfig();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            controlArray = (Control[])listIterator.next();
            if (!(controlArray instanceof BuildOptionSettingsPage) || !((BuildOptionSettingsPage)controlArray).isForCategory(iOptionCategory)) continue;
            this.currentSettingsPage = controlArray;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildOptionSettingsPage(this.selectedConfiguration, iOptionCategory);
            list.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        controlArray = this.settingsPageContainer.getChildren();
        Control control = this.currentSettingsPage.getControl();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] != control) {
                controlArray[n].setVisible(false);
            }
            ++n;
        }
        this.currentSettingsPage.setVisible(true);
        if (buildSettingsPage != null) {
            buildSettingsPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private void displayOptionsForTool(ITool iTool) {
        Control[] controlArray;
        if (iTool == this.selectedTool) {
            return;
        }
        this.selectedCategory = null;
        this.selectedTool = iTool;
        BuildSettingsPage buildSettingsPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List list = this.getPagesForConfig();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            controlArray = (Control[])listIterator.next();
            if (!(controlArray instanceof BuildToolSettingsPage) || !((BuildToolSettingsPage)controlArray).isForTool(iTool)) continue;
            this.currentSettingsPage = controlArray;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildToolSettingsPage(this.selectedConfiguration, iTool);
            list.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        controlArray = this.settingsPageContainer.getChildren();
        Control control = this.currentSettingsPage.getControl();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] != control) {
                controlArray[n].setVisible(false);
            }
            ++n;
        }
        this.currentSettingsPage.setVisible(true);
        if (buildSettingsPage != null) {
            buildSettingsPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private String[] getConfigurationNames() {
        String[] stringArray = new String[this.configurations.length];
        int n = 0;
        while (n < this.configurations.length) {
            stringArray[n] = this.configurations[n].getName();
            ++n;
        }
        return stringArray;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    private List getPagesForConfig() {
        ArrayList arrayList = (ArrayList)this.configToPageListMap.get(this.selectedConfiguration.getId());
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.configToPageListMap.put(this.selectedConfiguration.getId(), arrayList);
        }
        return arrayList;
    }

    private String[] getPlatformNames() {
        String[] stringArray = new String[this.targets.length];
        int n = 0;
        while (n < this.targets.length) {
            stringArray[n] = this.targets[n].getName();
            ++n;
        }
        return stringArray;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null && iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        return null;
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    private void handleConfigSelection() {
        ITool iTool;
        IOptionCategory iOptionCategory;
        IOption[] iOptionArray;
        Object object;
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        this.selectedConfiguration = this.configurations[this.configSelector.getSelectionIndex()];
        ToolListContentProvider toolListContentProvider = new ToolListContentProvider();
        this.optionList.setContentProvider((IContentProvider)toolListContentProvider);
        this.optionList.setInput((Object)this.selectedConfiguration);
        this.optionList.expandAll();
        this.settingsStore = new BuildToolsSettingsStore(this.selectedConfiguration);
        Object[] objectArray = toolListContentProvider.getElements(this.selectedConfiguration);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null && object instanceof ITool && (iOptionArray = (iOptionCategory = (iTool = (ITool)object).getTopOptionCategory()).getOptions(this.selectedConfiguration)) != null && iOptionArray.length == 0) {
            IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
            int n = 0;
            while (n < iOptionCategoryArray.length) {
                IOptionCategory iOptionCategory2 = iOptionCategoryArray[n];
                IOption[] iOptionArray2 = iOptionCategory2.getOptions(this.selectedConfiguration);
                if (iOptionArray2 != null && iOptionArray2.length > 0) {
                    object = iOptionCategory2;
                    break;
                }
                ++n;
            }
        }
        if (object != null) {
            this.optionList.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    private void handleManageConfig() {
        ManageConfigDialog manageConfigDialog = new ManageConfigDialog(this.getShell(), ManagedBuilderUIPlugin.getResourceString(MANAGE_TITLE), this.selectedTarget);
        if (manageConfigDialog.open() == 0) {
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            String string = manageConfigDialog.getBuildArtifactName();
            if (!this.selectedTarget.getArtifactName().equals(string)) {
                this.selectedTarget.setArtifactName(string);
            }
            String string2 = manageConfigDialog.getBuildArtifaceExtension();
            if (!this.selectedTarget.getArtifactExtension().equals(string2)) {
                this.selectedTarget.setArtifactExtension(string2);
            }
            if (manageConfigDialog.useDefaultMakeCommand()) {
                this.selectedTarget.resetMakeCommand();
            } else {
                object3 = manageConfigDialog.getMakeCommand();
                object2 = this.parseMakeCommand((String)object3);
                this.selectedTarget.setMakeCommand((String)object2);
                object = this.parseMakeArgs((String)object3);
                this.selectedTarget.setMakeArguments((String)object);
            }
            object3 = manageConfigDialog.getDeletedConfigIds();
            object2 = object3.listIterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.selectedTarget.removeConfiguration((String)object);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(0);
                bl = true;
            }
            object = manageConfigDialog.getNewConfigs();
            Set set = object.keySet();
            Iterator iterator = set.iterator();
            Random random = new Random();
            random.setSeed(System.currentTimeMillis());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                IConfiguration iConfiguration = (IConfiguration)object.get(string3);
                if (iConfiguration == null) continue;
                int n = random.nextInt();
                if (n < 0) {
                    n *= -1;
                }
                String string4 = String.valueOf(iConfiguration.getId()) + "." + n;
                IConfiguration iConfiguration2 = this.selectedTarget.createConfiguration(iConfiguration, string4);
                iConfiguration2.setName(string3);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(this.configSelector.indexOf(string3));
                bl = true;
            }
            if (bl) {
                this.handleConfigSelection();
            }
        }
    }

    private void handleOptionSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.optionList.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ITool) {
            this.displayOptionsForTool((ITool)object);
        } else if (object instanceof IOptionCategory) {
            this.displayOptionsForCategory((IOptionCategory)object);
        }
    }

    private void handleTargetSelection() {
        if (this.targetSelector.getItemCount() == 0) {
            this.manageConfigs.setEnabled(false);
            return;
        }
        this.manageConfigs.setEnabled(true);
        this.selectedTarget = this.targets[this.targetSelector.getSelectionIndex()];
        this.populateConfigurations();
    }

    protected void initializeSashForm() {
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    private String parseMakeArgs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.parseMakeCommand(string);
        String string3 = string.substring(string2.length());
        if (string3.length() == 0) {
            return stringBuffer.toString().trim();
        }
        String[] stringArray = string3.trim().split("\\s");
        Pattern pattern = Pattern.compile("C|f|I|j|l|O|W");
        Pattern pattern2 = Pattern.compile("-[^CfIjloW]*[CfIjloW]{1}.+");
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string4.startsWith("--")) {
                stringBuffer.append(string4);
                stringBuffer.append(" ");
            } else if (string4.startsWith("-")) {
                if (n + 1 >= stringArray.length) {
                    stringBuffer.append(string4);
                } else {
                    String string5 = stringArray[n + 1];
                    Matcher matcher = pattern.matcher(string4);
                    if (!matcher.find()) {
                        stringBuffer.append(string4);
                        stringBuffer.append(" ");
                    } else if (pattern2.matcher(string4).matches()) {
                        stringBuffer.append(string4);
                        stringBuffer.append(" ");
                    } else {
                        stringBuffer.append(string4);
                        stringBuffer.append(" ");
                        stringBuffer.append(string5);
                        stringBuffer.append(" ");
                        ++n;
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private String parseMakeCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\s");
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (n + 1 >= stringArray.length) {
                stringBuffer.append(string2);
            } else {
                String string3 = stringArray[n + 1];
                if (string3.startsWith("-")) {
                    stringBuffer.append(string2);
                    break;
                }
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    protected void performDefaults() {
        List list = this.getPagesForConfig();
        list.clear();
        ManagedBuildManager.resetConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        this.settingsStore = new BuildToolsSettingsStore(this.getSelectedConfiguration());
        this.selectedCategory = null;
        this.handleOptionSelection();
    }

    public boolean performOk() {
        List list = this.getPagesForConfig();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BuildSettingsPage buildSettingsPage = (BuildSettingsPage)((Object)listIterator.next());
            if (buildSettingsPage instanceof BuildToolSettingsPage) {
                ((BuildToolSettingsPage)buildSettingsPage).performOk();
                continue;
            }
            if (!(buildSettingsPage instanceof BuildOptionSettingsPage)) continue;
            ((BuildOptionSettingsPage)buildSettingsPage).performOk();
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject());
        return true;
    }

    private void populateConfigurations() {
        if (this.configSelector == null) {
            return;
        }
        this.configurations = this.selectedTarget.getConfigurations();
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNames());
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration(this.selectedTarget);
        int n = this.configSelector.indexOf(iConfiguration.getName());
        this.configSelector.select(n == -1 ? 0 : n);
        this.handleConfigSelection();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setSize(rectangle.width, rectangle.height);
                ++n;
            }
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            int n3 = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.x;
            int n4 = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.y;
            Control[] controlArray = composite.getChildren();
            int n5 = 0;
            while (n5 < controlArray.length) {
                Point point = controlArray[n5].computeSize(-1, -1, bl);
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                ++n5;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3, n4);
        }
    }
}

