/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_ELEM_NAME = "ManagedProjectBuildInfo";
    private static final String FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "." + "ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = "ManagedBuildInfo";
    private static final String buildInfoVersion = "2.0.0";
    private static boolean extensionTargetsLoaded = false;
    private static Map extensionTargetMap;
    private static List extensionTargets;
    private static Map extensionToolMap;
    private static Map buildModelListeners;

    public static ITarget[] getDefinedTargets(IProject iProject) {
        ManagedBuildManager.loadExtensions();
        List list = null;
        int n = extensionTargets != null ? extensionTargets.size() + (list != null ? list.size() : 0) : 0;
        ITarget[] iTargetArray = new ITarget[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < extensionTargets.size()) {
            iTargetArray[n2++] = (ITarget)extensionTargets.get(n3);
            ++n3;
        }
        if (list != null) {
            n3 = 0;
            while (n3 < list.size()) {
                iTargetArray[n2++] = (ITarget)list.get(n3);
                ++n3;
            }
        }
        return iTargetArray;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    protected static Map getExtensionToolMap() {
        if (extensionToolMap == null) {
            extensionToolMap = new HashMap();
        }
        return extensionToolMap;
    }

    public static ITarget[] getTargets(IResource iResource) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource);
        if (iManagedBuildInfo != null) {
            List list = iManagedBuildInfo.getTargets();
            return list.toArray(new ITarget[list.size()]);
        }
        return emptyTargets;
    }

    public static ITool getTool(String string) {
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(string);
    }

    public static ITarget getTarget(IResource iResource, String string) {
        IManagedBuildInfo iManagedBuildInfo;
        ITarget iTarget = null;
        if (iResource != null && (iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource)) != null) {
            iTarget = iManagedBuildInfo.getTarget(string);
        }
        if (iTarget == null) {
            iTarget = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(string);
        }
        return iTarget;
    }

    public static void setDefaultConfiguration(IProject iProject, IConfiguration iConfiguration) {
        if (iProject == null || iConfiguration == null) {
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (iManagedBuildInfo != null) {
            iManagedBuildInfo.setDefaultConfiguration(iConfiguration);
        }
    }

    private static void setDirty(IConfiguration iConfiguration, IOption iOption) {
        IResource iResource = iConfiguration.getOwner();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource);
        iManagedBuildInfo.setDirty(true);
        if (iOption.getValueType() != 4 && iOption.getValueType() != 5) {
            return;
        }
        List list = (List)ManagedBuildManager.getBuildModelListeners().get(iResource);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ((IScannerInfoChangeListener)listIterator.next()).changeNotification(iResource, (IScannerInfo)ManagedBuildManager.getBuildInfo(iResource, false));
        }
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, boolean bl) {
        try {
            iConfiguration.setOption(iOption, bl);
            ManagedBuildManager.setDirty(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, String string) {
        try {
            iConfiguration.setOption(iOption, string);
            ManagedBuildManager.setDirty(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, String[] stringArray) {
        try {
            iConfiguration.setOption(iOption, stringArray);
            ManagedBuildManager.setDirty(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void saveBuildInfo(IProject iProject) {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(ROOT_ELEM_NAME);
        documentImpl.appendChild(element);
        ManagedBuildInfo managedBuildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (managedBuildInfo != null) {
            managedBuildInfo.serialize((Document)documentImpl, element);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setLineSeparator(System.getProperty("line.separator"));
        String string = null;
        try {
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"), outputFormat);
            serializer.asDOMSerializer().serialize((Document)documentImpl);
            string = byteArrayOutputStream.toString("UTF8");
            IFile iFile = iProject.getFile(FILE_NAME);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            if (iFile.exists()) {
                iFile.setContents((InputStream)byteArrayInputStream, 1, null);
            } else {
                iFile.create((InputStream)byteArrayInputStream, 1, null);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void removeBuildInfo(IResource iResource) {
        try {
            iResource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void resetConfiguration(IProject iProject, IConfiguration iConfiguration) {
        ManagedBuildManager.loadExtensions();
        IConfiguration iConfiguration2 = iConfiguration.getParent();
        ITarget iTarget = iConfiguration2.getTarget();
        IExtensionPoint iExtensionPoint = ManagedBuilderCorePlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("target") && iConfigurationElement.getAttribute("id").equals(iTarget.getId())) {
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
                    int n3 = 0;
                    while (n3 < iConfigurationElementArray2.length) {
                        IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n3];
                        if (iConfigurationElement2.getName().equals("configuration") && iConfigurationElement2.getAttribute("id").equals(iConfiguration2.getId())) {
                            ((Configuration)iConfiguration).reset(iConfigurationElement2);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void addExtensionTarget(Target target) {
        if (extensionTargets == null) {
            extensionTargets = new ArrayList();
        }
        extensionTargets.add(target);
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static void addExtensionTool(Tool tool) {
        ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
    }

    public static ITarget createTarget(IResource iResource, ITarget iTarget) throws BuildException {
        IResource iResource2 = iTarget.getOwner();
        if (iResource2 != null && iResource2.equals((Object)iResource)) {
            return iTarget;
        }
        if (iResource instanceof IProject) {
            if (iResource2 != null) {
                throw new BuildException(ManagedBuilderCorePlugin.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (iResource2 == null) {
                throw new BuildException(ManagedBuilderCorePlugin.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!iResource2.equals((Object)iResource.getProject())) {
                throw new BuildException(ManagedBuilderCorePlugin.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(iResource, iTarget);
    }

    private static ManagedBuildInfo loadBuildInfo(IProject iProject) {
        ManagedBuildInfo managedBuildInfo = null;
        IFile iFile = iProject.getFile(FILE_NAME);
        if (!iFile.exists()) {
            return null;
        }
        try {
            InputStream inputStream = iFile.getContents();
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Node node = document.getFirstChild();
            if (node.getNodeName().equals(ROOT_ELEM_NAME)) {
                managedBuildInfo = new ManagedBuildInfo((IResource)iProject, (Element)node);
                iProject.setSessionProperty(buildInfoProperty, (Object)managedBuildInfo);
            }
        }
        catch (Exception exception) {
            managedBuildInfo = null;
        }
        return managedBuildInfo;
    }

    private static void loadExtensions() {
        if (extensionTargetsLoaded) {
            return;
        }
        IPluginDescriptor iPluginDescriptor = ManagedBuilderCorePlugin.getDefault().getDescriptor();
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement iConfigurationElement;
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("tool")) {
                    new Tool(iConfigurationElement);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                iConfigurationElement = iConfigurationElementArray[n2];
                if (iConfigurationElement.getName().equals("target")) {
                    new Target(iConfigurationElement);
                }
                ++n2;
            }
            ++n;
        }
        extensionTargetsLoaded = true;
    }

    public static boolean manages(IResource iResource) {
        IProject iProject = null;
        if (iResource instanceof IProject) {
            iProject = (IProject)iResource;
        } else if (iResource instanceof IFile) {
            iProject = ((IFile)iResource).getProject();
        } else {
            return false;
        }
        IFile iFile = iProject.getFile(FILE_NAME);
        if (iFile.exists()) {
            try {
                InputStream inputStream = iFile.getContents();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                Node node = document.getFirstChild();
                if (node.getNodeName().equals(ROOT_ELEM_NAME)) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource iResource, boolean bl) {
        ManagedBuildManager.loadExtensions();
        ManagedBuildInfo managedBuildInfo = null;
        try {
            managedBuildInfo = (ManagedBuildInfo)iResource.getSessionProperty(buildInfoProperty);
            if (managedBuildInfo != null) {
                managedBuildInfo.updateOwner(iResource);
            }
        }
        catch (CoreException coreException) {
            return managedBuildInfo;
        }
        if (managedBuildInfo == null && iResource instanceof IProject) {
            managedBuildInfo = ManagedBuildManager.loadBuildInfo((IProject)iResource);
        }
        if (managedBuildInfo == null && bl) {
            try {
                managedBuildInfo = new ManagedBuildInfo(iResource);
                iResource.setSessionProperty(buildInfoProperty, (Object)managedBuildInfo);
            }
            catch (CoreException coreException) {
                managedBuildInfo = null;
            }
        }
        return managedBuildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource iResource, boolean bl) {
        return ManagedBuildManager.findBuildInfo(iResource, bl);
    }

    public static IManagedBuildInfo getBuildInfo(IResource iResource) {
        return ManagedBuildManager.findBuildInfo(iResource, false);
    }

    public static String getBuildInfoVersion() {
        return buildInfoVersion;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo(iResource, false);
    }

    public synchronized void subscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> arrayList = (ArrayList<IScannerInfoChangeListener>)map.get(iResource2);
        if (arrayList == null) {
            arrayList = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!arrayList.contains(iScannerInfoChangeListener)) {
            arrayList.add(iScannerInfoChangeListener);
            map.put(iResource2, arrayList);
        }
    }

    public synchronized void unsubscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(iResource2);
        if (list != null && !list.isEmpty()) {
            list.remove(iScannerInfoChangeListener);
            map.put(iResource2, list);
        }
    }
}

