/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Configuration
extends BuildObject
implements IConfiguration {
    private ITarget target;
    private IConfiguration parent;
    private List toolReferences;

    public Configuration(Target target, Element element) {
        Object object;
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("parent")) {
            object = target.getParent();
            this.parent = object != null ? object.getConfiguration(element.getAttribute("parent")) : null;
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeName().equals("toolReference")) {
                new ToolReference((BuildObject)this, (Element)node);
            }
            ++n;
        }
    }

    public Configuration(Target target, IConfiguration iConfiguration, String string) {
        this.id = string;
        this.name = iConfiguration.getName();
        this.target = target;
        this.parent = iConfiguration;
        IProject cfr_ignored_0 = (IProject)target.getOwner();
        List list = ((Configuration)iConfiguration).getLocalToolReferences();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference = (ToolReference)listIterator.next();
            ToolReference toolReference2 = new ToolReference((BuildObject)this, toolReference.getTool());
            List list2 = toolReference.getOptionReferenceList();
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                OptionReference optionReference = (OptionReference)listIterator2.next();
                IOption iOption = optionReference.getOption();
                try {
                    switch (iOption.getValueType()) {
                        case 0: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getBooleanValue());
                            break;
                        }
                        case 2: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getStringValue());
                            break;
                        }
                        case 1: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getSelectedEnum());
                            break;
                        }
                        case 3: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getStringListValue());
                            break;
                        }
                        case 4: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getIncludePaths());
                            break;
                        }
                        case 5: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getDefinedSymbols());
                            break;
                        }
                        case 6: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getLibraries());
                            break;
                        }
                        case 7: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getUserObjects());
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        target.addConfiguration(this);
    }

    public Configuration(Target target, IConfigurationElement iConfigurationElement) {
        this.target = target;
        this.setId(iConfigurationElement.getAttribute("id"));
        target.addConfiguration(this);
        this.setName(iConfigurationElement.getAttribute("name"));
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if (iConfigurationElement2.getName().equals("toolReference")) {
                new ToolReference((BuildObject)this, iConfigurationElement2);
            }
            ++n;
        }
    }

    public Configuration(Target target, String string) {
        this.id = string;
        this.target = target;
        target.addConfiguration(this);
    }

    public void addToolReference(ToolReference toolReference) {
        this.getLocalToolReferences().add(toolReference);
    }

    private OptionReference createOptionReference(IOption iOption) {
        if (iOption instanceof OptionReference) {
            OptionReference optionReference = (OptionReference)iOption;
            ToolReference toolReference = optionReference.getToolReference();
            if (toolReference.ownedByConfiguration(this)) {
                return optionReference;
            }
            toolReference = new ToolReference((BuildObject)this, toolReference);
            return toolReference.createOptionReference(iOption);
        }
        ToolReference toolReference = this.getToolReference(iOption.getTool());
        if (toolReference == null) {
            toolReference = new ToolReference((BuildObject)this, iOption.getTool());
        }
        return toolReference.createOptionReference(iOption);
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITool[] getTools() {
        ITool[] iToolArray = this.parent != null ? this.parent.getTools() : this.target.getTools();
        IProject iProject = (IProject)this.target.getOwner();
        if (iProject != null) {
            ArrayList<ITool> arrayList = new ArrayList<ITool>();
            int n = 0;
            while (n < iToolArray.length) {
                ITool iTool = iToolArray[n];
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        try {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            arrayList.add(iTool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 1: {
                        try {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            arrayList.add(iTool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 2: {
                        arrayList.add(iTool);
                    }
                }
                ++n;
            }
            iToolArray = arrayList.toArray(new ITool[arrayList.size()]);
        }
        int n = 0;
        while (n < iToolArray.length) {
            ToolReference toolReference = this.getToolReference(iToolArray[n]);
            if (toolReference != null) {
                iToolArray[n] = toolReference;
            }
            ++n;
        }
        return iToolArray;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    protected List getOptionReferences(ITool iTool) {
        ArrayList<OptionReference> arrayList = new ArrayList<OptionReference>();
        ToolReference toolReference = this.getToolReference(iTool);
        if (toolReference != null) {
            arrayList.addAll(toolReference.getOptionReferenceList());
        }
        if (this.parent != null) {
            List list = ((Configuration)this.parent).getOptionReferences(iTool);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                OptionReference optionReference = (OptionReference)listIterator.next();
                if (arrayList.contains(optionReference)) continue;
                arrayList.add(optionReference);
            }
        }
        return arrayList;
    }

    public ITarget getTarget() {
        return this.target == null && this.parent != null ? this.parent.getTarget() : this.target;
    }

    public IResource getOwner() {
        return this.getTarget().getOwner();
    }

    private ToolReference getToolReference(ITool iTool) {
        ToolReference toolReference = null;
        if (iTool == null) {
            return toolReference;
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference2 = (ToolReference)listIterator.next();
            if (!toolReference2.references(iTool)) continue;
            toolReference = toolReference2;
            break;
        }
        return toolReference;
    }

    public void reset(IConfigurationElement iConfigurationElement) {
        this.getLocalToolReferences().clear();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if (iConfigurationElement2.getName().equals("toolReference")) {
                new ToolReference((BuildObject)this, iConfigurationElement2);
            }
            ++n;
        }
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference = (ToolReference)listIterator.next();
            Element element2 = document.createElement("toolReference");
            element.appendChild(element2);
            toolReference.serialize(document, element2);
        }
    }

    public void setOption(IOption iOption, boolean bl) throws BuildException {
        if (iOption.getBooleanValue() != bl) {
            this.createOptionReference(iOption).setValue(bl);
        }
    }

    public void setOption(IOption iOption, String string) throws BuildException {
        String string2 = iOption.getValueType() == 1 ? iOption.getSelectedEnum() : iOption.getStringValue();
        if (string2 != null && !string2.equals(string)) {
            this.createOptionReference(iOption).setValue(string);
        }
    }

    public void setOption(IOption iOption, String[] stringArray) throws BuildException {
        Object[] objectArray;
        switch (iOption.getValueType()) {
            case 3: {
                objectArray = iOption.getStringListValue();
                break;
            }
            case 4: {
                objectArray = iOption.getIncludePaths();
                break;
            }
            case 5: {
                objectArray = iOption.getDefinedSymbols();
                break;
            }
            case 6: {
                objectArray = iOption.getLibraries();
                break;
            }
            case 7: {
                objectArray = iOption.getUserObjects();
                break;
            }
            default: {
                objectArray = new String[]{};
            }
        }
        if (!Arrays.equals(stringArray, objectArray)) {
            this.createOptionReference(iOption).setValue(stringArray);
        }
    }

    public void setToolCommand(ITool iTool, String string) {
        if (string != null) {
            ToolReference toolReference = this.getToolReference(iTool);
            if (toolReference == null) {
                toolReference = new ToolReference((BuildObject)this, iTool);
            }
            if (toolReference != null) {
                toolReference.setToolCommand(string);
            }
        }
    }
}

