/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.sourcedependency.DependencyQueryJob;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class MakefileGenerator {
    private static final int COLS_PER_LINE = 80;
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String COMMENT = "ManagedMakeBuilder.comment";
    private static final String HEADER = "ManagedMakeBuilder.comment.header";
    private static final String MOD_LIST = "ManagedMakeBuilder.comment.module.list";
    private static final String SRC_LISTS = "ManagedMakeBuilder.comment.source.list";
    private static final String MOD_RULES = "ManagedMakeBuilder.comment.build.rule";
    private static final String MOD_INCL = "ManagedMakeBuilder.comment.module.make.includes";
    private static final String DEP_INCL = "ManagedMakeBuilder.comment.module.dep.includes";
    private static final String AUTO_DEP = "ManagedMakeBuilder.comment.autodeps";
    protected static final String COLON = ":";
    protected static final String DEPFILE_NAME = "subdir.dep";
    protected static final String DOT = ".";
    protected static final String MAKEFILE_NAME = "makefile";
    protected static final String MODFILE_NAME = "subdir.mk";
    protected static final String LINEBREAK = "\\";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String LOGICAL_AND = "&&";
    protected static final String SEPARATOR = "/";
    protected static final String TAB = "\t";
    protected static final String WHITESPACE = " ";
    protected static final String WILDCARD = "%";
    protected static final String COMMENT_SYMBOL = "#";
    protected static final String MAKEFILE_INIT = "makefile.init";
    protected static final String MAKEFILE_DEFS = "makefile.defs";
    protected static final String MAKEFILE_TARGETS = "makefile.targets";
    protected IManagedBuildInfo info;
    protected List modifiedList;
    protected IProgressMonitor monitor;
    protected List subdirList;
    protected IProject project;
    protected List ruleList;
    protected IPath topBuildDir;
    private String target;
    private String extension;

    public MakefileGenerator(IProject iProject, IManagedBuildInfo iManagedBuildInfo, IProgressMonitor iProgressMonitor) {
        this.project = iProject;
        this.monitor = iProgressMonitor;
        this.info = iManagedBuildInfo;
        this.target = iManagedBuildInfo.getBuildArtifactName();
        this.extension = iManagedBuildInfo.getBuildArtifactExtension();
        if (this.extension == null) {
            this.extension = new String();
        }
    }

    protected StringBuffer addSourceDependencies(IContainer iContainer) throws CoreException {
        IPath iPath = iContainer.getProjectRelativePath();
        String string = iPath.toString();
        string = String.valueOf(string) + (string.length() == 0 ? "" : SEPARATOR);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(AUTO_DEP) + NEWLINE);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        IResource[] iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            block7: {
                String string2;
                String string3;
                IResource iResource = iResourceArray[n];
                if (iResource.getType() == 1 && this.info.buildsFileType(string3 = iResource.getFileExtension()) && (string2 = iResource.getFullPath().removeFileExtension().lastSegment()) != null) {
                    String string4 = this.info.getOutputExtension(string3);
                    if (string4 != null) {
                        string2 = String.valueOf(string2) + DOT + string4;
                    }
                    ArrayList arrayList = new ArrayList();
                    try {
                        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.project, (IFile)iResource, indexManager, arrayList), 3, null, null);
                    }
                    catch (Exception exception) {
                        break block7;
                    }
                    if (arrayList.size() != 0) {
                        stringBuffer.append(String.valueOf(string) + string2 + COLON + WHITESPACE);
                        ListIterator listIterator = ((AbstractList)arrayList).listIterator();
                        while (listIterator.hasNext()) {
                            stringBuffer.append(LINEBREAK + NEWLINE);
                            String string5 = (String)listIterator.next();
                            String string6 = this.escapeWhitespaces(string5);
                            stringBuffer.append(string6);
                            if (!listIterator.hasNext()) continue;
                            stringBuffer.append(WHITESPACE);
                        }
                        stringBuffer.append(NEWLINE);
                    }
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    private String escapeWhitespaces(String string) {
        String[] stringArray = string.split("\\s");
        if (stringArray.length > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < stringArray.length) {
                    stringBuffer.append("\\ ");
                }
                ++n;
            }
            return stringBuffer.toString().trim();
        }
        return string;
    }

    protected StringBuffer addTopHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addFragmentDependenciesHeader() {
        return this.addDefaultHeader();
    }

    protected void outputCommentLine(StringBuffer stringBuffer) {
        int n = 0;
        while (n < 80) {
            stringBuffer.append(COMMENT_SYMBOL);
            ++n;
        }
        stringBuffer.append(NEWLINE);
    }

    protected StringBuffer addDefaultHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outputCommentLine(stringBuffer);
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(HEADER) + NEWLINE);
        this.outputCommentLine(stringBuffer);
        stringBuffer.append(NEWLINE);
        return stringBuffer;
    }

    protected StringBuffer addMacros() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ROOT := .." + NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.init" + NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("RM := ");
        stringBuffer.append(String.valueOf(this.info.getCleanCommand()) + NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(SRC_LISTS) + NEWLINE);
        stringBuffer.append("C_SRCS := " + NEWLINE);
        stringBuffer.append("CC_SRCS := " + NEWLINE);
        stringBuffer.append("CXX_SRCS := " + NEWLINE);
        stringBuffer.append("CAPC_SRCS := " + NEWLINE);
        stringBuffer.append("CPP_SRCS := " + NEWLINE + NEWLINE);
        stringBuffer.append("LIBS := ");
        String[] stringArray = this.info.getLibsForTarget(this.extension);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringBuffer.append(LINEBREAK + NEWLINE + string);
            ++n;
        }
        stringBuffer.append(String.valueOf(NEWLINE) + NEWLINE);
        stringBuffer.append("USER_OBJS := ");
        String[] stringArray2 = this.info.getUserObjectsForTarget(this.extension);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = stringArray2[n2];
            stringBuffer.append(LINEBREAK + NEWLINE + string);
            ++n2;
        }
        stringBuffer.append(String.valueOf(NEWLINE) + NEWLINE);
        stringBuffer.append("OBJS = $(C_SRCS:$(ROOT)/%.c=%.o) $(CC_SRCS:$(ROOT)/%.cc=%.o) $(CXX_SRCS:$(ROOT)/%.cxx=%.o) $(CAPC_SRCS:$(ROOT)/%.C=%.o) $(CPP_SRCS:$(ROOT)/%.cpp=%.o)" + NEWLINE);
        return stringBuffer.append(NEWLINE);
    }

    protected StringBuffer addSubdirectories() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(MOD_LIST) + NEWLINE);
        stringBuffer.append("SUBDIRS := \\" + NEWLINE);
        ListIterator listIterator = this.getSubdirList().listIterator();
        while (listIterator.hasNext()) {
            IContainer iContainer = (IContainer)listIterator.next();
            if (iContainer.getFullPath() == this.project.getFullPath()) {
                stringBuffer.append(". \\" + NEWLINE);
                continue;
            }
            IPath iPath = iContainer.getProjectRelativePath();
            stringBuffer.append(String.valueOf(iPath.toString()) + WHITESPACE + LINEBREAK + NEWLINE);
        }
        stringBuffer.append(NEWLINE);
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(MOD_INCL) + NEWLINE);
        stringBuffer.append("-include ${patsubst %, %/subdir.mk, $(SUBDIRS)}" + NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.defs" + NEWLINE);
        stringBuffer.append(NEWLINE);
        return stringBuffer;
    }

    protected StringBuffer addSources(IContainer iContainer) throws CoreException {
        IPath iPath = iContainer.getProjectRelativePath();
        String string = iPath.toString();
        string = String.valueOf(string) + (string.length() == 0 ? "" : SEPARATOR);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("C_SRCS += \\" + NEWLINE);
        stringBuffer2.append("${addprefix $(ROOT)/" + string + "," + LINEBREAK + NEWLINE);
        StringBuffer stringBuffer3 = new StringBuffer("CC_SRCS += \\" + NEWLINE);
        stringBuffer3.append("${addprefix $(ROOT)/" + string + "," + LINEBREAK + NEWLINE);
        StringBuffer stringBuffer4 = new StringBuffer("CXX_SRCS += \\" + NEWLINE);
        stringBuffer4.append("${addprefix $(ROOT)/" + string + "," + LINEBREAK + NEWLINE);
        StringBuffer stringBuffer5 = new StringBuffer("CAPC_SRCS += \\" + NEWLINE);
        stringBuffer5.append("${addprefix $(ROOT)/" + string + "," + LINEBREAK + NEWLINE);
        StringBuffer stringBuffer6 = new StringBuffer("CPP_SRCS += \\" + NEWLINE);
        stringBuffer6.append("${addprefix $(ROOT)/" + string + "," + LINEBREAK + NEWLINE);
        StringBuffer stringBuffer7 = new StringBuffer("# " + ManagedBuilderCorePlugin.getResourceString(MOD_RULES) + NEWLINE);
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(SRC_LISTS) + NEWLINE);
        IResource[] iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            String string2;
            IResource iResource = iResourceArray[n];
            if (iResource.getType() == 1 && this.info.buildsFileType(string2 = iResource.getFileExtension())) {
                if (new String("c").equals(string2)) {
                    stringBuffer2.append(String.valueOf(iResource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("cc").equalsIgnoreCase(string2)) {
                    stringBuffer3.append(String.valueOf(iResource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("cxx").equalsIgnoreCase(string2)) {
                    stringBuffer4.append(String.valueOf(iResource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("C").equals(string2)) {
                    stringBuffer5.append(String.valueOf(iResource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else {
                    stringBuffer6.append(String.valueOf(iResource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                }
                this.addRule(string, stringBuffer7, iResource);
            }
            ++n;
        }
        stringBuffer.append(stringBuffer2.append("}" + NEWLINE + NEWLINE));
        stringBuffer.append(stringBuffer3.append("}" + NEWLINE + NEWLINE));
        stringBuffer.append(stringBuffer4.append("}" + NEWLINE + NEWLINE));
        stringBuffer.append(stringBuffer5.append("}" + NEWLINE + NEWLINE));
        stringBuffer.append(stringBuffer6.append("}" + NEWLINE + NEWLINE));
        return stringBuffer.append(stringBuffer7 + NEWLINE);
    }

    protected StringBuffer addTargets(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.info.getToolForTarget(this.extension);
        String string2 = this.info.getFlagsForTarget(this.extension);
        String string3 = this.info.getOutputFlag(this.extension);
        String string4 = this.info.getOutputPrefix(this.extension);
        String string5 = bl ? "clean all" : "all";
        IProject[] iProjectArray = null;
        try {
            iProjectArray = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String string6 = "all:";
        if (iProjectArray.length > 0) {
            string6 = String.valueOf(string6) + " deps";
        }
        stringBuffer.append(String.valueOf(string6) + WHITESPACE + string4 + this.target);
        if (this.extension.length() > 0) {
            stringBuffer.append(DOT + this.extension);
        }
        stringBuffer.append(String.valueOf(NEWLINE) + NEWLINE);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iProjectArray.length > 0) {
            stringBuffer.append("deps:" + NEWLINE);
            if (iProjectArray != null) {
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject = iProjectArray[n];
                    String string7 = iProject.getLocation().toString();
                    String string8 = string5;
                    if (ManagedBuildManager.manages((IResource)iProject)) {
                        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
                        string7 = String.valueOf(string7) + SEPARATOR + iManagedBuildInfo.getConfigurationName();
                        String string9 = iManagedBuildInfo.getBuildArtifactName();
                        String string10 = iManagedBuildInfo.getBuildArtifactExtension();
                        String string11 = iManagedBuildInfo.getOutputPrefix(string10);
                        if (iManagedBuildInfo.isDirty()) {
                            string8 = "clean all";
                        }
                        String string12 = String.valueOf(string7) + SEPARATOR + string11 + string9;
                        if (string10.length() > 0) {
                            string12 = String.valueOf(string12) + DOT + string10;
                        }
                        arrayList.add(string12);
                    }
                    stringBuffer.append("\t-cd " + string7 + WHITESPACE + LOGICAL_AND + WHITESPACE + "$(MAKE) " + string8 + NEWLINE);
                    ++n;
                }
            }
            stringBuffer.append(NEWLINE);
        }
        stringBuffer.append(String.valueOf(string4) + this.target);
        if (this.extension.length() > 0) {
            stringBuffer.append(DOT + this.extension);
        }
        stringBuffer.append(": $(OBJS)");
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(WHITESPACE + (String)listIterator.next());
        }
        stringBuffer.append(NEWLINE);
        stringBuffer.append(TAB + string + WHITESPACE + string2 + WHITESPACE + string3 + WHITESPACE + "$@" + WHITESPACE + "$(OBJS) $(USER_OBJS) $(LIBS)");
        stringBuffer.append(String.valueOf(NEWLINE) + NEWLINE);
        stringBuffer.append("clean:" + NEWLINE);
        stringBuffer.append("\t-$(RM) $(OBJS) " + string4 + this.target + NEWLINE + NEWLINE);
        stringBuffer.append(".PHONY: all clean deps" + NEWLINE + NEWLINE);
        stringBuffer.append("# " + ManagedBuilderCorePlugin.getResourceString(DEP_INCL) + NEWLINE);
        stringBuffer.append("-include ${patsubst %, %/subdir.dep, $(SUBDIRS)}" + NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.targets" + NEWLINE);
        return stringBuffer;
    }

    protected void addRule(String string, StringBuffer stringBuffer, IResource iResource) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        string5 = iResource.getFileExtension();
        string6 = this.info.getOutputExtension(string5);
        string2 = String.valueOf(string) + WILDCARD + DOT + string6 + COLON + WHITESPACE + "$(ROOT)" + SEPARATOR + string + WILDCARD + DOT + string5;
        if (!this.getRuleList().contains(string2)) {
            this.getRuleList().add(string2);
            stringBuffer.append(String.valueOf(string2) + NEWLINE);
            string3 = this.info.getToolForSource(string5);
            string4 = this.info.getFlagsForSource(string5);
            string7 = this.info.getOutputFlag(string6);
            string8 = this.info.getOutputPrefix(string6);
            stringBuffer.append(TAB + string3 + WHITESPACE + string4 + WHITESPACE + string7 + WHITESPACE + string8 + "$@" + WHITESPACE + "$<" + NEWLINE + NEWLINE);
        }
    }

    public void appendBuildSubdirectory(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (!this.getSubdirList().contains(iContainer)) {
            this.getSubdirList().add(iContainer);
        }
    }

    public void appendModifiedSubdirectory(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (!this.getModifiedList().contains(iContainer)) {
            this.getModifiedList().add(iContainer);
        }
    }

    public void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void generateMakefiles(IResourceDelta iResourceDelta) throws CoreException {
        IFile iFile;
        IContainer iContainer;
        IFolder iFolder = this.project.getFolder(this.info.getConfigurationName());
        if (!iFolder.exists()) {
            this.regenerateMakefiles();
            return;
        }
        ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(this, this.info);
        iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        this.checkCancel();
        ResourceProxyVisitor resourceProxyVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceProxyVisitor, 0);
        this.checkCancel();
        ListIterator listIterator = this.getSubdirList().listIterator();
        while (listIterator.hasNext()) {
            iContainer = (IContainer)listIterator.next();
            if (this.getModifiedList().contains(iContainer)) continue;
            iFile = this.project.getFile(iContainer.getFullPath().addTrailingSeparator().append(MODFILE_NAME));
            IFile iFile2 = this.project.getFile(iContainer.getFullPath().addTrailingSeparator().append(DEPFILE_NAME));
            if (iFile.exists() && iFile2.exists()) continue;
            this.getModifiedList().add(iContainer);
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        iContainer = this.topBuildDir.addTrailingSeparator().append(MAKEFILE_NAME);
        iFile = this.createFile((IPath)iContainer);
        this.populateTopMakefile(iFile, false);
        this.checkCancel();
        listIterator = this.getModifiedList().listIterator();
        while (listIterator.hasNext()) {
            this.populateFragmentMakefile((IContainer)listIterator.next());
            this.checkCancel();
        }
    }

    private List getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new ArrayList();
        }
        return this.modifiedList;
    }

    private List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    private List getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new ArrayList();
        }
        return this.subdirList;
    }

    private IPath createDirectory(String string) throws CoreException {
        IFolder iFolder = this.project.getFolder(string);
        if (!iFolder.exists()) {
            IFolder iFolder2;
            IPath iPath = new Path(string).removeLastSegments(1);
            if (!iPath.isEmpty() && !(iFolder2 = this.project.getFolder(iPath)).exists()) {
                this.createDirectory(iPath.toString());
            }
            try {
                iFolder.create(true, true, null);
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() == 374) {
                    iFolder.refreshLocal(0, null);
                }
                throw coreException;
            }
        }
        return iFolder.getFullPath();
    }

    private IFile createFile(IPath iPath) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation(iPath);
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFile(iPath);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            iFile.create((InputStream)byteArrayInputStream, false, this.monitor);
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        return iFile;
    }

    public IPath getTopBuildDir() {
        return this.topBuildDir;
    }

    public boolean isGeneratedResource(IResource iResource) {
        IPath iPath = iResource.getProjectRelativePath();
        String[] stringArray = this.info.getConfigurationNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Path path = new Path(string);
            if (path.isPrefixOf(iPath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void populateTopMakefile(IFile iFile, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addTopHeader());
        stringBuffer.append(this.addMacros());
        stringBuffer.append(this.addSubdirectories());
        stringBuffer.append(this.addTargets(bl));
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
    }

    protected void populateFragmentMakefile(IContainer iContainer) throws CoreException {
        IPath iPath = iContainer.getProjectRelativePath();
        IPath iPath2 = this.getTopBuildDir().removeFirstSegments(1);
        if (iPath2 == null) {
            return;
        }
        IPath iPath3 = iPath2.append(iPath);
        IPath iPath4 = this.createDirectory(iPath3.toString());
        IFile iFile = this.createFile(iPath4.addTrailingSeparator().append(MODFILE_NAME));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addFragmentMakefileHeader());
        stringBuffer.append(this.addSources(iContainer));
        IFile iFile2 = this.createFile(iPath4.addTrailingSeparator().append(DEPFILE_NAME));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.addFragmentDependenciesHeader());
        stringBuffer2.append(this.addSourceDependencies(iContainer));
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
        Util.save((StringBuffer)stringBuffer2, (IFile)iFile2);
    }

    public void regenerateMakefiles() throws CoreException {
        ResourceProxyVisitor resourceProxyVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceProxyVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            return;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        IPath iPath = this.topBuildDir.addTrailingSeparator().append(MAKEFILE_NAME);
        IFile iFile = this.createFile(iPath);
        this.populateTopMakefile(iFile, true);
        this.checkCancel();
        ListIterator listIterator = this.getSubdirList().listIterator();
        while (listIterator.hasNext()) {
            this.populateFragmentMakefile((IContainer)listIterator.next());
            this.checkCancel();
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private MakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(MakefileGenerator makefileGenerator2, IManagedBuildInfo iManagedBuildInfo) {
            this.generator = makefileGenerator2;
            this.info = iManagedBuildInfo;
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (iResourceProxy.getType() == 1) {
                IResource iResource = iResourceProxy.requestResource();
                String string = iResource.getFileExtension();
                if (this.info.buildsFileType(string) && !this.generator.isGeneratedResource(iResource)) {
                    this.generator.appendBuildSubdirectory(iResource);
                }
                return false;
            }
            return true;
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private MakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(MakefileGenerator makefileGenerator2, IManagedBuildInfo iManagedBuildInfo) {
            this.generator = makefileGenerator2;
            this.info = iManagedBuildInfo;
        }

        private IResource[] findDependencies(IResource iResource) {
            PathCollector pathCollector = new PathCollector();
            ICSearchScope iCSearchScope = SearchEngine.createWorkspaceScope();
            CSearchPattern cSearchPattern = CSearchPattern.createPattern((String)iResource.getLocation().toOSString(), (ICSearchConstants.SearchFor)ICSearchConstants.INCLUDE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (int)0, (boolean)true);
            IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
            indexManager.performConcurrentJob((IJob)new PatternSearchJob(cSearchPattern, iCSearchScope, (IIndexSearchRequestor)pathCollector, indexManager), 3, null, null);
            String[] stringArray = pathCollector.getPaths();
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            IResource iResource2 = null;
            IWorkspaceRoot iWorkspaceRoot = null;
            if (this.generator.project != null) {
                iWorkspaceRoot = this.generator.project.getWorkspace().getRoot();
            }
            int n = 0;
            while (n < stringArray.length) {
                iResource2 = iWorkspaceRoot.findMember(stringArray[n]);
                if (iResource2 != null) {
                    arrayList.add(iResource2);
                }
                ++n;
            }
            return arrayList.toArray(new IResource[arrayList.size()]);
        }

        private void handleHeaderDependency(IResource iResource, boolean bl) {
            if (iResource.getProject().equals((Object)this.generator.project)) {
                this.generator.appendModifiedSubdirectory(iResource);
            } else if (bl) {
                try {
                    iResource.touch((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResourceDelta[] iResourceDeltaArray;
            boolean bl = false;
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 1) {
                iResourceDeltaArray = iResource.getFileExtension();
                boolean bl2 = false;
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        boolean bl3 = bl2 = iResourceDelta.getFlags() == 8192;
                        if (this.generator.isGeneratedResource(iResource)) break;
                        if (this.info.buildsFileType((String)iResourceDeltaArray)) {
                            this.generator.appendModifiedSubdirectory(iResource);
                            break;
                        }
                        if (!this.info.isHeaderFile((String)iResourceDeltaArray)) break;
                        this.generator.appendModifiedSubdirectory(iResource);
                        IResource[] iResourceArray = this.findDependencies(iResource);
                        int n = 0;
                        while (n < iResourceArray.length) {
                            this.handleHeaderDependency(iResourceArray[n], bl2);
                            ++n;
                        }
                        break;
                    }
                    case 2: {
                        boolean bl4 = bl2 = iResourceDelta.getFlags() == 4096;
                        if (this.generator.isGeneratedResource(iResource)) break;
                        if (this.info.buildsFileType((String)iResourceDeltaArray)) {
                            this.generator.appendModifiedSubdirectory(iResource);
                            break;
                        }
                        if (!this.info.isHeaderFile((String)iResourceDeltaArray)) break;
                        this.generator.appendModifiedSubdirectory(iResource);
                        IResource[] iResourceArray = this.findDependencies(iResource);
                        int n = 0;
                        while (n < iResourceArray.length) {
                            this.handleHeaderDependency(iResourceArray[n], bl2);
                            ++n;
                        }
                        break;
                    }
                    case 4: {
                        if (this.generator.isGeneratedResource(iResource)) break;
                        if (this.info.buildsFileType((String)iResourceDeltaArray)) {
                            bl = true;
                            break;
                        }
                        if (!this.info.isHeaderFile((String)iResourceDeltaArray)) break;
                        this.generator.appendModifiedSubdirectory(iResource);
                        IResource[] iResourceArray = this.findDependencies(iResource);
                        int n = 0;
                        while (n < iResourceArray.length) {
                            this.handleHeaderDependency(iResourceArray[n], bl2);
                            ++n;
                        }
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
            if (iResource.getType() == 4) {
                iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                if (iResourceDeltaArray != null && iResourceDeltaArray.length > 0) {
                    bl = true;
                }
            } else if (!this.generator.isGeneratedResource(iResource)) {
                bl = true;
            }
            return bl;
        }
    }
}

