/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    private boolean isDirty;
    private IResource owner;
    private Map targetMap = new HashMap();
    private List targets = new ArrayList();
    private Map defaultConfigurations = new HashMap();
    private ITarget defaultTarget;

    public ManagedBuildInfo(IResource iResource) {
        this.owner = iResource;
    }

    public ManagedBuildInfo(IResource iResource, Element element) {
        this(iResource);
        Node node = element.getFirstChild();
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (node != null) {
            if (node.getNodeName().equals("target")) {
                new Target(this, (Element)node);
            } else if (node.getNodeName().equals("defaultConfig")) {
                arrayList.add(((Element)node).getAttribute("id"));
            } else if (node.getNodeName().equals("defaultTarget")) {
                string = ((Element)node).getAttribute("id");
            }
            node = node.getNextSibling();
        }
        this.defaultTarget = (ITarget)this.targetMap.get(string);
        ListIterator listIterator = arrayList.listIterator();
        block1: while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            ListIterator listIterator2 = this.targets.listIterator();
            while (listIterator2.hasNext()) {
                Target target = (Target)listIterator2.next();
                IConfiguration iConfiguration = target.getConfiguration(string2);
                if (iConfiguration == null) continue;
                this.defaultConfigurations.put(target.getId(), iConfiguration);
                continue block1;
            }
        }
    }

    public void addTarget(ITarget iTarget) {
        this.targetMap.put(iTarget.getId(), iTarget);
        this.targets.add(iTarget);
    }

    public boolean buildsFileType(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            try {
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return iTool.buildsFileType(string);
                        }
                        break;
                    }
                    case 1: {
                        if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return iTool.buildsFileType(string);
                    }
                    case 2: {
                        return iTool.buildsFileType(string);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return false;
    }

    public String getBuildArtifactExtension() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getArtifactExtension();
        }
        return string;
    }

    public String getBuildArtifactName() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getArtifactName();
        }
        return string;
    }

    public String getCleanCommand() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getCleanCommand();
        }
        return string;
    }

    public String getConfigurationName() {
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        return iConfiguration == null ? new String() : iConfiguration.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfiguration[] iConfigurationArray = this.getDefaultTarget().getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            arrayList.add(iConfiguration.getName());
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public IConfiguration getDefaultConfiguration(ITarget iTarget) {
        IConfiguration[] iConfigurationArray;
        IConfiguration iConfiguration = (IConfiguration)this.defaultConfigurations.get(iTarget.getId());
        if (iConfiguration == null && (iConfigurationArray = this.getDefaultTarget().getConfigurations()).length > 0) {
            iConfiguration = iConfigurationArray[0];
        }
        return iConfiguration;
    }

    public ITarget getDefaultTarget() {
        if (this.defaultTarget == null) {
            this.defaultTarget = (ITarget)this.targets.get(0);
        }
        return this.defaultTarget;
    }

    public Map getDefinedSymbols() {
        IProject iProject = (IProject)this.owner;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block15: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block15;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block15;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block15;
                }
                IOption[] iOptionArray = iTool.getOptions();
                int n2 = 0;
                while (n2 < iOptionArray.length) {
                    IOption iOption = iOptionArray[n2];
                    if (iOption.getValueType() == 5) {
                        try {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.addAll(Arrays.asList(iOption.getBuiltIns()));
                            arrayList.addAll(Arrays.asList(iOption.getDefinedSymbols()));
                            ListIterator listIterator = ((AbstractList)arrayList).listIterator();
                            while (listIterator.hasNext()) {
                                String string = (String)listIterator.next();
                                if (string.length() == 0) continue;
                                String string2 = new String();
                                String string3 = new String();
                                int n3 = string.indexOf("=");
                                if (n3 != -1) {
                                    string2 = string.substring(0, n3).trim();
                                    string3 = string.substring(n3 + 1).trim();
                                } else {
                                    string2 = string.trim();
                                }
                                hashMap.put(string2, string3);
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashMap;
    }

    public String getFlagsForSource(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.buildsFileType(string)) {
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return iTool.getToolFlags();
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return iTool.getToolFlags();
                        }
                        case 2: {
                            return iTool.getToolFlags();
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (BuildException buildException) {}
            }
            ++n;
        }
        return null;
    }

    public String getFlagsForTarget(String string) {
        IProject iProject = (IProject)this.owner;
        String string2 = string == null ? new String() : string;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return iTool.getToolFlags();
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return iTool.getToolFlags();
                        }
                        case 2: {
                            return iTool.getToolFlags();
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (BuildException buildException) {}
            }
            ++n;
        }
        return null;
    }

    public String[] getIncludePaths() {
        IProject iProject = (IProject)this.owner;
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        IPath iPath = this.owner.getLocation();
        if (iPath == null) {
            iPath = new Path(".");
        }
        IPath iPath2 = iPath.addTrailingSeparator().append(iConfiguration.getName());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block16: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block16;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block16;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block16;
                }
                IOption[] iOptionArray = iTool.getOptions();
                int n2 = 0;
                while (n2 < iOptionArray.length) {
                    IOption iOption = iOptionArray[n2];
                    if (iOption.getValueType() == 4) {
                        try {
                            arrayList.addAll(Arrays.asList(iOption.getBuiltIns()));
                            String[] stringArray = iOption.getIncludePaths();
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                Path path = new Path(stringArray[n3]);
                                if (path.isAbsolute()) {
                                    arrayList.add(path.toOSString());
                                } else {
                                    IPath iPath3 = iPath2.addTrailingSeparator().append((IPath)path);
                                    arrayList.add(iPath3.makeAbsolute().toOSString());
                                }
                                ++n3;
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++n2;
                }
            }
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLibsForTarget(String string) {
        IProject iProject = (IProject)this.owner;
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block14: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block14;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block14;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block14;
                }
                if (iTool.producesFileType(string)) {
                    IOption[] iOptionArray = iTool.getOptions();
                    int n2 = 0;
                    while (n2 < iOptionArray.length) {
                        IOption iOption = iOptionArray[n2];
                        if (iOption.getValueType() == 6) {
                            try {
                                String string2 = iOption.getCommand();
                                String[] stringArray = iOption.getLibraries();
                                int n3 = 0;
                                while (n3 < stringArray.length) {
                                    String string3 = stringArray[n3];
                                    arrayList.add(String.valueOf(string2) + string3);
                                    ++n3;
                                }
                            }
                            catch (BuildException buildException) {}
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getMakeArguments() {
        return this.getDefaultTarget().getMakeArguments();
    }

    public String getMakeCommand() {
        return this.getDefaultTarget().getMakeCommand();
    }

    public String getOutputExtension(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            try {
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return iTool.getOutputExtension(string);
                        }
                        break;
                    }
                    case 1: {
                        if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return iTool.getOutputExtension(string);
                    }
                    case 2: {
                        return iTool.getOutputExtension(string);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return null;
    }

    public String getOutputFlag(String string) {
        IProject iProject = (IProject)this.owner;
        String string2 = string == null ? new String() : string;
        String string3 = new String();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block9: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block9;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block9;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block9;
                }
                if (iTool.producesFileType(string2)) {
                    string3 = iTool.getOutputFlag();
                }
            }
            ++n;
        }
        return string3;
    }

    public String getOutputPrefix(String string) {
        IProject iProject = (IProject)this.owner;
        String string2 = string == null ? new String() : string;
        String string3 = new String();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block9: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block9;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block9;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block9;
                }
                if (iTool.producesFileType(string2)) {
                    string3 = iTool.getOutputPrefix();
                }
            }
            ++n;
        }
        return string3;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getTarget(String string) {
        return (ITarget)this.targetMap.get(string);
    }

    public List getTargets() {
        return this.targets;
    }

    public String getToolForSource(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.buildsFileType(string)) {
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return iTool.getToolCommand();
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return iTool.getToolCommand();
                        }
                        case 2: {
                            return iTool.getToolCommand();
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
        return null;
    }

    public String getToolForTarget(String string) {
        IProject iProject = (IProject)this.owner;
        String string2 = string == null ? new String() : string;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return iTool.getToolCommand();
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return iTool.getToolCommand();
                        }
                        case 2: {
                            return iTool.getToolCommand();
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
        return null;
    }

    public String[] getUserObjectsForTarget(String string) {
        IProject iProject = (IProject)this.owner;
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            block13: {
                ITool iTool = iToolArray[n];
                try {
                    switch (iTool.getNatureFilter()) {
                        case 0: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block13;
                            }
                            break;
                        }
                        case 1: {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break block13;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block13;
                }
                if (iTool.producesFileType(string)) {
                    IOption[] iOptionArray = iTool.getOptions();
                    int n2 = 0;
                    while (n2 < iOptionArray.length) {
                        IOption iOption = iOptionArray[n2];
                        if (iOption.getValueType() == 7) {
                            try {
                                arrayList.addAll(Arrays.asList(iOption.getUserObjects()));
                            }
                            catch (BuildException buildException) {}
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isHeaderFile(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            try {
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return iTool.isHeaderFile(string);
                        }
                        break;
                    }
                    case 1: {
                        if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return iTool.isHeaderFile(string);
                    }
                    case 2: {
                        return iTool.isHeaderFile(string);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return false;
    }

    public void serialize(Document document, Element element) {
        int n = 0;
        while (n < this.targets.size()) {
            Element element2 = document.createElement("target");
            element.appendChild(element2);
            ((Target)this.targets.get(n)).serialize(document, element2);
            IConfiguration iConfiguration = this.getDefaultConfiguration((ITarget)this.targets.get(n));
            if (iConfiguration != null) {
                Element element3 = document.createElement("defaultConfig");
                element.appendChild(element3);
                element3.setAttribute("id", iConfiguration.getId());
            }
            ++n;
        }
        if (this.getDefaultTarget() != null) {
            Element element4 = document.createElement("defaultTarget");
            element.appendChild(element4);
            element4.setAttribute("id", this.getDefaultTarget().getId());
        }
    }

    public void setDefaultConfiguration(IConfiguration iConfiguration) {
        ITarget iTarget = iConfiguration.getTarget();
        this.setDefaultTarget(iTarget);
        this.defaultConfigurations.put(iTarget.getId(), iConfiguration);
    }

    public void setDefaultTarget(ITarget iTarget) {
        if (this.defaultTarget != null && this.defaultTarget.getId().equals(iTarget.getId())) {
            return;
        }
        this.defaultTarget = iTarget;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void updateOwner(IResource iResource) {
        if (iResource != null && !this.owner.equals((Object)iResource)) {
            this.owner = iResource;
            ListIterator listIterator = this.targets.listIterator();
            while (listIterator.hasNext()) {
                ITarget iTarget = (ITarget)listIterator.next();
                iTarget.updateOwner(iResource);
            }
        }
    }
}

