/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private String artifactName;
    private String binaryParserId;
    private String cleanCommand;
    private Map configMap;
    private List configurations;
    private String defaultExtension;
    private String extension;
    private boolean isAbstract = false;
    private boolean isTest = false;
    private String makeArguments;
    private String makeCommand;
    private IResource owner;
    private ITarget parent;
    private List targetOSList;
    private Map toolMap;
    private List toolList;
    private List toolReferences;
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];
    private static final String EMPTY_STRING = new String();

    protected Target(IResource iResource) {
        this.owner = iResource;
    }

    public Target(IResource iResource, ITarget iTarget) {
        this(iResource);
        this.parent = iTarget;
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int n = random.nextInt();
        if (n < 0) {
            n *= -1;
        }
        this.setId(String.valueOf(iResource.getName()) + "." + iTarget.getId() + "." + n);
        this.setName(iTarget.getName());
        this.artifactName = iTarget.getArtifactName();
        this.binaryParserId = iTarget.getBinaryParserId();
        this.defaultExtension = iTarget.getArtifactExtension();
        this.isTest = iTarget.isTestTarget();
        this.cleanCommand = iTarget.getCleanCommand();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource, true);
        iManagedBuildInfo.addTarget(this);
    }

    public Target(IConfigurationElement iConfigurationElement) {
        Object object;
        this.setId(iConfigurationElement.getAttribute("id"));
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(iConfigurationElement.getAttribute("name"));
        this.artifactName = iConfigurationElement.getAttribute("artifactName");
        this.binaryParserId = iConfigurationElement.getAttribute("binaryParser");
        this.defaultExtension = iConfigurationElement.getAttribute("defaultExtension");
        String string = iConfigurationElement.getAttribute("parent");
        if (string != null) {
            this.parent = ManagedBuildManager.getTarget(null, string);
            object = this.parent.getConfigurations();
            int n = 0;
            while (n < ((IConfiguration[])object).length) {
                this.addConfiguration(object[n]);
                ++n;
            }
        }
        this.isAbstract = "true".equals(iConfigurationElement.getAttribute("isAbstract"));
        this.isTest = "true".equals(iConfigurationElement.getAttribute("isTest"));
        this.cleanCommand = iConfigurationElement.getAttribute("cleanCommand");
        this.makeCommand = iConfigurationElement.getAttribute("makeCommand");
        object = iConfigurationElement.getAttribute("osList");
        if (object != null) {
            this.targetOSList = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.targetOSList.add(stringTokenizer.nextToken().trim());
            }
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("toolReference");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            new ToolReference((BuildObject)this, iConfigurationElementArray[n]);
            ++n;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("tool");
        int n2 = 0;
        while (n2 < iConfigurationElementArray2.length) {
            new Tool(this, iConfigurationElementArray2[n2]);
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("configuration");
        int n3 = 0;
        while (n3 < iConfigurationElementArray3.length) {
            new Configuration(this, iConfigurationElementArray3[n3]);
            ++n3;
        }
    }

    public Target(ManagedBuildInfo managedBuildInfo, Element element) {
        this(managedBuildInfo.getOwner());
        String string;
        this.setId(element.getAttribute("id"));
        managedBuildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        if (element.hasAttribute("extension")) {
            this.extension = element.getAttribute("extension");
        }
        if ((string = element.getAttribute("parent")) != null) {
            this.parent = ManagedBuildManager.getTarget(null, string);
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        this.isTest = "true".equals(element.getAttribute("isTest"));
        this.cleanCommand = element.getAttribute("cleanCommand");
        if (element.hasAttribute("makeCommand")) {
            this.makeCommand = element.getAttribute("makeCommand");
        }
        if (element.hasAttribute("makeArguments")) {
            this.makeArguments = element.getAttribute("makeArguments");
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("configuration")) {
                new Configuration(this, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    public void removeConfiguration(String string) {
        ListIterator listIterator = this.configurations.listIterator();
        while (listIterator.hasNext()) {
            IConfiguration iConfiguration = (IConfiguration)listIterator.next();
            if (!iConfiguration.getId().equals(string)) continue;
            this.configurations.remove(iConfiguration);
            this.configMap.remove(string);
            break;
        }
    }

    public void resetMakeCommand() {
        this.makeCommand = null;
        this.makeArguments = null;
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        element.setAttribute("artifactName", this.getArtifactName());
        if (this.extension != null) {
            element.setAttribute("extension", this.extension);
        }
        element.setAttribute("isTest", this.isTest ? "true" : "false");
        element.setAttribute("cleanCommand", this.getCleanCommand());
        if (this.makeCommand != null) {
            element.setAttribute("makeCommand", this.makeCommand);
        }
        if (this.makeArguments != null) {
            element.setAttribute("makeArguments", this.makeArguments);
        }
        if (this.configurations != null) {
            int n = 0;
            while (n < this.configurations.size()) {
                Configuration configuration = (Configuration)this.configurations.get(n);
                Element element2 = document.createElement("configuration");
                element.appendChild(element2);
                configuration.serialize(document, element2);
                ++n;
            }
        }
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
            this.toolReferences.clear();
        }
        return this.toolReferences;
    }

    public String getMakeArguments() {
        if (this.makeArguments == null) {
            if (this.parent != null) {
                return this.parent.getMakeArguments();
            }
            return new String("");
        }
        return this.makeArguments;
    }

    public String getMakeCommand() {
        if (this.makeCommand == null) {
            if (this.parent != null) {
                return this.parent.getMakeCommand();
            }
            return new String("make");
        }
        return this.makeCommand;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITarget getParent() {
        return this.parent;
    }

    public String[] getTargetOSList() {
        if (this.targetOSList == null) {
            if (this.parent != null) {
                return this.parent.getTargetOSList();
            }
            return new String[0];
        }
        return this.targetOSList.toArray(new String[this.targetOSList.size()]);
    }

    public IResource getOwner() {
        return this.owner;
    }

    private int getToolCount() {
        int n = this.getToolList().size();
        n += this.getLocalToolReferences().size();
        if (this.parent != null) {
            n += ((Target)this.parent).getToolCount();
        }
        return n;
    }

    private int addToolsToArray(ITool[] iToolArray, int n) {
        int n2 = n;
        if (this.parent != null) {
            n2 = ((Target)this.parent).addToolsToArray(iToolArray, n);
        }
        int n3 = 0;
        while (n3 < this.getToolList().size()) {
            iToolArray[n2++] = (ITool)this.getToolList().get(n3);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.getLocalToolReferences().size()) {
            iToolArray[n2++] = (ITool)this.getLocalToolReferences().get(n3);
            ++n3;
        }
        return n2;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
            this.toolList.clear();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
            this.toolMap.clear();
        }
        return this.toolMap;
    }

    private ToolReference getToolReference(ITool iTool) {
        ToolReference toolReference = null;
        if (iTool == null) {
            return toolReference;
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference2 = (ToolReference)listIterator.next();
            if (!toolReference2.references(iTool)) continue;
            toolReference = toolReference2;
            break;
        }
        return toolReference;
    }

    public ITool[] getTools() {
        ITool[] iToolArray = new ITool[this.getToolCount()];
        this.addToolsToArray(iToolArray, 0);
        return iToolArray;
    }

    public boolean hasOverridenMakeCommand() {
        return this.makeCommand != null && !this.makeCommand.equals(this.parent.getMakeCommand()) || this.makeArguments != null && !this.makeArguments.equals(this.parent.getMakeArguments());
    }

    public ITool getTool(String string) {
        ITool iTool = null;
        iTool = (ITool)this.getToolMap().get(string);
        if (iTool == null && this.parent != null) {
            iTool = ((Target)this.parent).getTool(string);
        }
        if (iTool == null) {
            iTool = ManagedBuildManager.getTool(string);
        }
        return iTool;
    }

    public void addTool(ITool iTool) {
        this.getToolList().add(iTool);
        this.getToolMap().put(iTool.getId(), iTool);
    }

    public IConfiguration[] getConfigurations() {
        if (this.configurations != null) {
            return this.configurations.toArray(new IConfiguration[this.configurations.size()]);
        }
        return emptyConfigs;
    }

    public String getDefaultExtension() {
        return this.defaultExtension == null ? EMPTY_STRING : this.defaultExtension;
    }

    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (BootLoader.getOS().equals("OS_WIN32")) {
                return new String("del");
            }
            return new String("rm");
        }
        return this.cleanCommand;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getArtifactExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.defaultExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return EMPTY_STRING;
        }
        return this.defaultExtension;
    }

    public String getBinaryParserId() {
        if (this.binaryParserId == null) {
            if (this.parent != null) {
                return this.parent.getBinaryParserId();
            }
            return EMPTY_STRING;
        }
        return this.binaryParserId;
    }

    public IConfiguration getConfiguration(String string) {
        return (IConfiguration)this.configMap.get(string);
    }

    public void addConfiguration(IConfiguration iConfiguration) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
            this.configMap = new HashMap();
        }
        this.configurations.add(iConfiguration);
        this.configMap.put(iConfiguration.getId(), iConfiguration);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isTestTarget() {
        return this.isTest;
    }

    public IConfiguration createConfiguration(String string) {
        return new Configuration(this, string);
    }

    public IConfiguration createConfiguration(IConfiguration iConfiguration, String string) {
        return new Configuration(this, iConfiguration, string);
    }

    public void addToolReference(ToolReference toolReference) {
        this.getLocalToolReferences().add(toolReference);
    }

    public void setArtifactExtension(String string) {
        if (string != null) {
            this.extension = string;
        }
    }

    public void setArtifactName(String string) {
        if (string != null) {
            this.artifactName = string;
        }
    }

    public void setMakeArguments(String string) {
        if (string != null && !this.getMakeArguments().equals(string)) {
            this.makeArguments = string;
        }
    }

    public void setMakeCommand(String string) {
        if (string != null && !this.getMakeCommand().equals(string)) {
            this.makeCommand = string;
        }
    }

    public void updateOwner(IResource iResource) {
        if (!iResource.equals((Object)this.owner)) {
            this.owner = iResource;
        }
    }
}

