/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    private static final IOption[] EMPTY_OPTIONS = new IOption[0];
    private Map categoryMap;
    private List childOptionCategories;
    private String command;
    private List inputExtensions;
    private List interfaceExtensions;
    private int natureFilter;
    private Map optionMap;
    private List options;
    private String outputExtension;
    private String outputFlag;
    private String outputPrefix;

    public Tool(IConfigurationElement iConfigurationElement) {
        this.loadFromManifest(iConfigurationElement);
        ManagedBuildManager.addExtensionTool(this);
    }

    public Tool(Target target, IConfigurationElement iConfigurationElement) {
        this.loadFromManifest(iConfigurationElement);
        target.addTool(this);
    }

    public IOptionCategory getOptionCategory(String string) {
        return (IOptionCategory)this.categoryMap.get(string);
    }

    void addOptionCategory(IOptionCategory iOptionCategory) {
        this.categoryMap.put(iOptionCategory.getId(), iOptionCategory);
    }

    public boolean buildsFileType(String string) {
        if (string == null) {
            return false;
        }
        return this.getInputExtensions().contains(string);
    }

    void addChildCategory(IOptionCategory iOptionCategory) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(iOptionCategory);
    }

    public IOption[] getOptions() {
        if (this.options != null) {
            return this.options.toArray(new IOption[this.options.size()]);
        }
        return EMPTY_OPTIONS;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new ArrayList();
            this.optionMap = new HashMap();
        }
        this.options.add(option);
        this.optionMap.put(option.getId(), option);
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        return EMPTY_CATEGORIES;
    }

    private List getInputExtensions() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    private List getInterfaceExtensions() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public IOptionCategory createChildCategory() {
        OptionCategory optionCategory = new OptionCategory(this);
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(optionCategory);
        return optionCategory;
    }

    public String getOutputFlag() {
        return this.outputFlag == null ? new String() : this.outputFlag.trim();
    }

    public String getOutputPrefix() {
        return this.outputPrefix == null ? new String() : this.outputPrefix.trim();
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public ITool getTool() {
        return this;
    }

    public String getToolCommand() {
        return this.command.trim();
    }

    public String getToolFlags() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        IOption[] iOptionArray = this.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 0: {
                    if (!iOption.getBooleanValue()) break;
                    stringBuffer.append(String.valueOf(iOption.getCommand()) + " ");
                    break;
                }
                case 1: {
                    String string = iOption.getEnumCommand(iOption.getSelectedEnum());
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String string = iOption.getStringValue();
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 3: {
                    Object object2;
                    String string = iOption.getCommand();
                    String[] stringArray = iOption.getStringListValue();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object2 = stringArray[n2];
                        stringBuffer.append(String.valueOf(string) + (String)object2 + " ");
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    Object object;
                    String string = iOption.getCommand();
                    Object object2 = iOption.getIncludePaths();
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        object = object2[n3];
                        stringBuffer.append(String.valueOf(string) + (String)object + " ");
                        ++n3;
                    }
                    break;
                }
                case 5: {
                    String string = iOption.getCommand();
                    Object object = iOption.getDefinedSymbols();
                    int n4 = 0;
                    while (n4 < ((String[])object).length) {
                        String string2 = object[n4];
                        stringBuffer.append(String.valueOf(string) + string2 + " ");
                        ++n4;
                    }
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public IOption[] getOptions(IConfiguration iConfiguration) {
        IBuildObject[] iBuildObjectArray;
        IBuildObject iBuildObject = this;
        if (iConfiguration != null) {
            iBuildObjectArray = iConfiguration.getTools();
            int n = 0;
            while (n < iBuildObjectArray.length) {
                if (iBuildObjectArray[n] instanceof ToolReference) {
                    if (((ToolReference)iBuildObjectArray[n]).references((ITool)iBuildObject)) {
                        iBuildObject = iBuildObjectArray[n];
                        break;
                    }
                } else if (iBuildObjectArray[n].equals(iBuildObject)) break;
                ++n;
            }
        }
        iBuildObjectArray = iBuildObject.getOptions();
        ArrayList<IBuildObject> arrayList = new ArrayList<IBuildObject>();
        int n = 0;
        while (n < iBuildObjectArray.length) {
            IBuildObject iBuildObject2 = iBuildObjectArray[n];
            if (iBuildObject2.getCategory().equals(this)) {
                arrayList.add(iBuildObject2);
            }
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new IOption[arrayList.size()]);
    }

    public int getNatureFilter() {
        return this.natureFilter;
    }

    public IOption getOption(String string) {
        return (IOption)this.optionMap.get(string);
    }

    public String getOutputExtension(String string) {
        ListIterator listIterator = this.getInputExtensions().listIterator();
        while (listIterator.hasNext()) {
            if (!((String)listIterator.next()).equals(string)) continue;
            return this.outputExtension;
        }
        return null;
    }

    public boolean isHeaderFile(String string) {
        if (string == null) {
            return false;
        }
        return this.getInterfaceExtensions().contains(string);
    }

    protected void loadFromManifest(IConfigurationElement iConfigurationElement) {
        this.setId(iConfigurationElement.getAttribute("id"));
        this.setName(iConfigurationElement.getAttribute("name"));
        String string = iConfigurationElement.getAttribute("natureFilter");
        this.natureFilter = string == null || "both".equals(string) ? 2 : ("cnature".equals(string) ? 0 : ("ccnature".equals(string) ? 1 : 2));
        String string2 = iConfigurationElement.getAttribute("sources") == null ? new String() : iConfigurationElement.getAttribute("sources");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DEFAULT_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            this.getInputExtensions().add(stringTokenizer.nextElement());
        }
        String string3 = iConfigurationElement.getAttribute("headerExtensions");
        if (string3 == null) {
            string3 = new String();
        }
        stringTokenizer = new StringTokenizer(string3, DEFAULT_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            this.getInterfaceExtensions().add(stringTokenizer.nextElement());
        }
        this.outputExtension = iConfigurationElement.getAttribute("outputs") == null ? new String() : iConfigurationElement.getAttribute("outputs");
        this.command = iConfigurationElement.getAttribute("command") == null ? new String() : iConfigurationElement.getAttribute("command");
        this.outputFlag = iConfigurationElement.getAttribute("outputFlag") == null ? new String() : iConfigurationElement.getAttribute("outputFlag");
        this.outputPrefix = iConfigurationElement.getAttribute("outputPrefix") == null ? new String() : iConfigurationElement.getAttribute("outputPrefix");
        this.categoryMap = new HashMap();
        this.addOptionCategory(this);
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if (iConfigurationElement2.getName().equals("option")) {
                new Option(this, iConfigurationElement2);
            } else if (iConfigurationElement2.getName().equals("optionCategory")) {
                new OptionCategory(this, iConfigurationElement2);
            }
            ++n;
        }
    }

    public boolean producesFileType(String string) {
        return this.outputExtension.equals(string);
    }
}

