/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class LocationTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    ICProject testProject;
    NullProgressMonitor monitor = new NullProgressMonitor();
    ICDISession session;
    static /* synthetic */ Class class$0;

    public LocationTests(String string) {
        super(string);
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
    }

    protected void setUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        String string = Platform.getPlugin((String)"org.eclipse.cdt.debug.ui.tests").find((IPath)new Path("/")).getFile();
        string = String.valueOf(string) + "resources/debugTest.zip";
        this.testProject = CProjectHelper.createCProjectWithImport("filetest", string);
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.testProject.getProject().build(6, null);
    }

    protected void tearDown() throws CoreException, CDIException {
        if (this.session != null) {
            this.session.terminate();
            this.session = null;
        }
        CProjectHelper.delete(this.testProject);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.tests.LocationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LocationTests.suite());
    }

    public void testIsEquals() throws CoreException, MIException, IOException, CDIException {
        this.session = CDebugHelper.createSession("main", this.testProject);
        Assert.assertNotNull((Object)this.session);
        ICDIBreakpointManager iCDIBreakpointManager = this.session.getBreakpointManager();
        Assert.assertNotNull((Object)iCDIBreakpointManager);
        ICDILocation iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        ICDILocation iCDILocation2 = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertTrue((boolean)iCDILocation.equals(iCDILocation2));
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", null, 10);
        iCDILocation2 = iCDIBreakpointManager.createLocation("main.c", null, 10);
        Assert.assertTrue((boolean)iCDILocation.equals(iCDILocation2));
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDILocation2 = iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null).getLocation();
        ICDIBreakpoint[] iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        Object object = iCDIBreakpointArray[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[0] : null;
        Assert.assertNotNull(object);
        Assert.assertTrue((boolean)object.getLocation().equals(iCDILocation2));
        iCDIBreakpointManager.deleteAllBreakpoints();
        iCDILocation = iCDIBreakpointManager.createLocation("main.c", "func1", 0);
        Assert.assertNotNull((Object)iCDILocation);
        iCDIBreakpointManager.setLocationBreakpoint(0, iCDILocation, null, null);
        iCDIBreakpointArray = iCDIBreakpointManager.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        object = iCDIBreakpointArray[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[0] : null;
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((String)"PR:23879", (boolean)object.getLocation().equals(iCDILocation));
        this.session.terminate();
        this.session = null;
    }
}

