/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.managed.tests;

import java.util.Arrays;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class StandardBuildTests
extends TestCase {
    private static final String DEFAULT_BUILD_COMMAND = "make";
    private static final String EMPTY_STRING = "";
    private static final boolean OFF = false;
    private static final boolean ON = true;
    private static final String OVR_BUILD_ARGS = "-f";
    private static final String OVR_BUILD_COMMAND = "/home/tester/bin/nmake";
    private static final String OVR_BUILD_LOCATION = "src";
    private static final String[] OVR_INC_PATHS = new String[]{"/test", "C:\\windows", "//dev/home/include"};
    private static final String[] OVR_PREPROC_SYMS = new String[]{"_RELEASE", "NO ", " YES=1"};
    private static final String PROJECT_NAME = "StandardBuildTest";
    static /* synthetic */ Class class$0;

    public StandardBuildTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.build.managed.tests.StandardBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new StandardBuildTests("testProjectCreation"));
        testSuite.addTest((Test)new StandardBuildTests("testProjectSettings"));
        testSuite.addTest((Test)new StandardBuildTests("testProjectConversion"));
        testSuite.addTest((Test)new StandardBuildTests("testScannerListenerInterface"));
        testSuite.addTest((Test)new StandardBuildTests("testProjectCleanup"));
        return testSuite;
    }

    private void checkDefaultProjectSettings(IProject iProject) throws Exception {
        Assert.assertNotNull((Object)iProject);
        MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(iProject, true);
        Assert.assertNotNull((Object)makeScannerInfo);
        String[] stringArray = makeScannerInfo.getIncludePaths();
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)0, (int)stringArray.length);
        String[] stringArray2 = makeScannerInfo.getPreprocessorSymbols();
        Assert.assertNotNull((Object)stringArray2);
        Assert.assertEquals((int)0, (int)stringArray2.length);
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)iProject, (String)MakeBuilder.BUILDER_ID);
        Assert.assertEquals((boolean)true, (boolean)iMakeBuilderInfo.isDefaultBuildCmd());
        Assert.assertEquals((boolean)false, (boolean)iMakeBuilderInfo.isStopOnError());
        Assert.assertEquals((Object)new Path(DEFAULT_BUILD_COMMAND), (Object)iMakeBuilderInfo.getBuildCommand());
        Assert.assertEquals((String)EMPTY_STRING, (String)iMakeBuilderInfo.getBuildArguments());
        Assert.assertEquals((boolean)false, (boolean)iMakeBuilderInfo.isAutoBuildEnable());
        Assert.assertEquals((String)"all", (String)iMakeBuilderInfo.getAutoBuildTarget());
        Assert.assertEquals((boolean)true, (boolean)iMakeBuilderInfo.isIncrementalBuildEnabled());
        Assert.assertEquals((String)"all", (String)iMakeBuilderInfo.getIncrementalBuildTarget());
        Assert.assertEquals((boolean)true, (boolean)iMakeBuilderInfo.isFullBuildEnabled());
        Assert.assertEquals((String)"clean all", (String)iMakeBuilderInfo.getFullBuildTarget());
    }

    private void checkOverriddenProjectSettings(IProject iProject) throws Exception {
        Assert.assertNotNull((Object)iProject);
        MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(iProject, true);
        Assert.assertNotNull((Object)makeScannerInfo);
        Object[] objectArray = makeScannerInfo.getIncludePaths();
        Assert.assertNotNull((Object)objectArray);
        Assert.assertEquals((int)3, (int)objectArray.length);
        Assert.assertTrue((boolean)Arrays.equals(objectArray, OVR_INC_PATHS));
        Object[] objectArray2 = makeScannerInfo.getPreprocessorSymbols();
        Assert.assertNotNull((Object)objectArray2);
        Assert.assertEquals((int)3, (int)objectArray2.length);
        Assert.assertTrue((boolean)Arrays.equals(objectArray2, OVR_PREPROC_SYMS));
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)iProject, (String)MakeBuilder.BUILDER_ID);
        Assert.assertEquals((boolean)false, (boolean)iMakeBuilderInfo.isDefaultBuildCmd());
        Assert.assertEquals((boolean)true, (boolean)iMakeBuilderInfo.isStopOnError());
        Assert.assertEquals((Object)new Path(OVR_BUILD_COMMAND), (Object)iMakeBuilderInfo.getBuildCommand());
        Assert.assertEquals((String)OVR_BUILD_ARGS, (String)iMakeBuilderInfo.getBuildArguments());
        Assert.assertEquals((Object)new Path(OVR_BUILD_LOCATION), (Object)iMakeBuilderInfo.getBuildLocation());
    }

    private IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) {
            iProject.create(null);
        } else {
            iProject.refreshLocal(2, null);
        }
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        return iProject;
    }

    private void removeProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            try {
                iProject.delete(true, false, null);
            }
            catch (CoreException coreException) {
                Assert.assertTrue((boolean)false);
            }
        }
    }

    public void testProjectCleanup() {
        this.removeProject(PROJECT_NAME);
    }

    public void testProjectConversion() throws Exception {
        IProject iProject = null;
        try {
            iProject = this.createProject(PROJECT_NAME);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectConversion failed opening project: " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        this.checkOverriddenProjectSettings(iProject);
        try {
            CCorePlugin.getDefault().convertProjectFromCtoCC(iProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectConversion failed to convert project: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.close((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectConversion failed to close project " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectConversion failed to open project " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectConversion failed getting nature: " + coreException.getLocalizedMessage()));
        }
        this.checkOverriddenProjectSettings(iProject);
    }

    public void testProjectCreation() throws Exception {
        IProject iProject = null;
        try {
            iProject = this.createProject(PROJECT_NAME);
            CCorePlugin.getDefault().convertProjectToCC(iProject, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
            MakeProjectNature.addNature((IProject)iProject, null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectCreation failed creating project: " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        try {
            iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectCreation failed getting nature: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.hasNature(MakeProjectNature.NATURE_ID);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectCreation failed getting nature: " + coreException.getLocalizedMessage()));
        }
        this.checkDefaultProjectSettings(iProject);
    }

    public void testProjectSettings() throws Exception {
        IProject iProject = null;
        try {
            iProject = this.createProject(PROJECT_NAME);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectSettings failed opening project: " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(iProject, false);
        makeScannerInfo.setIncludePaths(OVR_INC_PATHS);
        makeScannerInfo.setPreprocessorSymbols(OVR_PREPROC_SYMS);
        makeScannerInfo.update();
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)iProject, (String)MakeBuilder.BUILDER_ID);
        iMakeBuilderInfo.setStopOnError(true);
        iMakeBuilderInfo.setUseDefaultBuildCmd(false);
        iMakeBuilderInfo.setBuildCommand((IPath)new Path(OVR_BUILD_COMMAND));
        iMakeBuilderInfo.setBuildArguments(OVR_BUILD_ARGS);
        iMakeBuilderInfo.setBuildLocation((IPath)new Path(OVR_BUILD_LOCATION));
        try {
            iProject.close((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectSettings failed to close project " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testProjectSettings failed to open project " + coreException.getLocalizedMessage()));
        }
        this.checkOverriddenProjectSettings(iProject);
    }

    public void testScannerListenerInterface() throws Exception {
        IProject iProject = null;
        try {
            iProject = this.createProject(PROJECT_NAME);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("StandardBuildTest testScannerListernerInterface failed opening project: " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        Assert.assertNotNull((Object)iScannerInfoProvider);
        IScannerInfo iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
        Map map = iScannerInfo.getDefinedSymbols();
        Assert.assertTrue((boolean)map.containsKey("_RELEASE"));
        Assert.assertEquals((Object)EMPTY_STRING, map.get("_RELEASE"));
        Assert.assertTrue((boolean)map.containsKey("YES"));
        Assert.assertEquals((Object)"1", map.get("YES"));
        Assert.assertTrue((boolean)map.containsKey("NO"));
        Assert.assertEquals((Object)EMPTY_STRING, map.get("NO"));
        Object[] objectArray = iScannerInfo.getIncludePaths();
        Assert.assertTrue((boolean)Arrays.equals(OVR_INC_PATHS, objectArray));
        MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(iProject, false);
        makeScannerInfo.setIncludePaths(new String[0]);
        makeScannerInfo.setPreprocessorSymbols(new String[0]);
        makeScannerInfo.update();
        ScannerListener scannerListener = new ScannerListener();
        iScannerInfoProvider.subscribe((IResource)iProject, (IScannerInfoChangeListener)scannerListener);
        makeScannerInfo.setIncludePaths(scannerListener.getExpectedPaths());
        makeScannerInfo.setPreprocessorSymbols(scannerListener.getExpectedSymbols());
        makeScannerInfo.update();
        Assert.assertEquals((boolean)true, (boolean)scannerListener.triggedNotification());
        iScannerInfoProvider.unsubscribe((IResource)iProject, (IScannerInfoChangeListener)scannerListener);
    }

    private class ScannerListener
    implements IScannerInfoChangeListener {
        private final String[] expectedPaths = new String[]{"/usr/include", "/home/tester/include", "/opt/gnome/include"};
        private final String[] expectedSymbols = new String[]{"_DEBUG", "TRUE=1", "FALSE ", ""};
        private boolean bNotified = false;

        ScannerListener() {
        }

        public void changeNotification(IResource iResource, IScannerInfo iScannerInfo) {
            Object[] objectArray;
            Map map = iScannerInfo.getDefinedSymbols();
            if (!map.isEmpty()) {
                Assert.assertTrue((boolean)map.containsKey(this.expectedSymbols[0]));
                Assert.assertEquals((String)StandardBuildTests.EMPTY_STRING, (String)((String)map.get(this.expectedSymbols[0])));
                Assert.assertTrue((boolean)map.containsKey("TRUE"));
                Assert.assertEquals((String)"1", (String)((String)map.get("TRUE")));
                Assert.assertFalse((boolean)map.containsKey(this.expectedSymbols[2]));
                Assert.assertTrue((boolean)map.containsKey(this.expectedSymbols[2].trim()));
                Assert.assertEquals((String)StandardBuildTests.EMPTY_STRING, (String)((String)map.get(this.expectedSymbols[2].trim())));
                Assert.assertFalse((boolean)map.containsKey(StandardBuildTests.EMPTY_STRING));
            }
            if ((objectArray = iScannerInfo.getIncludePaths()).length > 0) {
                Assert.assertTrue((boolean)Arrays.equals(this.expectedPaths, objectArray));
            }
            this.bNotified = true;
        }

        public String[] getExpectedPaths() {
            return this.expectedPaths;
        }

        public boolean triggedNotification() {
            return this.bNotified;
        }

        public String[] getExpectedSymbols() {
            return this.expectedSymbols;
        }
    }
}

