/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.indexer.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.sourcedependency.DependencyQueryJob;
import org.eclipse.cdt.internal.core.sourcedependency.UpdateDependency;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DependencyTests
extends TestCase {
    IFile file;
    IFileDocument fileDoc;
    IProject testProject;
    NullProgressMonitor monitor;
    IndexManager indexManager;
    IWorkspace workspace;
    BasicSearchResultCollector resultCollector;
    SearchEngine searchEngine;
    ICSearchScope scope;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.indexer.tests.DependencyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new DependencyTests("testDependencyTree"));
        testSuite.addTest((Test)new DependencyTests("testDepTable"));
        testSuite.addTest((Test)new DependencyTests("testDepSourceChangeTree"));
        testSuite.addTest((Test)new DependencyTests("testDepHeaderChangeTree"));
        testSuite.addTest((Test)new DependencyTests("testDepHeaderChangeReindex"));
        testSuite.addTest((Test)new DependencyTests("testDepSourceChangeTable"));
        testSuite.addTest((Test)new DependencyTests("testDepHeaderChangeTable"));
        testSuite.addTest((Test)new DependencyTests("testUpdateDependancyNPE"));
        return testSuite;
    }

    public DependencyTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testProject = this.createProject("DepTestProject");
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        this.indexManager.reset();
        this.workspace = ResourcesPlugin.getWorkspace();
        this.scope = SearchEngine.createWorkspaceScope();
        this.monitor = new NullProgressMonitor();
        this.resultCollector = new BasicSearchResultCollector();
        this.searchEngine = new SearchEngine();
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.testProject.exists()) {
            try {
                this.testProject.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                Assert.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    private String getMessage(IStatus iStatus) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append(this.getMessage(iStatusArray[n]));
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void testDependencyTree() throws Exception {
        this.importFile("c.h", "resources/dependency/c.h");
        this.importFile("a.h", "resources/dependency/a.h");
        this.importFile("Inc1.h", "resources/dependency/Inc1.h");
        this.importFile("DepTest.h", "resources/dependency/DepTest.h");
        this.importFile("d.h", "resources/dependency/d.h");
        this.importFile("DepTest2.h", "resources/dependency/DepTest2.h");
        IFile iFile = this.importFile("DepTest.cpp", "resources/dependency/DepTest.cpp");
        IFile iFile2 = this.importFile("DepTest2.cpp", "resources/dependency/DepTest2.cpp");
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        String[] stringArray = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "d.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "Inc1.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "c.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "a.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "DepTest.h"};
        String[] stringArray2 = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "d.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "DepTest2.h"};
        ArrayList arrayList = new ArrayList();
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile, indexManager, arrayList), 3, null, null);
        Object[] objectArray = this.convertToLocalPath(stringArray);
        Object[] objectArray2 = new String[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray2[n] = (String)iterator.next();
            ++n;
        }
        if (objectArray.length != objectArray2.length) {
            Assert.fail((String)"Number of included files differsfrom model");
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        n = 0;
        while (n < objectArray2.length) {
            Assert.assertEquals((String)objectArray[n], (String)objectArray2[n]);
            ++n;
        }
        ArrayList arrayList2 = new ArrayList();
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile2, indexManager, arrayList2), 3, null, null);
        Object[] objectArray3 = this.convertToLocalPath(stringArray2);
        Object[] objectArray4 = new String[arrayList2.size()];
        Iterator iterator2 = ((AbstractList)arrayList2).iterator();
        n = 0;
        while (iterator2.hasNext()) {
            objectArray4[n] = (String)iterator2.next();
            ++n;
        }
        if (objectArray3.length != objectArray4.length) {
            Assert.fail((String)"Number of included files differsfrom model");
        }
        Arrays.sort(objectArray3);
        Arrays.sort(objectArray4);
        n = 0;
        while (n < objectArray4.length) {
            Assert.assertEquals((String)objectArray3[n], (String)objectArray4[n]);
            ++n;
        }
    }

    public void testDepTable() throws Exception {
        this.importFile("c.h", "resources/dependency/c.h");
        this.importFile("a.h", "resources/dependency/a.h");
        IFile iFile = this.importFile("Inc1.h", "resources/dependency/Inc1.h");
        IFile iFile2 = this.importFile("d.h", "resources/dependency/d.h");
        this.importFile("DepTest.h", "resources/dependency/DepTest.h");
        this.importFile("DepTest2.h", "resources/dependency/DepTest2.h");
        this.importFile("DepTest2.cpp", "resources/dependency/DepTest2.cpp");
        this.importFile("DepTest.cpp", "resources/dependency/DepTest.cpp");
        PathCollector pathCollector = new PathCollector();
        this.getTableRefs(iFile2, pathCollector);
        Object[] objectArray = new String[]{"/DepTestProject/DepTest2.cpp", "/DepTestProject/DepTest.cpp"};
        Object[] objectArray2 = pathCollector.getPaths();
        if (objectArray.length != objectArray2.length) {
            Assert.fail((String)"Number of included files differsfrom model");
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        int n = 0;
        while (n < objectArray2.length) {
            Assert.assertEquals((String)objectArray2[n], (String)objectArray[n]);
            ++n;
        }
        pathCollector = new PathCollector();
        this.getTableRefs(iFile, pathCollector);
        Object[] objectArray3 = new String[]{"/DepTestProject/DepTest.cpp"};
        objectArray2 = pathCollector.getPaths();
        if (objectArray3.length != objectArray2.length) {
            Assert.fail((String)"Number of included files differsfrom model");
        }
        Arrays.sort(objectArray3);
        Arrays.sort(objectArray2);
        int n2 = 0;
        while (n2 < objectArray2.length) {
            Assert.assertEquals((String)objectArray2[n2], (String)objectArray3[n2]);
            ++n2;
        }
    }

    public void testDepSourceChangeTable() throws Exception {
        IFile iFile = this.importFile("c.h", "resources/dependency/c.h");
        IFile iFile2 = this.importFile("a.h", "resources/dependency/a.h");
        IFile iFile3 = this.importFile("Inc1.h", "resources/dependency/Inc1.h");
        IFile iFile4 = this.importFile("d.h", "resources/dependency/d.h");
        IFile iFile5 = this.importFile("DepTest.h", "resources/dependency/DepTest.h");
        IFile iFile6 = this.importFile("DepTest.cpp", "resources/dependency/DepTest.cpp");
        String[] stringArray = new String[]{"/DepTestProject/DepTest.cpp"};
        PathCollector pathCollector = new PathCollector();
        this.getTableRefs(iFile5, pathCollector);
        String[] stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile4, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile3, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile2, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        this.editCode(iFile6, "#include \"DepTest.h\"", "//#include \"DepTest.h\"");
        pathCollector = new PathCollector();
        this.getTableRefs(iFile5, pathCollector);
        stringArray2 = pathCollector.getPaths();
        if (stringArray2.length != 0) {
            Assert.fail((String)"Number of included files differs from model");
        }
        pathCollector = new PathCollector();
        this.getTableRefs(iFile4, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile3, pathCollector);
        stringArray2 = pathCollector.getPaths();
        if (stringArray2.length != 0) {
            Assert.fail((String)"Number of included files differs from model");
        }
        pathCollector = new PathCollector();
        this.getTableRefs(iFile2, pathCollector);
        stringArray2 = pathCollector.getPaths();
        if (stringArray2.length != 0) {
            Assert.fail((String)"Number of included files differs from model");
        }
        pathCollector = new PathCollector();
        this.getTableRefs(iFile, pathCollector);
        stringArray2 = pathCollector.getPaths();
        if (stringArray2.length != 0) {
            Assert.fail((String)"Number of included files differs from model");
        }
    }

    public void testDepSourceChangeTree() throws Exception {
        this.importFile("c.h", "resources/dependency/c.h");
        this.importFile("a.h", "resources/dependency/a.h");
        this.importFile("Inc1.h", "resources/dependency/Inc1.h");
        this.importFile("DepTest.h", "resources/dependency/DepTest.h");
        this.importFile("d.h", "resources/dependency/d.h");
        this.importFile("DepTest2.h", "resources/dependency/DepTest2.h");
        IFile iFile = this.importFile("DepTest.cpp", "resources/dependency/DepTest.cpp");
        this.importFile("DepTest2.cpp", "resources/dependency/DepTest2.cpp");
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        String[] stringArray = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "DepTest.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "Inc1.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "a.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "c.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "d.h"};
        ArrayList arrayList = new ArrayList();
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile, indexManager, arrayList), 3, null, null);
        Object[] objectArray = this.convertToLocalPath(stringArray);
        Object[] objectArray2 = new String[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray2[n] = (String)iterator.next();
            ++n;
        }
        if (objectArray.length != objectArray2.length) {
            Assert.fail((String)"Number of included files differs from model");
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        n = 0;
        while (n < objectArray2.length) {
            Assert.assertEquals((String)objectArray[n], (String)objectArray2[n]);
            ++n;
        }
        this.editCode(iFile, "#include \"DepTest.h\"", "//#include \"DepTest.h\"");
        String[] stringArray2 = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "d.h"};
        ArrayList arrayList2 = new ArrayList();
        this.testProject.refreshLocal(2, null);
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile, indexManager, arrayList2), 3, null, null);
        Object[] objectArray3 = this.convertToLocalPath(stringArray2);
        Object[] objectArray4 = new String[arrayList2.size()];
        Iterator iterator2 = ((AbstractList)arrayList2).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            objectArray4[n2] = (String)iterator2.next();
            ++n2;
        }
        if (objectArray3.length != objectArray4.length) {
            Assert.fail((String)"Number of included files differs from model");
        }
        Arrays.sort(objectArray3);
        Arrays.sort(objectArray4);
        n = 0;
        while (n < objectArray4.length) {
            Assert.assertEquals((String)objectArray3[n], (String)objectArray4[n]);
            ++n;
        }
    }

    public void testDepHeaderChangeTree() throws Exception {
        this.importFile("c.h", "resources/dependency/c.h");
        IFile iFile = this.importFile("a.h", "resources/dependency/a.h");
        this.importFile("DepTest3.h", "resources/dependency/DepTest3.h");
        IFile iFile2 = this.importFile("DepTest3.cpp", "resources/dependency/DepTest3.cpp");
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        String[] stringArray = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "DepTest3.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "a.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "c.h"};
        ArrayList arrayList = new ArrayList();
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile2, indexManager, arrayList), 3, null, null);
        Object[] objectArray = this.convertToLocalPath(stringArray);
        Object[] objectArray2 = new String[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray2[n] = (String)iterator.next();
            ++n;
        }
        if (objectArray.length != objectArray2.length) {
            Assert.fail((String)"Number of included files differs from model");
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        n = 0;
        while (n < objectArray2.length) {
            Assert.assertEquals((String)objectArray[n], (String)objectArray2[n]);
            ++n;
        }
        this.editCode(iFile, "#include \"c.h\"", "//#include \"c.h\"");
        String[] stringArray2 = new String[]{String.valueOf(File.separator) + "DepTestProject" + File.separator + "DepTest3.h", String.valueOf(File.separator) + "DepTestProject" + File.separator + "a.h"};
        ArrayList arrayList2 = new ArrayList();
        this.testProject.refreshLocal(2, null);
        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.testProject, iFile2, indexManager, arrayList2), 3, null, null);
        Object[] objectArray3 = this.convertToLocalPath(stringArray2);
        Object[] objectArray4 = new String[arrayList2.size()];
        Iterator iterator2 = ((AbstractList)arrayList2).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            objectArray4[n2] = (String)iterator2.next();
            ++n2;
        }
        if (objectArray3.length != objectArray4.length) {
            Assert.fail((String)"Number of included files differs from model");
        }
        Arrays.sort(objectArray3);
        Arrays.sort(objectArray4);
        n = 0;
        while (n < objectArray4.length) {
            Assert.assertEquals((String)objectArray3[n], (String)objectArray4[n]);
            ++n;
        }
    }

    public void testDepHeaderChangeTable() throws Exception {
        IFile iFile = this.importFile("c.h", "resources/dependency/c.h");
        IFile iFile2 = this.importFile("a.h", "resources/dependency/a.h");
        IFile iFile3 = this.importFile("DepTest3.h", "resources/dependency/DepTest3.h");
        this.importFile("DepTest3.cpp", "resources/dependency/DepTest3.cpp");
        String[] stringArray = new String[]{"/DepTestProject/DepTest3.cpp"};
        PathCollector pathCollector = new PathCollector();
        this.getTableRefs(iFile3, pathCollector);
        String[] stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile2, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        this.editCode(iFile2, "#include \"c.h\"", "//#include \"c.h\"");
        pathCollector = new PathCollector();
        this.getTableRefs(iFile3, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
        pathCollector = new PathCollector();
        this.getTableRefs(iFile, pathCollector);
        stringArray2 = pathCollector.getPaths();
        if (stringArray2.length != 0) {
            Assert.fail((String)"Number of included files differs from model");
        }
        pathCollector = new PathCollector();
        this.getTableRefs(iFile2, pathCollector);
        stringArray2 = pathCollector.getPaths();
        this.compareArrays(stringArray2, stringArray);
    }

    public void testUpdateDependancyNPE() {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject("non-existant-project-aha");
        Assert.assertFalse((boolean)iProject.exists());
        Assert.assertNull((Object)iProject.getLocation());
        UpdateDependency updateDependency = new UpdateDependency((IResource)iProject);
        Assert.assertFalse((boolean)updateDependency.execute((IProgressMonitor)new NullProgressMonitor()));
    }

    public void testDepHeaderChangeReindex() throws Exception {
        Iterator iterator;
        IMatch iMatch;
        this.importFile("c.h", "resources/dependency/c.h");
        this.importFile("a.h", "resources/dependency/a.h");
        IFile iFile = this.importFile("DepTest3.h", "resources/dependency/DepTest3.h");
        this.importFile("DepTest3.cpp", "resources/dependency/DepTest3.cpp");
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Z", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        if (set.size() != 1) {
            Assert.fail((String)"Expected 1 match");
        }
        if (!(iMatch = (IMatch)(iterator = set.iterator()).next()).getName().equals("Z") && iMatch.getElementType() != 64) {
            Assert.fail((String)"Wrong search result");
        }
        this.editCode(iFile, "#include \"a.h\"", "//#include \"a.h\"");
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        if (set.size() != 0) {
            Assert.fail((String)"Expected no matches");
        }
    }

    private String[] convertToLocalPath(String[] stringArray) {
        Path path = new Path("");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(path.toOSString());
            stringBuffer.append(stringArray[n]);
            stringArray2[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray2;
    }

    private void getTableRefs(IFile iFile, PathCollector pathCollector) throws InterruptedException {
        ICSearchScope iCSearchScope = SearchEngine.createWorkspaceScope();
        CSearchPattern cSearchPattern = CSearchPattern.createPattern((String)iFile.getLocation().toOSString(), (ICSearchConstants.SearchFor)ICSearchConstants.INCLUDE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (int)0, (boolean)true);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        indexManager.performConcurrentJob((IJob)new PatternSearchJob(cSearchPattern, iCSearchScope, (IIndexSearchRequestor)pathCollector, indexManager), 3, null, null);
    }

    private void editCode(IFile iFile, String string, String string2) throws IOException, CoreException, InterruptedException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(iFile.getLocation().toOSString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)fileNotFoundException.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        File file = new File(String.valueOf(iFile.getLocation().toOSString()) + "TempFile");
        FileWriter fileWriter = new FileWriter(file);
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.equals(string)) {
                    fileWriter.write(String.valueOf(string2) + "\n");
                    fileWriter.flush();
                    continue;
                }
                fileWriter.write(String.valueOf(string3) + "\n");
                fileWriter.flush();
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        fileWriter.close();
        bufferedReader.close();
        FileInputStream fileInputStream = new FileInputStream(file);
        iFile.setContents((InputStream)fileInputStream, true, false, null);
        iFile.refreshLocal(2, null);
    }

    private void compareArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            Assert.fail((String)"Number of included files differs from model");
        }
        Arrays.sort(stringArray);
        Arrays.sort(stringArray2);
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    protected void search(IWorkspace iWorkspace, ICSearchPattern iCSearchPattern, ICSearchScope iCSearchScope, ICSearchResultCollector iCSearchResultCollector) {
        try {
            this.searchEngine.search(iWorkspace, iCSearchPattern, iCSearchScope, iCSearchResultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject(string, "bin");
        return iCProject.getProject();
    }

    private IFile importFile(String string, String string2) throws Exception {
        this.getName();
        this.file = this.testProject.getProject().getFile(string);
        this.monitor = new NullProgressMonitor();
        if (!this.file.exists()) {
            this.file.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(string2))), false, (IProgressMonitor)this.monitor);
        }
        this.fileDoc = new IFileDocument(this.file);
        return this.file;
    }
}

