/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.indexer.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IndexManagerTests
extends TestCase {
    IFile file;
    IFileDocument fileDoc;
    IProject testProject;
    NullProgressMonitor monitor;
    IndexManager indexManager;
    public static final int TIMEOUT = 5000;
    static /* synthetic */ Class class$0;

    public IndexManagerTests(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.monitor = new NullProgressMonitor();
        this.testProject = this.createProject("IndexerTestProject");
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        this.indexManager.reset();
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.testProject.exists()) {
            try {
                this.testProject.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                Assert.fail((String)this.getMessage(coreException.getStatus()));
            }
        }
    }

    private String getMessage(IStatus iStatus) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append(this.getMessage(iStatusArray[n]));
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.indexer.tests.IndexManagerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new IndexManagerTests("testAddNewFileToIndex"));
        testSuite.addTest((Test)new IndexManagerTests("testForwardDeclarations"));
        testSuite.addTest((Test)new IndexManagerTests("testIndexAll"));
        testSuite.addTest((Test)new IndexManagerTests("testIndexContents"));
        testSuite.addTest((Test)new IndexManagerTests("testMacros"));
        testSuite.addTest((Test)new IndexManagerTests("testRefs"));
        testSuite.addTest((Test)new IndexManagerTests("testRemoveFileFromIndex"));
        testSuite.addTest((Test)new IndexManagerTests("testRemoveProjectFromIndex"));
        testSuite.addTest((Test)new IndexManagerTests("testIndexShutdown"));
        return testSuite;
    }

    private IProject createProject(String string) {
        ICProject iCProject = CProjectHelper.createCCProject(string, "bin");
        return iCProject.getProject();
    }

    private IFile importFile(String string, String string2) throws Exception {
        this.file = this.testProject.getProject().getFile(string);
        this.monitor = new NullProgressMonitor();
        if (!this.file.exists()) {
            this.file.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(string2))), false, (IProgressMonitor)this.monitor);
        }
        this.fileDoc = new IFileDocument(this.file);
        return this.file;
    }

    public void testIndexAll() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        Thread.sleep(5000L);
        IIndex iIndex = this.indexManager.getIndex(this.testProject.getFullPath(), true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        char[] cArray = "typeDecl/".toCharArray();
        IQueryResult[] iQueryResultArray = iIndex.queryPrefix(cArray);
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(cArray);
        Assert.assertTrue((String)"Query Results exist", (iQueryResultArray != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Entry Results exist", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"IndexedFile(1: /IndexerTestProject/mail.cpp)"};
        String[] stringArray2 = new String[]{"EntryResult: word=typeDecl/C/Mail, refs={ 1 }", "EntryResult: word=typeDecl/C/Unknown, refs={ 1 }", "EntryResult: word=typeDecl/C/container, refs={ 1 }", "EntryResult: word=typeDecl/C/first_class, refs={ 1 }", "EntryResult: word=typeDecl/C/postcard, refs={ 1 }", "EntryResult: word=typeDecl/V/PO_Box, refs={ 1 }", "EntryResult: word=typeDecl/V/size, refs={ 1 }", "EntryResult: word=typeDecl/V/temp, refs={ 1 }", "EntryResult: word=typeDecl/V/x, refs={ 1 }"};
        if (iQueryResultArray.length != stringArray.length) {
            Assert.fail((String)"Query Result length different from model");
        }
        if (iEntryResultArray.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iQueryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iQueryResultArray[n].toString());
            ++n;
        }
        n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray2[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
    }

    public void testAddNewFileToIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        Thread.sleep(10000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.importFile("DocumentManager.h", "resources/indexer/DocumentManager.h");
        this.importFile("DocumentManager.cpp", "resources/indexer/DocumentManager.cpp");
        Thread.sleep(10000L);
        iIndex = this.indexManager.getIndex(iPath, true, true);
        char[] cArray = "typeDecl/C/CDocumentManager".toCharArray();
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/C/CDocumentManager, refs={ 1 }"};
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(cArray);
        Assert.assertTrue((String)"Entry Result exists", (iEntryResultArray != null ? 1 : 0) != 0);
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
    }

    public void testRemoveProjectFromIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.safeDelete(this.testProject);
        iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index deleted", (iIndex == null ? 1 : 0) != 0);
    }

    private void safeDelete(IProject iProject) throws InterruptedException, CoreException {
        try {
            iProject.delete(true, (IProgressMonitor)this.monitor);
        }
        catch (CoreException coreException) {
            Thread.sleep(5000L);
            iProject.delete(true, (IProgressMonitor)this.monitor);
        }
    }

    public void testRemoveFileFromIndex() throws Exception {
        this.importFile("mail.cpp", "resources/indexer/mail.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        this.importFile("DocumentManager.h", "resources/indexer/DocumentManager.h");
        this.importFile("DocumentManager.cpp", "resources/indexer/DocumentManager.cpp");
        Thread.sleep(10000L);
        iIndex = this.indexManager.getIndex(iPath, true, true);
        char[] cArray = "typeDecl/".toCharArray();
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(cArray);
        Assert.assertTrue((String)"Entry result found for typdeDecl/", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/C/CDocumentManager, refs={ 1 }", "EntryResult: word=typeDecl/C/Mail, refs={ 2 }", "EntryResult: word=typeDecl/C/Unknown, refs={ 2 }", "EntryResult: word=typeDecl/C/container, refs={ 2 }", "EntryResult: word=typeDecl/C/first_class, refs={ 2 }", "EntryResult: word=typeDecl/C/postcard, refs={ 2 }", "EntryResult: word=typeDecl/V/PO_Box, refs={ 2 }", "EntryResult: word=typeDecl/V/size, refs={ 2 }", "EntryResult: word=typeDecl/V/temp, refs={ 2 }", "EntryResult: word=typeDecl/V/x, refs={ 2 }"};
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
        IResource iResource = this.testProject.findMember("mail.cpp");
        iResource.delete(true, (IProgressMonitor)this.monitor);
        Thread.sleep(10000L);
        iIndex = this.indexManager.getIndex(iPath, true, true);
        iEntryResultArray = iIndex.queryEntries(cArray);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray2 = new String[]{"EntryResult: word=typeDecl/C/CDocumentManager, refs={ 1 }"};
        if (iEntryResultArray.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray2[n2], (String)iEntryResultArray[n2].toString());
            ++n2;
        }
    }

    public void testIndexContents() throws Exception {
        this.importFile("extramail.cpp", "resources/indexer/extramail.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(IIndexConstants.TYPE_REF);
        Assert.assertTrue((String)"Type Ref Results exist", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/C/Mail/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/C/Unknown/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/C/container/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/C/first_class/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/C/postcard/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/E/test/Y/X/Z, refs={ 1 }", "EntryResult: word=typeDecl/T/int32, refs={ 1 }", "EntryResult: word=typeDecl/V/PO_Box, refs={ 1 }", "EntryResult: word=typeDecl/V/size, refs={ 1 }", "EntryResult: word=typeDecl/V/temp, refs={ 1 }", "EntryResult: word=typeDecl/V/x, refs={ 1 }", "EntryResult: word=typeDecl/V/x/Z, refs={ 1 }"};
        IEntryResult[] iEntryResultArray2 = iIndex.queryEntries(IIndexConstants.TYPE_DECL);
        Assert.assertTrue((String)"Type Decl Results exist", (iEntryResultArray2 != null ? 1 : 0) != 0);
        if (iEntryResultArray2.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for typeDecl");
        }
        int n = 0;
        while (n < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray2[n].toString());
            ++n;
        }
        String[] stringArray2 = new String[]{"EntryResult: word=typeDecl/T/int32, refs={ 1 }"};
        IEntryResult[] iEntryResultArray3 = iIndex.queryEntries(IIndexConstants.TYPEDEF_DECL);
        Assert.assertTrue((String)"Type Def Results exist", (iEntryResultArray3 != null ? 1 : 0) != 0);
        if (iEntryResultArray3.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model for typeDef");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray3.length) {
            Assert.assertEquals((String)stringArray2[n2], (String)iEntryResultArray3[n2].toString());
            ++n2;
        }
        String[] stringArray3 = new String[]{"EntryResult: word=namespaceDecl/X/Z, refs={ 1 }", "EntryResult: word=namespaceDecl/Y/X/Z, refs={ 1 }", "EntryResult: word=namespaceDecl/Z, refs={ 1 }"};
        IEntryResult[] iEntryResultArray4 = iIndex.queryEntries(IIndexConstants.NAMESPACE_DECL);
        Assert.assertTrue((String)"Namespace Results exist", (iEntryResultArray4 != null ? 1 : 0) != 0);
        if (iEntryResultArray4.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model for namespace");
        }
        int n3 = 0;
        while (n3 < iEntryResultArray4.length) {
            Assert.assertEquals((String)stringArray3[n3], (String)iEntryResultArray4[n3].toString());
            ++n3;
        }
        String[] stringArray4 = new String[]{"EntryResult: word=fieldDecl/array/container/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/bye/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/cool/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/hi/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/index/container/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/postage/Mail/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/sz/container/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/type/Mail/Y/X/Z, refs={ 1 }", "EntryResult: word=fieldDecl/why/Y/X/Z, refs={ 1 }"};
        IEntryResult[] iEntryResultArray5 = iIndex.queryEntries(IIndexConstants.FIELD_DECL);
        Assert.assertTrue((String)"Field Results exist", (iEntryResultArray5 != null ? 1 : 0) != 0);
        if (iEntryResultArray5.length != stringArray4.length) {
            Assert.fail((String)"Entry Result length different from model for fieldDecl");
        }
        int n4 = 0;
        while (n4 < iEntryResultArray5.length) {
            Assert.assertEquals((String)stringArray4[n4], (String)iEntryResultArray5[n4].toString());
            ++n4;
        }
        String[] stringArray5 = new String[]{"EntryResult: word=functionDecl/doSomething, refs={ 1 }", "EntryResult: word=functionDecl/main/Y/X/Z, refs={ 1 }"};
        IEntryResult[] iEntryResultArray6 = iIndex.queryEntries(IIndexConstants.FUNCTION_DECL);
        if (iEntryResultArray6.length != stringArray5.length) {
            Assert.fail((String)"Entry Result length different from model for functionDecl");
        }
        int n5 = 0;
        while (n5 < iEntryResultArray6.length) {
            Assert.assertEquals((String)stringArray5[n5], (String)iEntryResultArray6[n5].toString());
            ++n5;
        }
        String[] stringArray6 = new String[]{"EntryResult: word=methodDecl/Mail/Mail/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/Unknown/Unknown/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/container/container/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/first_class/first_class/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/operator =/container/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/operator []/container/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/postcard/postcard/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/print/Mail/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/print/Unknown/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/print/first_class/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/print/postcard/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/size/container/Y/X/Z, refs={ 1 }", "EntryResult: word=methodDecl/~container/container/Y/X/Z, refs={ 1 }"};
        IEntryResult[] iEntryResultArray7 = iIndex.queryEntries(IIndexConstants.METHOD_DECL);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray7 != null ? 1 : 0) != 0);
        if (iEntryResultArray7.length != stringArray6.length) {
            Assert.fail((String)"Entry Result length different from model for functionDecl");
        }
        int n6 = 0;
        while (n6 < iEntryResultArray7.length) {
            Assert.assertEquals((String)("Index is " + n6), (String)stringArray6[n6], (String)iEntryResultArray7[n6].toString());
            ++n6;
        }
    }

    public void testRefs() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeRef/C/C/B/A, refs={ 1 }", "EntryResult: word=typeRef/C/ForwardA/A, refs={ 1 }", "EntryResult: word=typeRef/E/e1/B/A, refs={ 1 }", "EntryResult: word=typeRef/V/x/B/A, refs={ 1 }"};
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(IIndexConstants.TYPE_REF);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for typeRef");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
        String[] stringArray2 = new String[]{"EntryResult: word=functionRef/something/A, refs={ 1 }"};
        IEntryResult[] iEntryResultArray2 = iIndex.queryEntries(IIndexConstants.FUNCTION_REF);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray2 != null ? 1 : 0) != 0);
        if (iEntryResultArray2.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model for funcRef");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray2[n2], (String)iEntryResultArray2[n2].toString());
            ++n2;
        }
        String[] stringArray3 = new String[]{"EntryResult: word=namespaceRef/A, refs={ 1 }", "EntryResult: word=namespaceRef/B/A, refs={ 1 }"};
        IEntryResult[] iEntryResultArray3 = iIndex.queryEntries(IIndexConstants.NAMESPACE_REF);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray3 != null ? 1 : 0) != 0);
        if (iEntryResultArray3.length != stringArray3.length) {
            Assert.fail((String)"Entry Result length different from model for namespaceRef");
        }
        int n3 = 0;
        while (n3 < iEntryResultArray3.length) {
            Assert.assertEquals((String)stringArray3[n3], (String)iEntryResultArray3[n3].toString());
            ++n3;
        }
        String[] stringArray4 = new String[]{"EntryResult: word=fieldRef/y/C/B/A, refs={ 1 }"};
        IEntryResult[] iEntryResultArray4 = iIndex.queryEntries(IIndexConstants.FIELD_REF);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray4 != null ? 1 : 0) != 0);
        if (iEntryResultArray4.length != stringArray4.length) {
            Assert.fail((String)"Entry Result length different from model for fieldRef");
        }
        int n4 = 0;
        while (n4 < iEntryResultArray4.length) {
            Assert.assertEquals((String)stringArray4[n4], (String)iEntryResultArray4[n4].toString());
            ++n4;
        }
        String[] stringArray5 = new String[]{"EntryResult: word=methodRef/bar/C/B/A, refs={ 1 }"};
        IEntryResult[] iEntryResultArray5 = iIndex.queryEntries(IIndexConstants.METHOD_REF);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray5 != null ? 1 : 0) != 0);
        if (iEntryResultArray5.length != stringArray5.length) {
            Assert.fail((String)"Entry Result length different from model for methodRef");
        }
        int n5 = 0;
        while (n5 < iEntryResultArray5.length) {
            Assert.assertEquals((String)stringArray5[n5], (String)iEntryResultArray5[n5].toString());
            ++n5;
        }
    }

    public void testMacros() throws Exception {
        this.importFile("extramail.cpp", "resources/indexer/extramail.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.queryEntries(IIndexConstants.MACRO_DECL);
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=macroDecl/CASE, refs={ 1 }", "EntryResult: word=macroDecl/MAX, refs={ 1 }", "EntryResult: word=macroDecl/PRINT, refs={ 1 }"};
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for macros");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
    }

    public void testIndexShutdown() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        String string = CCorePlugin.getDefault().getStateLocation().append("badIndex.index").toOSString();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {}
        File file = new File(CCorePlugin.getDefault().getStateLocation().toOSString());
        this.indexManager.shutdown();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                if (fileArray[n].getName().equals("badIndex.index")) {
                    Assert.fail((String)"Shutdown did not delete .index file");
                }
                ++n;
            }
        }
    }

    public void testForwardDeclarations() throws Exception {
        this.importFile("reftest.cpp", "resources/indexer/reftest.cpp");
        Thread.sleep(5000L);
        IPath iPath = this.testProject.getFullPath();
        IIndex iIndex = this.indexManager.getIndex(iPath, true, true);
        Assert.assertTrue((String)"Index exists for project", (iIndex != null ? 1 : 0) != 0);
        IEntryResult[] iEntryResultArray = iIndex.queryEntries("typeDecl/C/ForwardA/A".toCharArray());
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray != null ? 1 : 0) != 0);
        String[] stringArray = new String[]{"EntryResult: word=typeDecl/C/ForwardA/A, refs={ 1 }"};
        if (iEntryResultArray.length != stringArray.length) {
            Assert.fail((String)"Entry Result length different from model for forward declarations");
        }
        int n = 0;
        while (n < iEntryResultArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)iEntryResultArray[n].toString());
            ++n;
        }
        IEntryResult[] iEntryResultArray2 = iIndex.queryEntries("typeRef/C/ForwardA/A".toCharArray());
        Assert.assertTrue((String)"Entry exists", (iEntryResultArray2 != null ? 1 : 0) != 0);
        String[] stringArray2 = new String[]{"EntryResult: word=typeRef/C/ForwardA/A, refs={ 1 }"};
        if (iEntryResultArray2.length != stringArray2.length) {
            Assert.fail((String)"Entry Result length different from model for forward declarations refs");
        }
        int n2 = 0;
        while (n2 < iEntryResultArray2.length) {
            Assert.assertEquals((String)stringArray2[n2], (String)iEntryResultArray2[n2].toString());
            ++n2;
        }
    }
}

