/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.IntegratedCModelTest;

public class IIncludeTests
extends IntegratedCModelTest {
    static /* synthetic */ Class class$0;

    public IIncludeTests(String string) {
        super(string);
    }

    public String getSourcefileSubdir() {
        return "resources/cmodel/";
    }

    public String getSourcefileResource() {
        return "IIncludeTest.h";
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.IIncludeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        return testSuite;
    }

    public void testGetIncludeName() {
        ITranslationUnit iTranslationUnit = this.getTU();
        IInclude[] iIncludeArray = null;
        try {
            iIncludeArray = iTranslationUnit.getIncludes();
        }
        catch (CModelException cModelException) {
            Assert.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        String[] stringArray = new String[]{new String("stdio.h"), new String("whatever.h"), new String("src/slash.h"), new String("src\\backslash.h"), new String("Program Files/space.h"), new String("../up1dir.h"), new String("./samedir.h"), new String("different_extension1.hpp"), new String("different_extension2.hh"), new String("different_extension3.x"), new String("no_extension"), new String("whitespace_after_hash"), new String("whitespace_before_hash"), new String("resync_after_bad_parse_1"), new String("resync_after_bad_parse_2"), new String("onetwothree"), new String("resync_after_bad_parse_3"), new String("invalid.h"), new String("myInclude1.h"), new String("vers2.h")};
        Assert.assertEquals((int)stringArray.length, (int)iIncludeArray.length);
        int n = 0;
        while (n < stringArray.length) {
            IInclude iInclude = iIncludeArray[n];
            Assert.assertEquals((String)stringArray[n], (String)iInclude.getIncludeName());
            ++n;
        }
    }

    public void testIsStandard() {
        ITranslationUnit iTranslationUnit = this.getTU();
        IInclude[] iIncludeArray = null;
        try {
            iIncludeArray = iTranslationUnit.getIncludes();
        }
        catch (CModelException cModelException) {
            Assert.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        int n = 0;
        while (n < blArray2.length) {
            IInclude iInclude = iIncludeArray[n];
            Assert.assertEquals((boolean)blArray2[n], (boolean)iInclude.isStandard());
            ++n;
        }
    }
}

