/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class IntegratedCModelTest
extends TestCase {
    private ICProject fCProject;
    private IFile sourceFile;
    private NullProgressMonitor monitor;

    public IntegratedCModelTest() {
    }

    public IntegratedCModelTest(String string) {
        super(string);
    }

    public abstract String getSourcefileSubdir();

    public abstract String getSourcefileResource();

    public void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.sourceFile = this.fCProject.getProject().getFile(this.getSourcefileResource());
        if (!this.sourceFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(String.valueOf(this.getSourcefileSubdir()) + this.getSourcefileResource())));
                this.sourceFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    protected ITranslationUnit getTU() {
        TranslationUnit translationUnit = new TranslationUnit((ICElement)this.fCProject, this.sourceFile);
        translationUnit.parse();
        return translationUnit;
    }
}

