/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileNotFoundException;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.TranslationUnitBaseTest;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.util.ExpectedStrings;
import org.eclipse.core.runtime.CoreException;

public class TranslationUnitTests
extends TranslationUnitBaseTest {
    String[] expectedStringList = new String[]{"stdio.h", "unistd.h", "func2p", "globalvar", "myenum", "mystruct", "mystruct_t", "myunion", "mytype", "func1", "func2", "main", "func3"};
    int[] expectedLines = new int[]{12, 14, 17, 20, 23, 28, 32, 35, 42, 47, 53, 58, 65, 70};
    int[] expectedTypes = new int[]{72, 72, 70, 74, 63, 65, 78, 66, 78, 71, 71, 71, 71, 71};
    static /* synthetic */ Class class$0;

    public TranslationUnitTests(String string) {
        super(string);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.TranslationUnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new TranslationUnitTests("testIsTranslationUnit"));
        testSuite.addTest((Test)new TranslationUnitTests("testGetChildren"));
        testSuite.addTest((Test)new TranslationUnitTests("testGetElement"));
        testSuite.addTest((Test)new TranslationUnitTests("testBug23478A"));
        testSuite.addTest((Test)new TranslationUnitTests("testBug23478B"));
        return testSuite;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TranslationUnitTests.suite());
    }

    public void testIsTranslationUnit() throws CoreException, FileNotFoundException {
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        Assert.assertTrue((String)"A TranslationUnit", (iTranslationUnit != null ? 1 : 0) != 0);
    }

    public void testGetChildren() {
        ExpectedStrings expectedStrings = new ExpectedStrings(this.expectedStringList);
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        if (iTranslationUnit.hasChildren()) {
            ICElement[] iCElementArray = iTranslationUnit.getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                expectedStrings.foundString(iCElementArray[n].getElementName());
                ++n;
            }
        }
        Assert.assertTrue((String)("PR:23603 " + expectedStrings.getMissingString()), (boolean)expectedStrings.gotAll());
        Assert.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
    }

    public void testGetElement() throws CModelException {
        Stack<String> stack = new Stack<String>();
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < this.expectedStringList.length) {
            ICElement iCElement = iTranslationUnit.getElement(this.expectedStringList[n]);
            if (iCElement == null) {
                stack.push(this.expectedStringList[n]);
            } else {
                Assert.assertTrue((String)("Expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            }
            ++n;
        }
        if (!stack.empty()) {
            String string = new String("PR:23603 Could not get elements: ");
            while (!stack.empty()) {
                string = String.valueOf(string) + stack.pop() + " ";
            }
            Assert.assertTrue((String)string, (boolean)false);
        }
    }

    public void testBug23478A() {
        String[] stringArray = new String[]{"stdio.h", "unistd.h"};
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < stringArray.length) {
            IInclude iInclude = iTranslationUnit.getInclude(stringArray[n]);
            if (iInclude == null) {
                Assert.fail((String)("Unable to get include: " + stringArray[n]));
            } else {
                Assert.assertTrue((String)("PR:23478 Expected:" + new String("") + " Got:" + iInclude.getIncludeName()), (boolean)stringArray[n].equals(iInclude.getIncludeName()));
            }
            ++n;
        }
    }

    public void testBug23478B() throws CModelException {
        String[] stringArray = new String[]{"stdio.h", "unistd.h"};
        ExpectedStrings expectedStrings = new ExpectedStrings(stringArray);
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        IInclude[] iIncludeArray = iTranslationUnit.getIncludes();
        int n = 0;
        while (n < iIncludeArray.length) {
            expectedStrings.foundString(iIncludeArray[n].getIncludeName());
            ++n;
        }
        Assert.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        Assert.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
    }

    public void testGetElementAtLine() throws CoreException {
        Stack<String> stack = new Stack<String>();
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < this.expectedStringList.length) {
            ICElement iCElement = iTranslationUnit.getElementAtLine(this.expectedLines[n]);
            if (iCElement == null) {
                stack.push(this.expectedStringList[n]);
            } else if (this.expectedStringList[n].equals("mystruct_t")) {
                Assert.assertTrue((String)("PR:23603 expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            } else {
                Assert.assertTrue((String)("Expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            }
            ++n;
        }
        if (!stack.empty()) {
            String string = new String("PR: 23603 Could not get elements: ");
            while (!stack.empty()) {
                string = String.valueOf(string) + stack.pop() + " ";
            }
            Assert.assertTrue((String)string, (boolean)false);
        }
    }
}

