/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.failedTests;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.BaseASTTest;

public class ASTFailedTests
extends BaseASTTest {
    public ASTFailedTests(String string) {
        super(string);
    }

    public void testBug36730() throws Exception {
        this.assertCodeFailsParse("FUNCTION_MACRO( 1, a )\n\tint i;");
    }

    public void testBug39676() throws Exception {
        this.assertCodeFailsParse("struct { int e1, e2; } v = { e2: 0 }");
    }

    public void testBug39677() throws Exception {
        this.assertCodeFailsParse("B::B() : a(({ 1; })) {}");
    }

    public void testBug39679() throws Exception {
        this.assertCodeFailsParse("Foo blat() return f(4) {}");
    }

    public void testBug39681() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("double\n");
            ((Writer)stringWriter).write("foo (double a, double b)\n");
            ((Writer)stringWriter).write("{\n");
            ((Writer)stringWriter).write("  double square (double z) { return z * z; }\n");
            ((Writer)stringWriter).write("  return square (a) + square (b);\n");
            ((Writer)stringWriter).write("}\n");
        }
        catch (IOException iOException) {}
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39682() throws Exception {
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)this.parse("typedef name = (a+1);").getDeclarations().next();
        Assert.assertFalse((String)"The expected error did not occur.", (boolean)iASTTypedefDeclaration.getName().equals("name"));
    }

    public void testBug39684() throws Exception {
        this.assertCodeFailsParse("typeof(foo(1)) bar () { return foo(1); }");
    }

    public void testBug39686() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("__complex__ double x; // complex double\n");
            ((Writer)stringWriter).write("__complex__ short int a; // complex short int\n");
            ((Writer)stringWriter).write("x = 2.5fi; // 2.5 imaginary float literal\n");
            ((Writer)stringWriter).write("a = 3i; // imaginary integer literal\n");
            ((Writer)stringWriter).write("double v = __real__ x; // real part of expression\n");
            ((Writer)stringWriter).write("double w = __imag__ x; // imaginary part of expression\n");
        }
        catch (IOException iOException) {}
        this.assertCodeFailsParse(((Object)stringWriter).toString());
    }

    public void testBug39687() throws Exception {
        this.assertCodeFailsParse("struct entry tester (int len; char data[len][len], int len) {}");
    }

    public void testBug39688() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("#define decl(type, vars...)  \\\n");
            ((Writer)stringWriter).write(" type vars ;\n");
            ((Writer)stringWriter).write("decl(int, x, y)\n");
        }
        catch (IOException iOException) {}
        this.assertCodeFailsParse(((Object)stringWriter).toString());
    }

    public void testBug39694() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("int ab$cd = 1;").getDeclarations().next();
        Assert.assertFalse((String)"The expected error did not occur.", (boolean)iASTVariable.equals("ab$cd"));
    }

    public void testBug39695() throws Exception {
        this.assertCodeFailsParse("int a = __alignof__ (int);");
    }

    public void testBug39695A() throws Exception {
        this.assertCodeFailsParse("int foo asm (\"myfoo\") = 2;");
    }

    public void testBug39695B() throws Exception {
        this.assertCodeFailsParse("extern func () asm (\"FUNC\");");
    }

    public void testBug39695C() throws Exception {
        this.assertCodeFailsParse("register int *foo asm (\"a5\");");
    }

    public void testBug39698A() throws Exception {
        this.assertCodeFailsParse("int c = a <? b;");
    }

    public void testBug39698B() throws Exception {
        this.assertCodeFailsParse("int c = a >? b;");
    }

    public void testBug39701A() throws Exception {
        this.assertCodeFailsParse("extern template int max (int, int);");
    }

    public void testBug39701B() throws Exception {
        this.assertCodeFailsParse("inline template class Foo<int>;");
    }

    public void testBug39701C() throws Exception {
        this.assertCodeFailsParse("static template class Foo<int>;");
    }

    public void testBug39702() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("signature T\t{\n");
            ((Writer)stringWriter).write("  int f (int);\n");
            ((Writer)stringWriter).write("  int f0 () { return f (0); };\n");
            ((Writer)stringWriter).write("};\n");
        }
        catch (IOException iOException) {}
        this.assertCodeFailsFullParse(((Object)stringWriter).toString());
    }

    public void testBug39703() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("/* __extension__ enables GNU C mode for the duration of the declaration.  */\n");
            ((Writer)stringWriter).write("__extension__ struct G {\n");
            ((Writer)stringWriter).write("  struct { char z; };\n");
            ((Writer)stringWriter).write("  char g;\n");
            ((Writer)stringWriter).write("};\n");
        }
        catch (IOException iOException) {}
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)this.assertSoleDeclaration(((Object)stringWriter).toString());
        Assert.assertEquals((String)((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getName(), (String)"G");
    }

    public void testBug39704A() throws Exception {
        this.assertCodeFailsParse("__declspec (dllimport) int foo;");
    }

    public void testBug39704B() throws Exception {
        try {
            IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("extern int (* import) (void) __attribute__((dllimport));");
            Assert.assertEquals((String)iASTVariable.getName(), (String)"__attribute__");
        }
        catch (ClassCastException classCastException) {
            this.failedAsExpected();
        }
    }

    public void testBug39704C() throws Exception {
        try {
            IASTFunction iASTFunction = (IASTFunction)this.assertSoleDeclaration("int func2 (void) __attribute__((dllexport));");
            this.assertNotReached();
            Assert.assertEquals((String)iASTFunction.getName(), (String)"func2");
        }
        catch (ClassCastException classCastException) {}
    }

    public void testBug39704D() throws Exception {
        this.assertCodeFailsParse("__declspec(dllexport) int func1 (int a) {}");
    }

    public void testBug39705() throws Exception {
        this.assertCodeFailsParse("#ident \"@(#)filename.c   1.3 90/02/12\"");
    }

    public void testBug40422() throws Exception {
        this.parse("int A::* x = 0;").getDeclarations().next();
    }
}

