/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;

public class BaseScannerTest
extends TestCase {
    protected IScanner scanner;
    public static final String EXCEPTION_THROWN = "Exception thrown ";
    public static final String EXPECTED_FAILURE = "This statement should not be reached as we sent in bad preprocessor input to the scanner";
    public static final boolean verbose = false;

    public BaseScannerTest(String string) {
        super(string);
    }

    protected void initializeScanner(String string, ParserMode parserMode) throws ParserFactoryError {
        this.initializeScanner(string, parserMode, (ISourceElementRequestor)new NullSourceElementRequestor(parserMode));
    }

    protected void initializeScanner(String string, ParserMode parserMode, ISourceElementRequestor iSourceElementRequestor) throws ParserFactoryError {
        this.scanner = ParserFactory.createScanner((Reader)new StringReader(string), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)parserMode, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)iSourceElementRequestor, null);
    }

    protected void initializeScanner(String string) throws ParserFactoryError {
        this.initializeScanner(string, ParserMode.COMPLETE_PARSE);
    }

    public int fullyTokenize() throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            while (iToken != null) {
                if (iToken.getType() > 137) {
                    System.out.println("Unknown type for token " + iToken);
                }
                iToken = this.scanner.nextToken();
            }
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (ScannerException scannerException) {
            throw scannerException;
        }
        return this.scanner.getCount();
    }

    public void validateIdentifier(String string) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertEquals((int)iToken.getType(), (int)1);
            Assert.assertEquals((String)iToken.getImage(), (String)string);
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateInteger(String string) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iToken.getImage().equals(string));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateFloatingPointLiteral(String string) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 129 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iToken.getImage().equals(string));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateChar(char c) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 132 ? 1 : 0) != 0);
            Character c2 = new Character(c);
            Assert.assertEquals((String)iToken.getImage(), (String)c2.toString());
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateChar(String string) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 132 ? 1 : 0) != 0);
            Assert.assertEquals((String)iToken.getImage(), (String)string);
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateString(String string) throws ScannerException {
        this.validateString(string, false);
    }

    public void validateString(String string, boolean bl) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            if (bl) {
                Assert.assertTrue((iToken.getType() == 131 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((iToken.getType() == 130 ? 1 : 0) != 0);
            }
            Assert.assertTrue((boolean)iToken.getImage().equals(string));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateToken(int n) throws ScannerException {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == n ? 1 : 0) != 0);
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateBalance(int n) {
        Assert.assertTrue((this.scanner.getDepth() == n ? 1 : 0) != 0);
    }

    public void validateBalance() {
        Assert.assertTrue((this.scanner.getDepth() == 0 ? 1 : 0) != 0);
    }

    public void validateEOF() throws ScannerException {
        try {
            Assert.assertNull((Object)this.scanner.nextToken());
        }
        catch (EndOfFileException endOfFileException) {}
    }

    public void validateDefinition(String string, String string2) {
        String string3 = null;
        string3 = this.scanner.getDefinition(string).getExpansionSignature();
        Assert.assertNotNull((Object)string3);
        Assert.assertTrue((boolean)string3.trim().equals(string2));
    }

    public void validateDefinition(String string, int n) {
        String string2 = null;
        string2 = this.scanner.getDefinition(string).getExpansionSignature();
        Assert.assertNotNull((Object)string2);
        int n2 = Integer.valueOf(string2);
        Assert.assertEquals((int)n, (int)n2);
    }

    public void validateAsUndefined(String string) {
        Assert.assertNull((Object)this.scanner.getDefinition(string));
    }

    protected void validateWideChar(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 133 ? 1 : 0) != 0);
            Assert.assertEquals((String)iToken.getImage(), (String)string);
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }
}

