/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParserSymbolTableTemplateTests
extends TestCase {
    public ParserSymbolTable table = null;

    public ParserSymbolTableTemplateTests(String string) {
        super(string);
    }

    public ParserSymbolTable newTable() {
        return this.newTable(ParserLanguage.CPP);
    }

    public ParserSymbolTable newTable(ParserLanguage parserLanguage) {
        this.table = new ParserSymbolTable(parserLanguage, ParserMode.COMPLETE_PARSE);
        return this.table;
    }

    public void testTemplateParameterAsParent() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addParent(iSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        ISymbol iSymbol2 = this.table.newSymbol("i", TypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iDerivableContainerSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(typeInfo);
        IContainerSymbol iContainerSymbol = (IContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList);
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.getCompilationUnit().lookup("a");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol3);
        ISymbol iSymbol5 = iSymbol3.getTypeSymbol();
        Assert.assertEquals((Object)iSymbol5, (Object)iContainerSymbol);
        iSymbol4 = iContainerSymbol.lookup("i");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
    }

    public void testTemplateInstanceAsParent() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("t", TypeInfo.t_type);
        ISymbol iSymbol3 = iTemplateSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        iSymbol2.setTypeSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_int, 0, null);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(typeInfo);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("A", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addParent(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("b", TypeInfo.t_type);
        iSymbol4.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol4);
        iSymbol3 = this.table.getCompilationUnit().lookup("b");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol4);
        iSymbol3 = ((IDerivableContainerSymbol)iSymbol4.getTypeSymbol()).lookup("t");
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iSymbol2);
        Assert.assertTrue((boolean)iSymbol3.isType(TypeInfo.t_int));
    }

    public void testTemplateParameterDefaults() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        ISymbol iSymbol2 = iTemplateSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        iSymbol3.getTypeInfo().setDefault((Object)new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol2 = iDerivableContainerSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol4 = this.table.newSymbol("t", TypeInfo.t_type);
        iSymbol4.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol(iSymbol4);
        iSymbol2 = iDerivableContainerSymbol.lookup("U");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        ISymbol iSymbol5 = this.table.newSymbol("u", TypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol(iSymbol5);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_char, 0, null);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(typeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("X", linkedList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol2 = iDerivableContainerSymbol2.lookup("t");
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iSymbol4);
        Assert.assertTrue((boolean)iSymbol2.isType(TypeInfo.t_char));
        iSymbol2 = iDerivableContainerSymbol2.lookup("u");
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iSymbol5);
        Assert.assertTrue((boolean)iSymbol2.isType(TypeInfo.t_char));
    }

    public void testTemplateParameterAsFunctionArgument() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("t", TypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iDerivableContainerSymbol2);
        linkedList.add(typeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList);
        Assert.assertTrue((boolean)iDerivableContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_char, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        linkedList = new LinkedList();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iDerivableContainerSymbol2));
        IDerivableContainerSymbol iDerivableContainerSymbol4 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList);
        Assert.assertEquals((Object)iDerivableContainerSymbol4, (Object)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        IParameterizedSymbol iParameterizedSymbol4 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList2);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
    }

    public void test_14_1__3_ParameterLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("T", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("i", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        ISymbol iSymbol2 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("i", TypeInfo.t_templateParameter);
        iSymbol3.getTypeInfo().setTemplateParameterType(TypeInfo.t_type);
        ISymbol iSymbol4 = iTemplateSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol3.setTypeSymbol(iSymbol4);
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        ISymbol iSymbol5 = this.table.newSymbol("t", TypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol2);
        iParameterizedSymbol.addParameter(iSymbol5);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        iSymbol4 = iParameterizedSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol4 = iParameterizedSymbol.lookup("i");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol3);
    }

    public void test_14_1__8_ParameterAdjustment() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("R");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol = this.table.newSymbol("a", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("R", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("S");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("b", TypeInfo.t_templateParameter);
        iSymbol2.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array));
        iTemplateSymbol2.addTemplateParameter(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("S", TypeInfo.t_struct);
        iTemplateSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookup("S");
        Assert.assertEquals((Object)iSymbol3, (Object)iTemplateSymbol2);
        Iterator iterator = iTemplateSymbol2.getParameterList().iterator();
        ISymbol iSymbol4 = (ISymbol)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iSymbol4.getTypeInfo().getPtrOperators().iterator();
        TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ptrOp.getType(), (Object)TypeInfo.PtrOp.t_pointer);
        ISymbol iSymbol5 = this.table.newSymbol("p", TypeInfo.t_int);
        iSymbol5.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol5));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("R", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("S", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        ISymbol iSymbol6 = this.table.newSymbol("v", TypeInfo.t_int);
        iSymbol6.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array));
        this.table.getCompilationUnit().addSymbol(iSymbol6);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol6));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("R", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("S", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
    }

    public void test_14_3__4_ParameterDefaults() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("String");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setDefault((Object)new TypeInfo(TypeInfo.t_char, 0, null));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("String", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        LinkedList linkedList = new LinkedList();
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplate("String", linkedList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
    }

    public void test_14_3_1__2_TypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iTemplateSymbol.addSymbol((ISymbol)this.table.newDerivableContainerSymbol("X", TypeInfo.t_class));
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("S", TypeInfo.t_struct);
        iParameterizedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iDerivableContainerSymbol));
        try {
            iParameterizedSymbol.lookupTemplate("X", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iDerivableContainerSymbol, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        try {
            iParameterizedSymbol.lookupTemplate("X", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
    }

    public void test_14_3_2__2_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        ISymbol iSymbol = this.table.newSymbol("p", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(TypeInfo.t_char);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_char, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), (Object)"Studebaker"));
        try {
            this.table.getCompilationUnit().lookupTemplate("X", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        ISymbol iSymbol2 = this.table.newSymbol("p", TypeInfo.t_char);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplate("X", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
    }

    public void test_14_3_2__3_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol = this.table.newSymbol("p", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("S", TypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("m", TypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("s", TypeInfo.t_int);
        iSymbol3.getTypeInfo().setBit(true, 128);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("t", TypeInfo.t_int);
        iSymbol4.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        iDerivableContainerSymbol2.addSymbol(iSymbol4);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        linkedList.add(typeInfo);
        try {
            this.table.getCompilationUnit().lookupTemplate("X", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol4));
        try {
            this.table.getCompilationUnit().lookupTemplate("X", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        linkedList.clear();
        typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol3);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        linkedList.add(typeInfo);
        Assert.assertNotNull((Object)this.table.getCompilationUnit().lookupTemplate("X", linkedList));
    }

    public void test_14_3_2__4_NonTypeArgumentRestrictions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("B");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol = this.table.newSymbol("I", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, true, false));
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"1"));
        try {
            this.table.getCompilationUnit().lookupTemplate("B", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)8);
        }
        ISymbol iSymbol2 = this.table.newSymbol("c", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplate("B", linkedList);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
    }

    public void test_14_3_3__2_PartialSpecialization_TemplateTemplateParameter() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A");
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSpecializedSymbol.addTemplateParameter(iSymbol2);
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol2, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("x", TypeInfo.t_int);
        iSymbol3.getTypeInfo().setBit(true, 524288);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("C");
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("V");
        iTemplateSymbol3.setType(TypeInfo.t_templateParameter);
        iTemplateSymbol3.getTypeInfo().setTemplateParameterType(TypeInfo.t_template);
        ISymbol iSymbol4 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol4);
        iTemplateSymbol2.addTemplateParameter((ISymbol)iTemplateSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C", TypeInfo.t_class);
        iTemplateSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        ISymbol iSymbol5 = iTemplateSymbol2.lookupTemplate("V", linkedList);
        Assert.assertTrue((iSymbol5 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol5 instanceof IDeferredTemplateInstance));
        ISymbol iSymbol6 = this.table.newSymbol("y", TypeInfo.t_type);
        iSymbol6.setTypeSymbol(iSymbol5);
        iDerivableContainerSymbol3.addSymbol(iSymbol6);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        iSymbol5 = iTemplateSymbol2.lookupTemplate("V", linkedList);
        Assert.assertTrue((iSymbol5 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol5 instanceof IDeferredTemplateInstance));
        ISymbol iSymbol7 = this.table.newSymbol("z", TypeInfo.t_type);
        iSymbol7.setTypeSymbol(iSymbol5);
        iDerivableContainerSymbol3.addSymbol(iSymbol7);
        iSymbol5 = this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iSymbol5, (Object)iTemplateSymbol);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol5));
        iSymbol5 = this.table.getCompilationUnit().lookupTemplate("C", linkedList);
        Assert.assertTrue((boolean)iSymbol5.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol5.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = (IDerivableContainerSymbol)iSymbol5;
        iSymbol5 = iDerivableContainerSymbol4.lookup("y");
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)TypeInfo.t_type);
        ISymbol iSymbol8 = iSymbol5.getTypeSymbol();
        Assert.assertTrue((boolean)(iSymbol8 instanceof IContainerSymbol));
        Assert.assertTrue((boolean)iSymbol8.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol8.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol5 = ((IContainerSymbol)iSymbol8).lookup("x");
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)TypeInfo.t_int);
        Assert.assertEquals((boolean)iSymbol5.getTypeInfo().checkBit(524288), (boolean)false);
        iSymbol5 = iDerivableContainerSymbol4.lookup("z");
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)TypeInfo.t_type);
        iSymbol8 = iSymbol5.getTypeSymbol();
        Assert.assertTrue((boolean)(iSymbol8 instanceof IContainerSymbol));
        Assert.assertTrue((boolean)iSymbol8.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol8.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol5 = ((IContainerSymbol)iSymbol8).lookup("x");
        Assert.assertEquals((Object)iSymbol5.getType(), (Object)TypeInfo.t_int);
        Assert.assertEquals((boolean)iSymbol5.getTypeInfo().checkBit(524288), (boolean)true);
    }

    public void test_14_5_1__3_MemberFunctions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T1", TypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f1", TypeInfo.t_function);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iParameterizedSymbol.setReturnType(iSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f2", TypeInfo.t_function);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        ISymbol iSymbol4 = this.table.newSymbol("V", TypeInfo.t_templateParameter);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        linkedList.add(iSymbol3);
        linkedList.add(iSymbol4);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol4));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        Assert.assertTrue((iTemplateFactory != null ? 1 : 0) != 0);
        IParameterizedSymbol iParameterizedSymbol3 = iTemplateFactory.lookupMemberFunctionForDefinition("f1", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        Assert.assertTrue((boolean)iParameterizedSymbol3.isForwardDeclaration());
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f1", TypeInfo.t_function);
        iParameterizedSymbol.setTypeSymbol((ISymbol)iParameterizedSymbol4);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol4);
        ISymbol iSymbol5 = iParameterizedSymbol4.lookup("U");
        Assert.assertEquals((Object)iSymbol5, (Object)iSymbol3);
        iParameterizedSymbol4.setReturnType(iSymbol5);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iDerivableContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        linkedList.clear();
        iSymbol5 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f1", linkedList);
        Assert.assertTrue((boolean)iSymbol5.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol5.getInstantiatedSymbol(), (Object)iParameterizedSymbol4);
        Assert.assertTrue((boolean)((IParameterizedSymbol)iSymbol5).getReturnType().isType(TypeInfo.t_int));
        linkedList.clear();
        linkedList2.clear();
        ISymbol iSymbol6 = this.table.newSymbol("X", TypeInfo.t_templateParameter);
        ISymbol iSymbol7 = this.table.newSymbol("Y", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol6);
        linkedList.add(iSymbol7);
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol7));
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol6));
        try {
            iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)4);
        }
    }

    public void test_14_5_1_2_MemberClass() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        ISymbol iSymbol2 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol2);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        Assert.assertTrue((iTemplateFactory != null ? 1 : 0) != 0);
        ISymbol iSymbol3 = iTemplateFactory.lookupMemberForDefinition("B");
        Assert.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("i", TypeInfo.t_type);
        iSymbol3 = iDerivableContainerSymbol3.lookup("U");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        iSymbol4.setTypeSymbol(iSymbol2);
        iDerivableContainerSymbol3.addSymbol(iSymbol4);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertTrue((boolean)(iSymbol3 instanceof IDerivableContainerSymbol));
        IDerivableContainerSymbol iDerivableContainerSymbol4 = (IDerivableContainerSymbol)iSymbol3;
        iSymbol3 = iDerivableContainerSymbol4.qualifiedLookup("B");
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        iSymbol3 = ((IDerivableContainerSymbol)iSymbol3).lookup("i");
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iSymbol4);
        Assert.assertEquals((Object)iSymbol3.getType(), (Object)TypeInfo.t_int);
    }

    public void test_14_5_1_3_StaticDataMember() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("s", TypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iSymbol2.getTypeInfo().setBit(true, 128);
        iSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        ISymbol iSymbol3 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol3);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("X", linkedList, linkedList2);
        Assert.assertTrue((iTemplateFactory != null ? 1 : 0) != 0);
        ISymbol iSymbol4 = iTemplateFactory.lookupMemberForDefinition("s");
        Assert.assertTrue((boolean)iSymbol4.isForwardDeclaration());
        ISymbol iSymbol5 = this.table.newSymbol("s", TypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol3);
        iSymbol4.setTypeSymbol(iSymbol5);
        iTemplateFactory.addSymbol(iSymbol5);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_float, 0, null));
        iSymbol4 = this.table.getCompilationUnit().lookupTemplate("X", linkedList2);
        Assert.assertTrue((boolean)iSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol4 = ((IContainerSymbol)iSymbol4).qualifiedLookup("s");
        Assert.assertTrue((boolean)iSymbol4.isType(TypeInfo.t_float));
        Assert.assertTrue((boolean)iSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol4.getInstantiatedSymbol(), (Object)iSymbol5);
    }

    public void test_14_5_2__1_MemberTemplates() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("string");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("string", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("compare");
        ISymbol iSymbol = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        iDerivableContainerSymbol.addSymbol((ISymbol)iTemplateSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("compare", TypeInfo.t_function);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iParameterizedSymbol.addParameter(iSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, true, false), false);
        iParameterizedSymbol.setReturnType(iSymbol);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        ISymbol iSymbol2 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol2);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("string", linkedList, linkedList2);
        linkedList.clear();
        ISymbol iSymbol3 = this.table.newSymbol("V", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol3);
        iTemplateFactory = iTemplateFactory.lookupTemplateForMemberDefinition("compare", linkedList, null);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("compare", TypeInfo.t_function);
        ISymbol iSymbol4 = iTemplateFactory.lookupParam("V");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol3);
        iParameterizedSymbol2.addParameter(iSymbol4, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, true, false), false);
        iParameterizedSymbol2.setReturnType(iSymbol4);
        iParameterizedSymbol.setTypeSymbol((ISymbol)iParameterizedSymbol2);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        iSymbol4 = iParameterizedSymbol2.lookup("U");
        Assert.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        ISymbol iSymbol5 = this.table.newSymbol("u", TypeInfo.t_type);
        iSymbol5.setTypeSymbol(iSymbol4);
        iParameterizedSymbol2.addSymbol(iSymbol5);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol4 = this.table.getCompilationUnit().lookupTemplate("string", linkedList2);
        Assert.assertTrue((boolean)iSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol4 = ((IDerivableContainerSymbol)iSymbol4).lookupTemplate("compare", linkedList2);
        Assert.assertTrue((boolean)iSymbol4.isTemplateInstance());
        Assert.assertTrue((boolean)iSymbol4.getInstantiatedSymbol().isTemplateInstance());
        Assert.assertEquals((Object)iSymbol4.getInstantiatedSymbol().getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        Assert.assertTrue((boolean)((IParameterizedSymbol)iSymbol4).getReturnType().isType(TypeInfo.t_int));
        iSymbol4 = ((IContainerSymbol)iSymbol4).lookup("u");
        Assert.assertTrue((boolean)iSymbol4.isTemplateInstance());
        Assert.assertTrue((boolean)iSymbol4.getInstantiatedSymbol().isTemplateInstance());
        Assert.assertEquals((Object)iSymbol4.getInstantiatedSymbol().getInstantiatedSymbol(), (Object)iSymbol5);
        Assert.assertTrue((boolean)iSymbol4.isType(TypeInfo.t_int));
    }

    public void test_14_5_2__3_VirtualMemberFunctionTemplate() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("g");
        ISymbol iSymbol = this.table.newSymbol("C", TypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iParameterizedSymbol.getTypeInfo().setBit(true, 2048);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        try {
            iDerivableContainerSymbol.addSymbol((ISymbol)iTemplateSymbol2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)4);
        }
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.getTypeInfo().setBit(true, 2048);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
    }

    public void test_14_5_4__7_PartialSpecializationLookup() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("N", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T1", TypeInfo.t_templateParameter));
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T2", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iTemplateSymbol);
        this.table.getCompilationUnit().addUsingDeclaration("A", iContainerSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSpecializedSymbol.addTemplateParameter(iSymbol);
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol));
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplate("A", linkedList);
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
    }

    public void test_14_5_4_1__2_MatchingTemplateSpecializations() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol5 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T1", TypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        ISymbol iSymbol3 = this.table.newSymbol("I", TypeInfo.t_templateParameter);
        iSymbol3.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        iTemplateSymbol.addTemplateParameter(iSymbol3);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol4 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        ISymbol iSymbol5 = this.table.newSymbol("I", TypeInfo.t_templateParameter);
        iSymbol5.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSpecializedSymbol.addTemplateParameter(iSymbol4);
        iSpecializedSymbol.addTemplateParameter(iSymbol5);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol4);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol4, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        TypeInfo typeInfo3 = new TypeInfo(TypeInfo.t_type, 0, iSymbol5);
        iSpecializedSymbol.addArgument(typeInfo);
        iSpecializedSymbol.addArgument(typeInfo2);
        iSpecializedSymbol.addArgument(typeInfo3);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        ISpecializedSymbol iSpecializedSymbol2 = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol6 = this.table.newSymbol("T1", TypeInfo.t_templateParameter);
        ISymbol iSymbol7 = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        ISymbol iSymbol8 = this.table.newSymbol("I", TypeInfo.t_templateParameter);
        iSymbol8.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSpecializedSymbol2.addTemplateParameter(iSymbol6);
        iSpecializedSymbol2.addTemplateParameter(iSymbol7);
        iSpecializedSymbol2.addTemplateParameter(iSymbol8);
        TypeInfo typeInfo4 = new TypeInfo(TypeInfo.t_type, 0, iSymbol6, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        TypeInfo typeInfo5 = new TypeInfo(TypeInfo.t_type, 0, iSymbol7);
        TypeInfo typeInfo6 = new TypeInfo(TypeInfo.t_type, 0, iSymbol8);
        iSpecializedSymbol2.addArgument(typeInfo4);
        iSpecializedSymbol2.addArgument(typeInfo5);
        iSpecializedSymbol2.addArgument(typeInfo6);
        iSpecializedSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol2);
        ISpecializedSymbol iSpecializedSymbol3 = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol9 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSpecializedSymbol3.addTemplateParameter(iSymbol9);
        TypeInfo typeInfo7 = new TypeInfo(TypeInfo.t_int, 0, null);
        TypeInfo typeInfo8 = new TypeInfo(TypeInfo.t_type, 0, iSymbol9, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        TypeInfo typeInfo9 = new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"5");
        iSpecializedSymbol3.addArgument(typeInfo7);
        iSpecializedSymbol3.addArgument(typeInfo8);
        iSpecializedSymbol3.addArgument(typeInfo9);
        iSpecializedSymbol3.addSymbol((ISymbol)iDerivableContainerSymbol4);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol3);
        ISpecializedSymbol iSpecializedSymbol4 = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol10 = this.table.newSymbol("T1", TypeInfo.t_templateParameter);
        ISymbol iSymbol11 = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        ISymbol iSymbol12 = this.table.newSymbol("I", TypeInfo.t_templateParameter);
        iSymbol12.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iSpecializedSymbol4.addTemplateParameter(iSymbol10);
        iSpecializedSymbol4.addTemplateParameter(iSymbol11);
        iSpecializedSymbol4.addTemplateParameter(iSymbol12);
        TypeInfo typeInfo10 = new TypeInfo(TypeInfo.t_type, 0, iSymbol10);
        TypeInfo typeInfo11 = new TypeInfo(TypeInfo.t_type, 0, iSymbol11, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        TypeInfo typeInfo12 = new TypeInfo(TypeInfo.t_type, 0, iSymbol12);
        iSpecializedSymbol4.addArgument(typeInfo10);
        iSpecializedSymbol4.addArgument(typeInfo11);
        iSpecializedSymbol4.addArgument(typeInfo12);
        iSpecializedSymbol4.addSymbol((ISymbol)iDerivableContainerSymbol5);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol4);
        ITemplateSymbol iTemplateSymbol2 = (ITemplateSymbol)this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iTemplateSymbol2, (Object)iTemplateSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)new Integer(1)));
        IContainerSymbol iContainerSymbol = (IContainerSymbol)iTemplateSymbol2.instantiate(linkedList);
        Assert.assertTrue((boolean)iContainerSymbol.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"1"));
        IContainerSymbol iContainerSymbol2 = (IContainerSymbol)iTemplateSymbol2.instantiate(linkedList);
        Assert.assertTrue((boolean)iContainerSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_char, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"5"));
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iTemplateSymbol2.instantiate(linkedList);
        Assert.assertTrue((boolean)iContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol4);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList.add(new TypeInfo(TypeInfo.t_char, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"1"));
        IContainerSymbol iContainerSymbol4 = (IContainerSymbol)iTemplateSymbol2.instantiate(linkedList);
        Assert.assertTrue((boolean)iContainerSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iContainerSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol5);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false));
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null, null, (Object)"2"));
        try {
            iTemplateSymbol2.instantiate(linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_1() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        ISymbol iSymbol = iTemplateSymbol.lookup("T");
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("f");
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iSymbol = iTemplateSymbol2.lookup("T");
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("f");
        iTemplateSymbol3.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iSymbol = iTemplateSymbol3.lookup("T");
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(iSymbol, 32768, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false), false);
        iTemplateSymbol3.addSymbol((ISymbol)iParameterizedSymbol3);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("p", TypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 32768);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        IParameterizedSymbol iParameterizedSymbol4 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol3);
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_2() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("g");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        ISymbol iSymbol = iTemplateSymbol.lookup("T");
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("g");
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iSymbol = iTemplateSymbol2.lookup("T");
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("x", TypeInfo.t_float);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        try {
            this.table.getCompilationUnit().unqualifiedFunctionLookup("g", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void test_14_5_5_2__5_OrderingFunctionTemplates_3() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("h");
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        ISymbol iSymbol = iTemplateSymbol2.lookup("T");
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("h", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 32768, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, false, false), false);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("h");
        iTemplateSymbol3.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iSymbol = iTemplateSymbol3.lookup("T");
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("h", TypeInfo.t_function);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol));
        iParameterizedSymbol2.addParameter(iTemplateSymbol.instantiate(linkedList), 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iTemplateSymbol3.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("z", TypeInfo.t_type);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        ISymbol iSymbol3 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol2.setTypeSymbol(iSymbol3);
        LinkedList<TypeInfo> linkedList3 = new LinkedList<TypeInfo>();
        linkedList3.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        iSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("h", linkedList3);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        ISymbol iSymbol4 = this.table.newSymbol("z2", TypeInfo.t_type);
        iSymbol3 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iSymbol4.setTypeSymbol(iSymbol3);
        iSymbol4.getTypeInfo().setBit(true, 32768);
        linkedList3.clear();
        linkedList3.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol4));
        iSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("h", linkedList3);
        Assert.assertTrue((boolean)iSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
    }

    public void test_14_6_1__1_TemplateName() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("X");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("X", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("X");
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol2;
        Assert.assertEquals((Object)iDeferredTemplateInstance.getTemplate(), (Object)iTemplateSymbol);
        Iterator iterator = iDeferredTemplateInstance.getArguments().iterator();
        TypeInfo typeInfo = (TypeInfo)iterator.next();
        Assert.assertTrue((boolean)typeInfo.isType(TypeInfo.t_type));
        Assert.assertEquals((Object)typeInfo.getTypeSymbol(), (Object)iSymbol);
    }

    public void test_14_6_1__2_SpecializationName() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Y");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Y", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("Y");
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_int, 0, null));
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("Y", TypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = iDerivableContainerSymbol2.lookup("Y");
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        IDeferredTemplateInstance iDeferredTemplateInstance = (IDeferredTemplateInstance)iSymbol2;
        Assert.assertEquals((Object)iDeferredTemplateInstance.getTemplate(), (Object)iSpecializedSymbol);
        Iterator iterator = iDeferredTemplateInstance.getArguments().iterator();
        TypeInfo typeInfo = (TypeInfo)iterator.next();
        Assert.assertTrue((boolean)typeInfo.isType(TypeInfo.t_int));
    }

    public void test_14_6_1__4_ParameterRedeclaration() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Y");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        ISymbol iSymbol = this.table.newSymbol("i", TypeInfo.t_templateParameter);
        iSymbol.getTypeInfo().setTemplateParameterType(TypeInfo.t_int);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Y", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("T", TypeInfo.t_int);
        try {
            iDerivableContainerSymbol.addSymbol(iSymbol2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)10);
        }
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        try {
            iParameterizedSymbol.addSymbol(this.table.newSymbol("T", TypeInfo.t_char));
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)10);
        }
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("X");
        try {
            iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("X", TypeInfo.t_templateParameter));
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)9);
        }
    }

    public void test_14_7_3__5_ExplicitSpecialization() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList linkedList = new LinkedList();
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        iDerivableContainerSymbol2.setIsTemplateMember(true);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        iTemplateFactory.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, null, false);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iDerivableContainerSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iDerivableContainerSymbol3.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol4 = iDerivableContainerSymbol3.lookupMethodForDefinition("f", linkedList2);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        iParameterizedSymbol4.setTypeSymbol((ISymbol)iParameterizedSymbol3);
        iDerivableContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol3);
        iDerivableContainerSymbol3 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        iParameterizedSymbol4 = iDerivableContainerSymbol3.qualifiedFunctionLookup("f", linkedList2);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
    }

    public void test_14_7_3__11_ExplicitSpecializationArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("Array");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("Array", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("sort");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("sort", TypeInfo.t_function);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol));
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplate("Array", linkedList);
        iParameterizedSymbol.addParameter(iSymbol2, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        LinkedList linkedList2 = new LinkedList();
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("sort", linkedList2, null);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("sort", TypeInfo.t_function);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplate("Array", linkedList);
        iParameterizedSymbol2.addParameter(iSymbol2, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("sort", linkedList);
        Assert.assertTrue((boolean)iParameterizedSymbol3.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol3.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
    }

    public void test_14_7_3__12_ExplicitSpecializationOverloadedFunction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("f");
        ISymbol iSymbol2 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol2.addTemplateParameter(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol2, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iTemplateSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        LinkedList linkedList = new LinkedList();
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("f", linkedList, null);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        try {
            iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol3);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("f", linkedList, linkedList2);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol4.addParameter(TypeInfo.t_int, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol4);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("f", linkedList, linkedList2);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol5.addParameter(TypeInfo.t_char, 0, null, false);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol5);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        IParameterizedSymbol iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList2);
        Assert.assertTrue((boolean)iParameterizedSymbol6.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol6.getInstantiatedSymbol(), (Object)iParameterizedSymbol5);
    }

    public void test_14_8_2_4__5_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        ISymbol iSymbol2 = iTemplateSymbol.lookup("T");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("x", TypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        ISymbol iSymbol4 = this.table.newSymbol("y", TypeInfo.t_type);
        iSymbol4.setTypeSymbol(iSymbol2);
        iParameterizedSymbol.addParameter(iSymbol3);
        iParameterizedSymbol.addParameter(iSymbol4);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_struct);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol5 = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol5.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol6 = this.table.newSymbol("b", TypeInfo.t_type);
        iSymbol6.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        this.table.getCompilationUnit().addSymbol(iSymbol6);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol5);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol6);
        linkedList.add(typeInfo);
        linkedList.add(typeInfo2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
        linkedList.clear();
        linkedList.add(typeInfo2);
        linkedList.add(typeInfo);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
        linkedList.clear();
        linkedList.add(typeInfo);
        linkedList.add(typeInfo);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        linkedList.clear();
        linkedList.add(typeInfo2);
        linkedList.add(typeInfo2);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
    }

    public void test_14_8_2_4__6_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("U", TypeInfo.t_templateParameter));
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("", TypeInfo.t_function);
        iParameterizedSymbol.setIsTemplateMember(true);
        ISymbol iSymbol = iTemplateSymbol.lookup("T");
        ISymbol iSymbol2 = iTemplateSymbol.lookup("U");
        iParameterizedSymbol.setReturnType(iSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iParameterizedSymbol.addParameter(iSymbol2, 0, null, false);
        iParameterizedSymbol.addParameter(iSymbol2, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iParameterizedSymbol, 0, null, false);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("g1", TypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("", TypeInfo.t_int));
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol3.addParameter(TypeInfo.t_float, 0, null, false);
        iParameterizedSymbol3.addParameter(TypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("g2", TypeInfo.t_function);
        iParameterizedSymbol4.setReturnType(this.table.newSymbol("", TypeInfo.t_char));
        iParameterizedSymbol4.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol4.addParameter(TypeInfo.t_float, 0, null, false);
        iParameterizedSymbol4.addParameter(TypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol4);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("g3", TypeInfo.t_function);
        iParameterizedSymbol5.setReturnType(this.table.newSymbol("", TypeInfo.t_int));
        iParameterizedSymbol5.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol5.addParameter(TypeInfo.t_char, 0, null, false);
        iParameterizedSymbol5.addParameter(TypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol5);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, (ISymbol)iParameterizedSymbol3);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((boolean)iParameterizedSymbol6.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol6.getInstantiatedSymbol(), (Object)iParameterizedSymbol2);
        typeInfo.setTypeSymbol((ISymbol)iParameterizedSymbol4);
        iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol6, null);
        typeInfo.setTypeSymbol((ISymbol)iParameterizedSymbol5);
        iParameterizedSymbol6 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol6, null);
    }

    public void test_14_8_2_4__7_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("f");
        ISymbol iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(iSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, true, false), false);
        iTemplateSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("p", TypeInfo.t_int);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol2));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((iParameterizedSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol3 = iParameterizedSymbol2;
        Iterator iterator = iParameterizedSymbol3.getParameterList().iterator();
        ISymbol iSymbol3 = (ISymbol)iterator.next();
        Assert.assertTrue((boolean)iSymbol3.isType(TypeInfo.t_int));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iSymbol3.getTypeInfo().getPtrOperators().iterator();
        TypeInfo.PtrOp ptrOp = (TypeInfo.PtrOp)iterator.next();
        Assert.assertTrue((boolean)ptrOp.isConst());
        Assert.assertEquals((Object)ptrOp.getType(), (Object)TypeInfo.PtrOp.t_pointer);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void test_14_8_2_4__8_ArgumentDeduction() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("B");
        iTemplateSymbol.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B", TypeInfo.t_struct);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        ITemplateSymbol iTemplateSymbol2 = this.table.newTemplateSymbol("D");
        iTemplateSymbol2.addTemplateParameter(this.table.newSymbol("T", TypeInfo.t_templateParameter));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("D", TypeInfo.t_struct);
        iTemplateSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = iTemplateSymbol2.lookup("T");
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol));
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookupTemplate("B", linkedList);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        Assert.assertEquals((Object)((IDeferredTemplateInstance)iSymbol2).getTemplate(), (Object)iTemplateSymbol);
        iDerivableContainerSymbol2.addParent(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D2", TypeInfo.t_struct);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplate("B", linkedList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent(iSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ITemplateSymbol iTemplateSymbol3 = this.table.newTemplateSymbol("f");
        iSymbol = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iTemplateSymbol3.addTemplateParameter(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplate("B", linkedList);
        Assert.assertTrue((boolean)(iSymbol2 instanceof IDeferredTemplateInstance));
        Assert.assertEquals((Object)((IDeferredTemplateInstance)iSymbol2).getTemplate(), (Object)iTemplateSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("", TypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol2);
        iSymbol3.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference));
        iParameterizedSymbol.addParameter(iSymbol3);
        iTemplateSymbol3.addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("d", TypeInfo.t_type);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol2 = this.table.getCompilationUnit().lookupTemplate("D", linkedList);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol4.setTypeSymbol(iSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol4);
        ISymbol iSymbol5 = this.table.newSymbol("d2", TypeInfo.t_type);
        iSymbol5.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol5);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol4));
        iSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((iSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol5));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((iParameterizedSymbol2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iParameterizedSymbol2.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol2.getInstantiatedSymbol(), (Object)iParameterizedSymbol);
        Assert.assertEquals((Object)iSymbol2, (Object)iParameterizedSymbol2);
    }

    public void testPartialSpecializationDefinitions() throws Exception {
        this.newTable();
        ITemplateSymbol iTemplateSymbol = this.table.newTemplateSymbol("A");
        ISymbol iSymbol = this.table.newSymbol("T1", TypeInfo.t_templateParameter);
        ISymbol iSymbol2 = this.table.newSymbol("T2", TypeInfo.t_templateParameter);
        iTemplateSymbol.addTemplateParameter(iSymbol);
        iTemplateSymbol.addTemplateParameter(iSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iTemplateSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iTemplateSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ISpecializedSymbol iSpecializedSymbol = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol3 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSpecializedSymbol.addTemplateParameter(iSymbol3);
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        iSpecializedSymbol.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol3));
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iSpecializedSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.setIsForwardDeclaration(true);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        ISpecializedSymbol iSpecializedSymbol2 = this.table.newSpecializedSymbol("A");
        ISymbol iSymbol4 = this.table.newSymbol("T", TypeInfo.t_templateParameter);
        iSpecializedSymbol2.addTemplateParameter(iSymbol4);
        iSpecializedSymbol2.addArgument(new TypeInfo(TypeInfo.t_char, 0, null));
        iSpecializedSymbol2.addArgument(new TypeInfo(TypeInfo.t_type, 0, iSymbol4));
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iSpecializedSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iTemplateSymbol.addSpecialization(iSpecializedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.setIsForwardDeclaration(true);
        iDerivableContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol5 = this.table.newSymbol("U", TypeInfo.t_templateParameter);
        ISymbol iSymbol6 = this.table.newSymbol("V", TypeInfo.t_templateParameter);
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        linkedList.add(iSymbol5);
        linkedList.add(iSymbol6);
        LinkedList<TypeInfo> linkedList2 = new LinkedList<TypeInfo>();
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol5));
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol6));
        ITemplateFactory iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        IParameterizedSymbol iParameterizedSymbol4 = iTemplateFactory.lookupMemberFunctionForDefinition("f", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setTypeSymbol((ISymbol)iParameterizedSymbol5);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol5);
        ISymbol iSymbol7 = this.table.newSymbol("c", TypeInfo.t_int);
        iParameterizedSymbol5.addSymbol(iSymbol7);
        linkedList.clear();
        linkedList2.clear();
        ISymbol iSymbol8 = this.table.newSymbol("W", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol8);
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol8));
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol8));
        iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        iParameterizedSymbol4 = iTemplateFactory.lookupMemberFunctionForDefinition("f", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.setTypeSymbol((ISymbol)iParameterizedSymbol6);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol6);
        ISymbol iSymbol9 = this.table.newSymbol("c", TypeInfo.t_char);
        iParameterizedSymbol6.addSymbol(iSymbol9);
        linkedList.clear();
        linkedList2.clear();
        ISymbol iSymbol10 = this.table.newSymbol("X", TypeInfo.t_templateParameter);
        linkedList.add(iSymbol10);
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        linkedList2.add(new TypeInfo(TypeInfo.t_type, 0, iSymbol10));
        iTemplateFactory = this.table.getCompilationUnit().lookupTemplateForMemberDefinition("A", linkedList, linkedList2);
        iParameterizedSymbol4 = iTemplateFactory.lookupMemberFunctionForDefinition("f", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol7 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.setTypeSymbol((ISymbol)iParameterizedSymbol7);
        iTemplateFactory.addSymbol((ISymbol)iParameterizedSymbol7);
        ISymbol iSymbol11 = this.table.newSymbol("c", TypeInfo.t_float);
        iParameterizedSymbol7.addSymbol(iSymbol11);
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f", new LinkedList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol5);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c");
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol7);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(TypeInfo.t_int));
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol2);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f", new LinkedList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol6);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c");
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol9);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(TypeInfo.t_char));
        linkedList2.clear();
        linkedList2.add(new TypeInfo(TypeInfo.t_char, 0, null));
        linkedList2.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iParameterizedSymbol4 = this.table.getCompilationUnit().lookupTemplate("A", linkedList2);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iDerivableContainerSymbol3);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedFunctionLookup("f", new LinkedList());
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iParameterizedSymbol7);
        iParameterizedSymbol4 = ((IContainerSymbol)iParameterizedSymbol4).qualifiedLookup("c");
        Assert.assertTrue((boolean)iParameterizedSymbol4.isTemplateInstance());
        Assert.assertEquals((Object)iParameterizedSymbol4.getInstantiatedSymbol(), (Object)iSymbol11);
        Assert.assertTrue((boolean)iParameterizedSymbol4.isType(TypeInfo.t_float));
    }
}

