/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCompilationUnit;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTField;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParserSymbolTableTest
extends TestCase {
    public ParserSymbolTable table = null;

    public ParserSymbolTableTest(String string) {
        super(string);
    }

    public ParserSymbolTable newTable() {
        return this.newTable(ParserLanguage.CPP, ParserMode.COMPLETE_PARSE);
    }

    public ParserSymbolTable newTable(ParserLanguage parserLanguage, ParserMode parserMode) {
        this.table = new ParserSymbolTable(parserLanguage, parserMode);
        return this.table;
    }

    public void testSimpleAdd() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x");
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol(iSymbol);
        Map map = iContainerSymbol.getContainedSymbols();
        Assert.assertEquals((int)1, (int)map.size());
        Iterator iterator = map.values().iterator();
        ISymbol iSymbol2 = (ISymbol)iterator.next();
        Assert.assertEquals((boolean)false, (boolean)iterator.hasNext());
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
        Assert.assertEquals((String)iSymbol2.getName(), (String)"x");
    }

    public void testSimpleLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookup("x");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
    }

    public void testLookupNonExistant() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("boo");
        Assert.assertEquals((Object)iSymbol, null);
    }

    public void testSimpleSetGetObject() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("x", TypeInfo.t_namespace);
        StandardSymbolExtension standardSymbolExtension = new StandardSymbolExtension((ISymbol)iContainerSymbol, null);
        iContainerSymbol.setASTExtension((ISymbolASTExtension)standardSymbolExtension);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("x");
        Assert.assertEquals((Object)iSymbol.getASTExtension(), (Object)standardSymbolExtension);
    }

    public void testHide() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x");
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("x");
        iDerivableContainerSymbol.addSymbol(iSymbol3);
        iSymbol2 = iDerivableContainerSymbol.lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        iSymbol2 = this.table.getCompilationUnit().lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
    }

    public void testContainingScopeLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x");
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
    }

    public void testParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("parent");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("class");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = iDerivableContainerSymbol2.lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
    }

    public void testAmbiguousParentLookup() throws Exception {
        this.testParentLookup();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("parent2");
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookup("class");
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        try {
            iDerivableContainerSymbol2.lookup("x");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void testCircularParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a");
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("b");
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol2);
        try {
            iDerivableContainerSymbol.lookup("foo");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)2);
        }
    }

    public void testVirtualParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class");
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("C");
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2, true, ASTAccessVisibility.PUBLIC, 3, null);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol2, true, ASTAccessVisibility.PUBLIC, 6, null);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol4);
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol4);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
    }

    public void testAmbiguousVirtualParentLookup() throws Exception {
        this.testVirtualParentLookup();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = (IDerivableContainerSymbol)iContainerSymbol.lookup("class");
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)iContainerSymbol.lookup("C");
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D");
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        try {
            iDerivableContainerSymbol.lookup("x");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void testStaticEnumParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a");
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("b");
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("c");
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("d");
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol4);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("enum", TypeInfo.t_enumeration);
        ISymbol iSymbol = this.table.newSymbol("enumerator", TypeInfo.t_enumerator);
        ISymbol iSymbol2 = this.table.newSymbol("static", TypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 128);
        ISymbol iSymbol3 = this.table.newSymbol("x", TypeInfo.t_int);
        iDerivableContainerSymbol4.addSymbol((ISymbol)iContainerSymbol2);
        iDerivableContainerSymbol4.addSymbol(iSymbol2);
        iDerivableContainerSymbol4.addSymbol(iSymbol3);
        iContainerSymbol2.addSymbol(iSymbol);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol4);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol4);
        try {
            iDerivableContainerSymbol.lookup("enumerator");
            Assert.assertTrue((boolean)true);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertTrue((boolean)false);
        }
        try {
            iDerivableContainerSymbol.lookup("static");
            Assert.assertTrue((boolean)true);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertTrue((boolean)false);
        }
        try {
            iDerivableContainerSymbol.lookup("x");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void testElaboratedLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("struct");
        iDerivableContainerSymbol2.setType(TypeInfo.t_struct);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("union");
        iContainerSymbol.setType(TypeInfo.t_union);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("class");
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("struct");
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("union");
        IDerivableContainerSymbol iDerivableContainerSymbol5 = this.table.newDerivableContainerSymbol("a");
        IDerivableContainerSymbol iDerivableContainerSymbol6 = this.table.newDerivableContainerSymbol("b");
        iDerivableContainerSymbol5.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol5.addSymbol((ISymbol)iDerivableContainerSymbol4);
        iDerivableContainerSymbol5.addSymbol((ISymbol)iContainerSymbol2);
        iDerivableContainerSymbol5.addParent((ISymbol)iDerivableContainerSymbol6);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol5);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol6);
        ISymbol iSymbol = iDerivableContainerSymbol5.elaboratedLookup(TypeInfo.t_class, "class");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol = iDerivableContainerSymbol5.elaboratedLookup(TypeInfo.t_struct, "struct");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        iSymbol = iDerivableContainerSymbol5.elaboratedLookup(TypeInfo.t_union, "union");
        Assert.assertEquals((Object)iSymbol, (Object)iContainerSymbol);
    }

    public void testDeclarationType() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A");
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("member");
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = iContainerSymbol.lookup("A");
        Assert.assertEquals((Object)iSymbol2, (Object)iContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("a");
        iSymbol3.setTypeSymbol(iSymbol2);
        iContainerSymbol.addSymbol(iSymbol3);
        iSymbol2 = iContainerSymbol.lookup("a");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iSymbol2.getTypeSymbol();
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iContainerSymbol2);
        iSymbol2 = iContainerSymbol3.lookup("member");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
    }

    public void testFunctionHidesClass() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("stat");
        iDerivableContainerSymbol.setType(TypeInfo.t_struct);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("stat");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = iParameterizedSymbol2.elaboratedLookup(TypeInfo.t_struct, "stat");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol = iParameterizedSymbol2.lookup("stat");
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
    }

    public void testUsingDirectives_1() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A");
        iContainerSymbol.setType(TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("i");
        iContainerSymbol.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("C");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("i");
        iContainerSymbol3.addSymbol(iSymbol2);
        ISymbol iSymbol3 = iContainerSymbol2.lookup("C");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        iSymbol3 = iParameterizedSymbol.lookup("i");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("D");
        iContainerSymbol4.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        iSymbol3 = iContainerSymbol4.lookup("B");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol2);
        iContainerSymbol4.addUsingDirective(iContainerSymbol2);
        iSymbol3 = iContainerSymbol4.lookup("C");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iContainerSymbol4.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f2");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iContainerSymbol4.addSymbol((ISymbol)iParameterizedSymbol2);
        try {
            iSymbol3 = iParameterizedSymbol2.lookup("i");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f3");
        iParameterizedSymbol3.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        iSymbol3 = iParameterizedSymbol3.lookup("i");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f4");
        iParameterizedSymbol4.setType(TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol4);
        iSymbol3 = iParameterizedSymbol4.lookup("i");
        Assert.assertEquals((Object)iSymbol3, null);
    }

    public void testTransitiveUsingDirective() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("M");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("i");
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("N");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("i");
        iContainerSymbol3.addSymbol(iSymbol2);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        ISymbol iSymbol3 = null;
        try {
            iSymbol3 = iParameterizedSymbol.lookup("i");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        iSymbol3 = iParameterizedSymbol.lookupNestedNameSpecifier("N");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("i");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
    }

    public void testUsing_SameDeclarationTwice() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a");
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("C");
        iContainerSymbol4.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        iContainerSymbol4.addUsingDirective(iContainerSymbol2);
        IContainerSymbol iContainerSymbol5 = this.table.newContainerSymbol("BC");
        iContainerSymbol5.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol5);
        iContainerSymbol5.addUsingDirective(iContainerSymbol3);
        iContainerSymbol5.addUsingDirective(iContainerSymbol4);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol6 = iParameterizedSymbol.lookupNestedNameSpecifier("BC");
        Assert.assertEquals((Object)iContainerSymbol6, (Object)iContainerSymbol5);
        iContainerSymbol6 = iContainerSymbol6.qualifiedLookup("a");
        Assert.assertEquals((Object)iContainerSymbol6, (Object)iSymbol);
    }

    public void testUsing_SearchedOnce() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("b");
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("A");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a");
        iContainerSymbol3.addSymbol(iSymbol2);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol4 = iParameterizedSymbol.lookupNestedNameSpecifier("A");
        Assert.assertEquals((Object)iContainerSymbol4, (Object)iContainerSymbol3);
        ISymbol iSymbol3 = iContainerSymbol4.qualifiedLookup("a");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        iSymbol3 = iContainerSymbol4.qualifiedLookup("b");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        IContainerSymbol iContainerSymbol5 = iParameterizedSymbol.lookupNestedNameSpecifier("B");
        iSymbol3 = iContainerSymbol5.qualifiedLookup("a");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        iSymbol3 = iContainerSymbol5.qualifiedLookup("b");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
    }

    public void testUsing_SearchedOnce_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        ISymbol iSymbol = iParameterizedSymbol.lookup("i");
        Assert.assertEquals((Object)iSymbol, null);
    }

    public void testNamespaceMemberHiding() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("x");
        iContainerSymbol3.setType(TypeInfo.t_struct);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol = this.table.newSymbol("x");
        iSymbol.setType(TypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("y");
        iSymbol2.setType(TypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("B");
        iContainerSymbol4.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        IContainerSymbol iContainerSymbol5 = this.table.newContainerSymbol("y");
        iContainerSymbol5.setType(TypeInfo.t_struct);
        iContainerSymbol4.addSymbol((ISymbol)iContainerSymbol5);
        IContainerSymbol iContainerSymbol6 = this.table.newContainerSymbol("C");
        iContainerSymbol6.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol6);
        ISymbol iSymbol3 = iContainerSymbol6.lookup("A");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol2);
        iContainerSymbol6.addUsingDirective(iContainerSymbol2);
        iSymbol3 = iContainerSymbol6.lookup("B");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol4);
        iContainerSymbol6.addUsingDirective(iContainerSymbol4);
        iSymbol3 = iContainerSymbol6.lookupNestedNameSpecifier("C");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol6);
        iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("x");
        Assert.assertEquals((Object)iSymbol3, (Object)iSymbol);
        iSymbol3 = iContainerSymbol6.lookupNestedNameSpecifier("C");
        Assert.assertEquals((Object)iSymbol3, (Object)iContainerSymbol6);
        try {
            iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("y");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void testLookupMemberForDefinition() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f1");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IContainerSymbol iContainerSymbol4 = iContainerSymbol.lookupNestedNameSpecifier("A");
        Assert.assertEquals((Object)iContainerSymbol2, (Object)iContainerSymbol4);
        ISymbol iSymbol = iContainerSymbol4.lookupMemberForDefinition("f1");
        Assert.assertEquals((Object)iSymbol, null);
        iSymbol = iContainerSymbol4.qualifiedLookup("f1");
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
    }

    public void testUsingDeclaration() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol.setType(TypeInfo.t_struct);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("E");
        iContainerSymbol2.setType(TypeInfo.t_enumeration);
        iDerivableContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("e");
        iSymbol.setType(TypeInfo.t_enumerator);
        iContainerSymbol2.addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("C");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D");
        iDerivableContainerSymbol3.setType(TypeInfo.t_struct);
        ISymbol iSymbol2 = iContainerSymbol.lookup("B");
        Assert.assertEquals((Object)iSymbol2, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        IContainerSymbol iContainerSymbol3 = iDerivableContainerSymbol3.lookupNestedNameSpecifier("B");
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addUsingDeclaration("f", iContainerSymbol3);
        iDerivableContainerSymbol3.addUsingDeclaration("e", iContainerSymbol3);
        iSymbol2 = iDerivableContainerSymbol3.lookupNestedNameSpecifier("C");
        Assert.assertEquals((Object)iSymbol2, (Object)iDerivableContainerSymbol2);
        try {
            iDerivableContainerSymbol3.addUsingDeclaration("g", (IContainerSymbol)iDerivableContainerSymbol2);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void testUsingDeclaration_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A", TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol3 = iContainerSymbol.lookupNestedNameSpecifier("A");
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iContainerSymbol2);
        IUsingDeclarationSymbol iUsingDeclarationSymbol = iContainerSymbol.addUsingDeclaration("f", iContainerSymbol2);
        Assert.assertEquals((int)iUsingDeclarationSymbol.getReferencedSymbols().size(), (int)1);
        Assert.assertEquals(iUsingDeclarationSymbol.getReferencedSymbols().get(0), (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = (IParameterizedSymbol)iUsingDeclarationSymbol.getDeclaredSymbols().get(0);
        iContainerSymbol3 = iContainerSymbol.lookup("A");
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol3.setType(TypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol3.addParameter(TypeInfo.t_char, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("foo");
        iParameterizedSymbol4.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol4);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_char, 0, null);
        linkedList.add(typeInfo);
        iContainerSymbol3 = iParameterizedSymbol4.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iParameterizedSymbol2);
        Assert.assertTrue((boolean)iParameterizedSymbol2.hasSameParameters(iParameterizedSymbol));
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("bar");
        iParameterizedSymbol5.setType(TypeInfo.t_function);
        iParameterizedSymbol5.addParameter(TypeInfo.t_char, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol5);
        iContainerSymbol3 = iParameterizedSymbol5.lookupNestedNameSpecifier("A");
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iContainerSymbol2);
        iUsingDeclarationSymbol = iParameterizedSymbol5.addUsingDeclaration("f", iContainerSymbol2);
        List list = iUsingDeclarationSymbol.getReferencedSymbols();
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol));
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol3));
        Assert.assertEquals((int)list.size(), (int)2);
        int n = list.indexOf(iParameterizedSymbol3);
        list = iUsingDeclarationSymbol.getDeclaredSymbols();
        iContainerSymbol3 = iParameterizedSymbol5.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertTrue((iContainerSymbol3 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)iContainerSymbol3, list.get(n));
    }

    public void testThisPointer() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class", TypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("function", TypeInfo.t_function);
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.getTypeInfo().setBit(true, 32768);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol = iParameterizedSymbol.lookup("this");
        Assert.assertTrue((iSymbol != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)iSymbol.getType(), (Object)TypeInfo.t_type);
        Assert.assertEquals((Object)iSymbol.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertTrue((boolean)iSymbol.getTypeInfo().checkBit(32768));
        Assert.assertEquals((Object)((TypeInfo.PtrOp)iSymbol.getPtrOperators().iterator().next()).getType(), (Object)TypeInfo.PtrOp.t_pointer);
        Assert.assertEquals((Object)iSymbol.getContainingSymbol(), (Object)iParameterizedSymbol);
    }

    public void testEnumerator() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("class");
        iContainerSymbol.setType(TypeInfo.t_class);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("enumeration");
        iContainerSymbol2.setType(TypeInfo.t_enumeration);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("enumerator");
        iSymbol.setType(TypeInfo.t_enumerator);
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = iContainerSymbol.lookup("enumerator");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        Assert.assertEquals((Object)iSymbol2.getContainingSymbol(), (Object)iContainerSymbol);
        Assert.assertEquals((Object)iSymbol2.getTypeSymbol(), (Object)iContainerSymbol2);
    }

    public void testArgumentDependentLookup() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("NS");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("T");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        ISymbol iSymbol = iContainerSymbol2.lookup("T");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        iSymbol = iContainerSymbol.lookupNestedNameSpecifier("NS");
        Assert.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        iSymbol = iContainerSymbol2.qualifiedLookup("T");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("parm");
        iSymbol2.setType(TypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("main");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("", TypeInfo.t_int));
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        iSymbol = iParameterizedSymbol2.lookup("parm");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        linkedList.add(typeInfo);
        iSymbol = iParameterizedSymbol2.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
    }

    public void testArgumentDependentLookup_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("NS1");
        iContainerSymbol2.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol.addParameter(TypeInfo.t_void, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("NS2");
        iContainerSymbol3.setType(TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol = iContainerSymbol3.lookup("NS1");
        Assert.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol3.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol2.addParameter(TypeInfo.t_void, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iSymbol = iContainerSymbol.lookupNestedNameSpecifier("NS2");
        Assert.assertEquals((Object)iSymbol, (Object)iContainerSymbol3);
        iSymbol = iContainerSymbol3.qualifiedLookup("B");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iSymbol = iContainerSymbol.lookup("A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a");
        iSymbol2.setType(TypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        iSymbol = iContainerSymbol.lookup("a");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
        TypeInfo typeInfo = new TypeInfo(iSymbol.getType(), 0, iSymbol, null, false);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        linkedList.add(typeInfo);
        iSymbol = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol2);
    }

    public void testFunctionOverloading() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("C");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.addParameter(TypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("foo");
        iParameterizedSymbol3.setType(TypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol3.addParameter(TypeInfo.t_char, 0, null, false);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol = iContainerSymbol.lookup("C");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("c");
        iSymbol2.setType(TypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
        iContainerSymbol.addSymbol(iSymbol2);
        iSymbol = iContainerSymbol.lookup("c");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
        Assert.assertEquals((Object)iSymbol.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_int, 0, null);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_char, 0, null);
        TypeInfo typeInfo3 = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
        linkedList.add(typeInfo2);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol2);
        linkedList.add(typeInfo3);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol3);
    }

    public void testFunctionResolution() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_char, 0, null, true);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_int, 0, null);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        linkedList.clear();
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_char, 0, null);
        linkedList.add(typeInfo2);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        linkedList.clear();
        TypeInfo typeInfo3 = new TypeInfo(TypeInfo.t_bool, 0, null);
        linkedList.add(typeInfo3);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", null);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
    }

    public void testFunctionResolution_PointersAndBaseClasses() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C");
        iDerivableContainerSymbol3.setType(TypeInfo.t_class);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol2, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a");
        iSymbol.setType(TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
        ISymbol iSymbol2 = this.table.newSymbol("c");
        iSymbol2.setType(TypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        linkedList.clear();
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo2);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
    }

    public void testFunctionResolution_TypedefsAndPointers() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("B");
        iSymbol.setType(TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol.getTypeInfo().setBit(true, 8192);
        iSymbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false));
        iContainerSymbol.addSymbol(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a");
        iSymbol2.setType(TypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("b");
        iSymbol3.setType(TypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("array");
        iSymbol4.setType(TypeInfo.t_type);
        iSymbol4.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol4.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array, false, false));
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        typeInfo.setTypeSymbol(iSymbol3);
        typeInfo.getOperatorExpressions().clear();
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.indirection);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        typeInfo.setTypeSymbol(iSymbol4);
        typeInfo.getOperatorExpressions().clear();
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
    }

    public void testUserDefinedConversionSequences() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("B");
        iParameterizedSymbol.setType(TypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iDerivableContainerSymbol2.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol2, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a");
        iSymbol.setType(TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol(iSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
    }

    public void testOverloadRanking() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol.setType(TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 32768, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false), false);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 262144, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("i");
        iSymbol.setType(TypeInfo.t_int);
        iContainerSymbol.addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("s");
        iSymbol2.setType(TypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 262144);
        iContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("main");
        iParameterizedSymbol3.setType(TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo);
        linkedList.add(typeInfo2);
        IParameterizedSymbol iParameterizedSymbol4 = null;
        try {
            iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        linkedList.clear();
        TypeInfo typeInfo3 = new TypeInfo(TypeInfo.t_int, 524288, null);
        linkedList.add(typeInfo);
        linkedList.add(typeInfo3);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        linkedList.clear();
        TypeInfo typeInfo4 = new TypeInfo(TypeInfo.t_char, 0, null);
        linkedList.add(typeInfo);
        linkedList.add(typeInfo4);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        linkedList.clear();
        typeInfo = new TypeInfo(TypeInfo.t_int, 32768, null, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, false), false);
        linkedList.add(typeInfo);
        linkedList.add(typeInfo3);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol);
    }

    public void testUserDefinedConversionByOperator() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A");
        iParameterizedSymbol.setType(TypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iDerivableContainerSymbol2.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("operator A");
        iParameterizedSymbol2.setType(TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol3.setType(TypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol2, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol = this.table.newSymbol("b");
        iSymbol.setType(TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol4 = null;
        try {
            iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C");
        iDerivableContainerSymbol3.setType(TypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("C");
        iParameterizedSymbol5.setType(TypeInfo.t_constructor);
        iParameterizedSymbol5.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        iDerivableContainerSymbol3.addConstructor(iParameterizedSymbol5);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol6.setType(TypeInfo.t_function);
        iParameterizedSymbol6.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol6);
        try {
            iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IParameterizedSymbol iParameterizedSymbol7 = this.table.newParameterizedSymbol("f");
        iParameterizedSymbol7.setType(TypeInfo.t_function);
        iParameterizedSymbol7.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol7);
        iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol7);
    }

    public void testMarkRollback() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A");
        iDerivableContainerSymbol.setType(TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ParserSymbolTable.Mark mark = this.table.setMark();
        ISymbol iSymbol = this.table.newSymbol("f");
        iDerivableContainerSymbol.addSymbol(iSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("f");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        Assert.assertTrue((boolean)this.table.rollBack(mark));
        iSymbol2 = iDerivableContainerSymbol.lookup("f");
        Assert.assertEquals((Object)iSymbol2, null);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B");
        iDerivableContainerSymbol2.setType(TypeInfo.t_class);
        mark = this.table.setMark();
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ParserSymbolTable.Mark mark2 = this.table.setMark();
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol2);
        ParserSymbolTable.Mark mark3 = this.table.setMark();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("C");
        iParameterizedSymbol.addParameter(TypeInfo.t_class, 0, null, false);
        Assert.assertEquals((int)iParameterizedSymbol.getParameterList().size(), (int)1);
        this.table.rollBack(mark3);
        Assert.assertEquals((int)iParameterizedSymbol.getParameterList().size(), (int)0);
        Assert.assertEquals((int)iDerivableContainerSymbol.getParents().size(), (int)1);
        this.table.rollBack(mark2);
        Assert.assertEquals((int)iDerivableContainerSymbol.getParents().size(), (int)0);
        Assert.assertFalse((boolean)this.table.commit(mark2));
        Assert.assertFalse((boolean)this.table.rollBack(mark2));
        iDerivableContainerSymbol2.setType(TypeInfo.t_namespace);
        mark = this.table.setMark();
        iParameterizedSymbol.addUsingDirective((IContainerSymbol)iDerivableContainerSymbol2);
        Assert.assertEquals((int)iParameterizedSymbol.getUsingDirectives().size(), (int)1);
        this.table.rollBack(mark);
        Assert.assertEquals((int)iParameterizedSymbol.getUsingDirectives().size(), (int)0);
    }

    public void testForwardClassDeclaration() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iDerivableContainerSymbol.setIsForwardDeclaration(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("A");
        ISymbol iSymbol2 = this.table.getCompilationUnit().elaboratedLookup(TypeInfo.t_class, "A");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol2);
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol3.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        iSymbol = this.table.getCompilationUnit().lookup("A");
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        Assert.assertTrue((boolean)iSymbol.isForwardDeclaration());
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("a");
        Assert.assertEquals((Object)iSymbol, (Object)iSymbol3);
        Assert.assertEquals((Object)iSymbol3.getTypeSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().elaboratedLookup(TypeInfo.t_class, "A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
    }

    public void testForwardDeclarationUsedAsFunctionParam() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        iDerivableContainerSymbol.setIsForwardDeclaration(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        iParameterizedSymbol.getTypeInfo().setBit(true, 128);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.getTypeInfo().setBit(true, 128);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a1", TypeInfo.t_type);
        iSymbol = this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol2.setTypeSymbol(iSymbol);
        iSymbol2.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("A");
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        Assert.assertTrue((boolean)iSymbol.isForwardDeclaration());
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a2", TypeInfo.t_type);
        iSymbol = this.table.getCompilationUnit().lookup("A");
        Assert.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol3);
        iSymbol3.setTypeSymbol(iSymbol);
        iSymbol3.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iDerivableContainerSymbol2.memberFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        linkedList.clear();
        typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol3);
        linkedList.add(typeInfo);
        iParameterizedSymbol3 = iDerivableContainerSymbol2.memberFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
    }

    public void testConstructors() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A", TypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("A", TypeInfo.t_constructor);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("A", TypeInfo.t_constructor);
        iParameterizedSymbol3.addParameter(TypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol2);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol3);
        Assert.assertEquals((int)iDerivableContainerSymbol.getConstructors().size(), (int)3);
        IParameterizedSymbol iParameterizedSymbol4 = (IParameterizedSymbol)iParameterizedSymbol2.clone();
        try {
            iDerivableContainerSymbol.addConstructor(iParameterizedSymbol4);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)3);
        }
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        IParameterizedSymbol iParameterizedSymbol5 = iDerivableContainerSymbol.lookupConstructor(linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol5, (Object)iParameterizedSymbol2);
    }

    public void testNamespaceAlias() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x", TypeInfo.t_int);
        iContainerSymbol.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B", TypeInfo.t_namespace);
        iContainerSymbol2.setTypeSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookup("B");
        Assert.assertEquals((Object)iSymbol2, (Object)iContainerSymbol2);
        iSymbol2 = iContainerSymbol2.lookup("x");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
    }

    public void testUsingNamespaceAlias() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B", TypeInfo.t_namespace);
        iContainerSymbol2.setTypeSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        LinkedList linkedList = new LinkedList();
        IParameterizedSymbol iParameterizedSymbol2 = iContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        this.table.getCompilationUnit().addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
    }

    public void testBadParameterInfo() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_void));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, null);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
        ISymbol iSymbol = this.table.newSymbol("", TypeInfo.t_type);
        typeInfo.setTypeSymbol(iSymbol);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, null);
    }

    public void testGetConditionalOperand_bug43106() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("b", TypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        typeInfo.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        typeInfo2.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        TypeInfo typeInfo3 = ParserSymbolTable.getConditionalOperand((TypeInfo)typeInfo, (TypeInfo)typeInfo2);
        Assert.assertEquals((Object)typeInfo3, (Object)typeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("c", TypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        TypeInfo typeInfo4 = new TypeInfo(TypeInfo.t_type, 0, iSymbol3);
        typeInfo4.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
        typeInfo3 = ParserSymbolTable.getConditionalOperand((TypeInfo)typeInfo, (TypeInfo)typeInfo4);
        Assert.assertEquals((Object)typeInfo3, null);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A", TypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("C", TypeInfo.t_constructor);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iDerivableContainerSymbol3.addConstructor(iParameterizedSymbol2);
        typeInfo.getOperatorExpressions().clear();
        typeInfo4.getOperatorExpressions().clear();
        try {
            typeInfo3 = ParserSymbolTable.getConditionalOperand((TypeInfo)typeInfo, (TypeInfo)typeInfo4);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
    }

    public void testDerivedReference() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol, false, ASTAccessVisibility.PRIVATE, 0, null);
        ISymbol iSymbol = this.table.newSymbol("b", TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("c", TypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol2, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference), false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol3);
        linkedList.clear();
        typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol2);
        linkedList.add(typeInfo);
        try {
            iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
    }

    public void testAddCopyConstructor() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("a", TypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("b", TypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_type, 0, iSymbol, null, false);
        TypeInfo typeInfo2 = new TypeInfo(TypeInfo.t_type, 0, iSymbol2, null, false);
        TypeInfo typeInfo3 = ParserSymbolTable.getConditionalOperand((TypeInfo)typeInfo, (TypeInfo)typeInfo2);
        Assert.assertEquals((Object)typeInfo3, null);
        iDerivableContainerSymbol.addCopyConstructor();
        iDerivableContainerSymbol2.addCopyConstructor();
        typeInfo3 = ParserSymbolTable.getConditionalOperand((TypeInfo)typeInfo, (TypeInfo)typeInfo2);
        Assert.assertEquals((Object)typeInfo3, (Object)typeInfo);
    }

    public void testbug43834() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_void, 0, null);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        iParameterizedSymbol.addParameter(TypeInfo.t_void, 0, null, false);
        linkedList.clear();
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
    }

    public void testBug43503_AmbiguousUsing() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("f", TypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("C", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        try {
            iContainerSymbol3.addUsingDeclaration("f");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
    }

    public void testBug43503_UnableToResolveFunction() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        try {
            this.table.getCompilationUnit().lookup("f");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            Assert.assertEquals((int)parserSymbolTableException.reason, (int)7);
        }
    }

    public void testBug44510() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("initialize", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("initialize", TypeInfo.t_function);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("initialize", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol.getTypeInfo().setIsForwardDeclaration(true);
        iParameterizedSymbol.setTypeSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("initialize", new LinkedList());
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
    }

    public void testBug46882() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(TypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        IParameterizedSymbol iParameterizedSymbol4 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
        linkedList.clear();
        iParameterizedSymbol4 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol4, null);
    }

    public void testPrefixLookup_Unqualified() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aVar", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("anotherVar", TypeInfo.t_int);
        iParameterizedSymbol.addSymbol(iSymbol2);
        List list = iParameterizedSymbol.prefixLookup(null, "a", false);
        Assert.assertTrue((list != null ? 1 : 0) != 0);
        Assert.assertEquals((int)list.size(), (int)2);
        Assert.assertTrue((boolean)list.contains(iSymbol));
        Assert.assertTrue((boolean)list.contains(iSymbol2));
    }

    public void testPrefixLookup_Qualified() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aVar", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("D", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("aField", TypeInfo.t_int);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("aMethod", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        List list = iDerivableContainerSymbol.prefixLookup(null, "a", true);
        Assert.assertTrue((list != null ? 1 : 0) != 0);
        Assert.assertEquals((int)list.size(), (int)2);
        Assert.assertTrue((!list.contains(iSymbol) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains(iSymbol2));
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol));
    }

    public void testPrefixLookup_Inheritance() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("aVar", TypeInfo.t_int);
        ISymbol iSymbol2 = this.table.newSymbol("anotherVar", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("af", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("anotherVar", TypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("af", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        List list = iDerivableContainerSymbol2.prefixLookup(null, "a", true);
        Assert.assertTrue((list != null ? 1 : 0) != 0);
        Assert.assertEquals((int)list.size(), (int)3);
        Assert.assertTrue((!list.contains(iSymbol2) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(iParameterizedSymbol) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains(iSymbol));
        Assert.assertTrue((boolean)list.contains(iSymbol3));
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol2));
    }

    public void testPrefixLookup_Ambiguities() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aa", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("U", TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a", TypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("V", TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a", TypeInfo.t_int);
        iContainerSymbol3.addSymbol(iSymbol3);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("W", TypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        ISymbol iSymbol4 = this.table.newSymbol("a", TypeInfo.t_int);
        iContainerSymbol4.addSymbol(iSymbol4);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol4);
        List list = iParameterizedSymbol.prefixLookup(null, "a", false);
        Assert.assertTrue((list != null ? 1 : 0) != 0);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iSymbol));
    }

    public void testQualifiedUnqualifiedLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("i", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        Assert.assertEquals(null, (Object)iDerivableContainerSymbol.qualifiedLookup("i"));
        Assert.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol.lookup("i"));
    }

    public void testVisibilityDetermination() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("D", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        ISymbol iSymbol = this.table.newSymbol("i", TypeInfo.t_int);
        ISymbol iSymbol2 = this.table.newSymbol("j", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = iDerivableContainerSymbol2.lookupForFriendship("D");
        Assert.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addFriend(iSymbol3);
        iDerivableContainerSymbol2.addSymbol(iSymbol);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        ASTCompilationUnit aSTCompilationUnit = new ASTCompilationUnit((ISymbol)this.table.getCompilationUnit());
        StandardSymbolExtension standardSymbolExtension = new StandardSymbolExtension((ISymbol)this.table.getCompilationUnit(), (ASTSymbol)aSTCompilationUnit);
        this.table.getCompilationUnit().setASTExtension((ISymbolASTExtension)standardSymbolExtension);
        ASTClassSpecifier aSTClassSpecifier = new ASTClassSpecifier((ISymbol)iDerivableContainerSymbol2, ASTClassKind.CLASS, IASTClassSpecifier.ClassNameType.IDENTIFIER, ASTAccessVisibility.PUBLIC, 0, 0, 0, 0, 0, new ArrayList());
        StandardSymbolExtension standardSymbolExtension2 = new StandardSymbolExtension((ISymbol)iDerivableContainerSymbol2, (ASTSymbol)aSTClassSpecifier);
        iDerivableContainerSymbol2.setASTExtension((ISymbolASTExtension)standardSymbolExtension2);
        ASTField aSTField = new ASTField(iSymbol, null, null, null, 0, 0, 0, 0, 0, new ArrayList(), false, null, ASTAccessVisibility.PUBLIC);
        StandardSymbolExtension standardSymbolExtension3 = new StandardSymbolExtension(iSymbol, (ASTSymbol)aSTField);
        iSymbol.setASTExtension((ISymbolASTExtension)standardSymbolExtension3);
        aSTField = new ASTField(iSymbol, null, null, null, 0, 0, 0, 0, 0, new ArrayList(), false, null, ASTAccessVisibility.PRIVATE);
        standardSymbolExtension3 = new StandardSymbolExtension(iSymbol2, (ASTSymbol)aSTField);
        iSymbol2.setASTExtension((ISymbolASTExtension)standardSymbolExtension3);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2, false, ASTAccessVisibility.PRIVATE, 0, null);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("C", TypeInfo.t_class);
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol4);
        Assert.assertTrue((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol2));
        Assert.assertFalse((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol3));
        Assert.assertTrue((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol4));
        Assert.assertTrue((boolean)iDerivableContainerSymbol.isVisible(iSymbol2, (IContainerSymbol)iDerivableContainerSymbol2));
        Assert.assertFalse((boolean)iDerivableContainerSymbol.isVisible(iSymbol2, (IContainerSymbol)iDerivableContainerSymbol3));
    }

    public void testPrefixFiltering() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a1", TypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("aFoo", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol = this.table.newSymbol("aa", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A2", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("a3", TypeInfo.t_struct);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("a3", TypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("aF", TypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("aLocal", TypeInfo.t_int);
        iParameterizedSymbol3.addSymbol(iSymbol3);
        List list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.STRUCTURES), "A", false);
        Assert.assertEquals((int)list.size(), (int)3);
        Assert.assertTrue((boolean)list.contains(iDerivableContainerSymbol));
        Assert.assertTrue((boolean)list.contains(iDerivableContainerSymbol2));
        Assert.assertTrue((boolean)list.contains(iDerivableContainerSymbol3));
        list = iParameterizedSymbol3.prefixLookup(null, "a", false);
        Assert.assertEquals((int)list.size(), (int)7);
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol2));
        Assert.assertTrue((boolean)list.contains(iDerivableContainerSymbol2));
        Assert.assertTrue((boolean)list.contains(iSymbol2));
        Assert.assertTrue((boolean)list.contains(iDerivableContainerSymbol));
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol));
        Assert.assertTrue((boolean)list.contains(iSymbol));
        Assert.assertTrue((boolean)list.contains(iSymbol3));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.FUNCTIONS), "a", false);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.METHODS), "a", false);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iParameterizedSymbol2));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.LOCAL_VARIABLES), "a", false);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iSymbol3));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.VARIABLES), "a", false);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iSymbol));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.FIELDS), "a", false);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertTrue((boolean)list.contains(iSymbol2));
    }

    public void testBug43110_Ellipses() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iParameterizedSymbol.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_int, 0, null);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol, (Object)iParameterizedSymbol2);
    }

    public void testBug43110_EllipsesRanking() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iParameterizedSymbol.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        TypeInfo typeInfo = new TypeInfo(TypeInfo.t_int, 0, null);
        linkedList.add(typeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol3);
    }

    public void testBug43110_ElipsesRanking_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iParameterizedSymbol2.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList linkedList = new LinkedList();
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol, (Object)iParameterizedSymbol3);
    }

    public void testIterator_1() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("global", TypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A", TypeInfo.t_constructor);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("var", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        Iterator iterator = this.table.getCompilationUnit().getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iSymbol);
        IContainerSymbol iContainerSymbol = (IContainerSymbol)iterator.next();
        Assert.assertEquals((Object)iContainerSymbol, (Object)iDerivableContainerSymbol);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol.getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        Assert.assertEquals(iterator.next(), (Object)iSymbol2);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testIterator_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo", TypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A", TypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("bar", TypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("bar", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter(TypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addCopyConstructor();
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("func", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol4);
        IUsingDirectiveSymbol iUsingDirectiveSymbol = iParameterizedSymbol4.addUsingDirective(iContainerSymbol);
        Iterator iterator = this.table.getCompilationUnit().getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = (IContainerSymbol)iterator.next();
        Assert.assertEquals((Object)iContainerSymbol2, (Object)iContainerSymbol);
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iterator.next();
        Assert.assertEquals((Object)iContainerSymbol3, (Object)iDerivableContainerSymbol);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol2.getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol3);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol3.getContentsIterator();
        ISymbol iSymbol = (ISymbol)iterator.next();
        Assert.assertTrue((boolean)(iSymbol instanceof IParameterizedSymbol));
        Assert.assertEquals((String)iSymbol.getName(), (String)"B");
        Assert.assertEquals((Object)iSymbol.getType(), (Object)TypeInfo.t_constructor);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol4);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iParameterizedSymbol4.getContentsIterator();
        ISymbol iSymbol2 = (ISymbol)iterator.next();
        Assert.assertEquals((String)iSymbol2.getName(), (String)"this");
        Assert.assertEquals((Object)iSymbol2.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        Assert.assertEquals(iterator.next(), (Object)iUsingDirectiveSymbol);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testLongLong() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0x800000, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 524288, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 524288, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0x800000, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
    }

    public void testComplex() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_float, 0x200000, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t_float, 0x200000, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_float, 0, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_float, 0x200000, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_float, 0x400000, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
    }

    public void test_Bool() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t__Bool, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        linkedList.add(new TypeInfo(TypeInfo.t__Bool, 0, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        linkedList.clear();
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
    }

    public void testBug47636FunctionParameterComparisons_1() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("Int", TypeInfo.t_type);
        iSymbol.getTypeInfo().setBit(true, 8192);
        iSymbol.setTypeSymbol(this.table.newSymbol("", TypeInfo.t_int));
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, null, false);
        Assert.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
    }

    public void testBug47636FunctionParameterComparisons_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_char, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_char, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array), false);
        Assert.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
    }

    public void testBug47636FunctionParameterComparisons_3() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("", TypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("", TypeInfo.t_int));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("h", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iParameterizedSymbol, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("h", TypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iParameterizedSymbol, 0, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer), false);
        Assert.assertTrue((boolean)iParameterizedSymbol2.hasSameParameters(iParameterizedSymbol3));
    }

    public void testBug47636FunctionParameterComparisons_4() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol.addParameter(TypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 32768, null, false);
        Assert.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
    }

    public void testBug52111RemoveSymbol() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A", TypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("i", TypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f", TypeInfo.t_function);
        iParameterizedSymbol2.addParameter(TypeInfo.t_int, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B", TypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = iDerivableContainerSymbol2.qualifiedLookup("i");
        Assert.assertEquals((Object)iSymbol2, (Object)iSymbol);
        Iterator iterator = iDerivableContainerSymbol.getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iSymbol);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iDerivableContainerSymbol.removeSymbol(iSymbol));
        iterator = iDerivableContainerSymbol.getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        Assert.assertFalse((boolean)iterator.hasNext());
        iSymbol2 = iDerivableContainerSymbol2.qualifiedLookup("i");
        Assert.assertNull((Object)iSymbol2);
        LinkedList<TypeInfo> linkedList = new LinkedList<TypeInfo>();
        iSymbol2 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iSymbol2, (Object)iParameterizedSymbol);
        Assert.assertTrue((boolean)iDerivableContainerSymbol.removeSymbol((ISymbol)iParameterizedSymbol));
        iterator = iDerivableContainerSymbol.getContentsIterator();
        Assert.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        Assert.assertFalse((boolean)iterator.hasNext());
        iSymbol2 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertNull((Object)iSymbol2);
        linkedList.add(new TypeInfo(TypeInfo.t_int, 0, null));
        iSymbol2 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertEquals((Object)iSymbol2, (Object)iParameterizedSymbol2);
        Assert.assertTrue((boolean)iDerivableContainerSymbol.removeSymbol((ISymbol)iParameterizedSymbol2));
        iterator = iDerivableContainerSymbol.getContentsIterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        iSymbol2 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f", linkedList);
        Assert.assertNull((Object)iSymbol2);
        Assert.assertEquals((int)iDerivableContainerSymbol.getContainedSymbols().size(), (int)0);
    }
}

